/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.WSSCException;
import com.kingdee.eas.base.wssc.app.AbstractAdminOrgUnitUserFacadeControllerBean;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class AdminOrgUnitUserFacadeControllerBean
extends AbstractAdminOrgUnitUserFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.AdminOrgUnitUserFacadeControllerBean");

    EntityViewInfo buildViewInfo(Context ctx, String currentOrgId, String sorter, String sorterType, String user) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sic = new SorterItemCollection();
        viewInfo.setSorter(sic);
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SelectorItemInfo name = new SelectorItemInfo("name");
        viewInfo.getSelector().add(name);
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("type"));
        viewInfo.getSelector().add(new SelectorItemInfo("person.email"));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)currentOrgId));
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        try {
            adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(currentOrgId));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        boolean isAdmin = false;
        if (adminOrgUnitInfo != null) {
            String longNumber = adminOrgUnitInfo.getLongNumber();
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
            isAdmin = true;
        }
        if (!StringUtils.isEmpty((String)user)) {
            user = user.toLowerCase();
            String filterStr = "lower(number) like '%" + user + "%' or lower(name) like '%" + user + "%' or lower(adminOrgUnit.name) like '%" + user + "%'";
            try {
                FilterInfo userFilterInfo = new FilterInfo(filterStr);
                viewInfo.getFilter().mergeFilter(userFilterInfo, "AND");
            }
            catch (ParserException e) {
                logger.error((Object)("********filterStr********" + filterStr));
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (isAdmin) {
                filter.setMaskString("(#0 or #1) and (#2 or #3 or #4)");
            } else {
                filter.setMaskString("#0 and (#1 or #2 or #3)");
            }
        } else if (isAdmin) {
            filter.setMaskString("(#0 or #1)");
        }
        SorterItemInfo sorterInfo = new SorterItemInfo(sorter);
        sorterInfo.setSortType("desc".equalsIgnoreCase(sorterType) ? SortType.DESCEND : SortType.ASCEND);
        sic.getSorter().add(sorterInfo);
        return viewInfo;
    }

    IQueryExecutor getQueryExecutor(Context ctx, String orgId, String sorter, String sorterType, String user) {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.AdminOrgUnitUserQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(this.buildViewInfo(ctx, orgId, sorter, sorterType, user));
        return queryExcu;
    }

    @Override
    protected String _getUserByAdminOrg(Context ctx, String solutionInfo) throws BOSException, EASBizException {
        HashMap solutionMap = JSONUtils.convertJsonToObject((Context)ctx, (String)solutionInfo);
        String type = (String)solutionMap.get("type");
        if ("creditUser".equals(type)) {
            try {
                String userId = (String)solutionMap.get("userId");
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo("where id='" + userId + "'");
                if (userInfo != null) {
                    String sql = "SELECT DISTINCT pmuser.FNumber AS userAccount, pmuser.FName_l2 AS userName,CU.fid as orgid,CU.FName_l2 AS orgName,CU.fnumber as orgNumber,CU.FParentID as parentOrgId,PERSON.femail as email FROM T_PM_User AS pmuser ";
                    sql = sql + "INNER JOIN T_ORG_CtrlUnit AS  CU ON pmuser.FControlUnitID = CU.FID ";
                    sql = sql + "INNER JOIN T_BD_Person AS PERSON ON pmuser.FPersonId = PERSON.FID ";
                    sql = sql + "INNER JOIN T_ORG_PositionMember AS POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPersonID ";
                    sql = sql + "INNER JOIN T_ORG_Position AS POSITION ON POSITIONMEMBER.FPositionID = POSITION.FID ";
                    sql = sql + "INNER JOIN T_ORG_Admin AS ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID ";
                    IRowSet set = DbUtil.executeQuery((Context)ctx, (String)(sql = sql + "WHERE POSITIONMEMBER.FIsPrimary = 1 AND pmuser.FForbidden = 0 AND pmuser.FIsDelete = 0 AND pmuser.FID='" + userId + "'"));
                    if (set.next()) {
                        String userAccount = set.getString("userAccount");
                        String userName = set.getString("userName");
                        String orgid = set.getString("orgid");
                        String orgName = set.getString("orgName");
                        String orgNumber = set.getString("orgNumber");
                        String parentOrgId = set.getString("parentOrgId");
                        String userEmail = set.getString("email");
                        String params = this.getCreditFilesUtilParams(ctx, userAccount, userName, orgid, orgName, orgNumber, parentOrgId, userEmail, (String)solutionMap.get("extendERPId"), userId);
                        return params;
                    }
                    throw new EASBizException(WSSCException.UNKNOW, new Object[]{"[userId:" + userId + "]\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"});
                }
            }
            catch (Exception e) {
                throw new EASBizException(WSSCException.UNKNOW, (Throwable)e, new Object[]{"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38"});
            }
        }
        String orgId = (String)solutionMap.get("orgId");
        String startIndex = (String)solutionMap.get("startIndex");
        String rowCount = (String)solutionMap.get("rowCount");
        String sorter = (String)solutionMap.get("sorter");
        String sorterType = (String)solutionMap.get("sorterType");
        String user = (String)solutionMap.get("user");
        Object returnSQL = solutionMap.get("returnSQL");
        String isAllStr = solutionMap.get("isAll") + "";
        Boolean isAll = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isAllStr) || "null".equals(isAllStr) ? false : (Boolean)solutionMap.get("isAll");
        IQueryExecutor queryExcu = this.getQueryExecutor(ctx, orgId, sorter, sorterType, user);
        if (returnSQL != null && Boolean.valueOf(returnSQL.toString()).booleanValue()) {
            return queryExcu.getSQL();
        }
        IRowSet rowSet = null;
        rowSet = isAll != false ? queryExcu.executeQuery() : queryExcu.executeQuery(Integer.parseInt(startIndex), Integer.parseInt(rowCount));
        int totalCount = queryExcu.getRowCount();
        ArrayList userList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", rowSet.getString("id"));
                map.put("number", rowSet.getString("number"));
                map.put("name", rowSet.getString("name"));
                map.put("personId", rowSet.getString("person.id"));
                map.put("adminOrgUnitId", rowSet.getString("adminOrgUnit.id"));
                map.put("adminOrgUnitName", rowSet.getString("adminOrgUnit.name"));
                map.put("type", rowSet.getInt("type"));
                map.put("email", rowSet.getString("person.email"));
                userList.add(map);
            }
            logger.error((Object)("******_getUserByAdminOrg******userList.size=" + userList.size()));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("records", String.valueOf(totalCount));
        result.put("rows", userList);
        return JSONUtils.convertObjectToJson((Context)ctx, result);
    }

    private String getCreditFilesUtilParams(Context ctx, String userAccount, String userName, String orgid, String orgName, String orgNumber, String parentOrgId, String userEmail, String extendERPId, String userId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userAccount", userAccount);
        map.put("userName", userName);
        map.put("orgid", orgid);
        map.put("orgName", orgName);
        map.put("orgNumber", orgNumber);
        map.put("parentOrgId", parentOrgId);
        map.put("userEmail", userEmail);
        map.put("extendERPId", extendERPId);
        map.put("userId", userId);
        JSONObject jsonObj = new JSONObject(map);
        return jsonObj.toString();
    }
}

