/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.ssc.app.erp.eas.EASWebServiceHandler;
import com.kingdee.eas.base.wssc.LoginSSCCfgFactory;
import com.kingdee.eas.base.wssc.LoginSSCCfgInfo;
import com.kingdee.eas.base.wssc.WSSCException;
import com.kingdee.eas.base.wssc.app.AbstractLoginSSCCfgControllerBean;
import com.kingdee.eas.base.wssc.app.sscLogin.SSCLoginProxy;
import com.kingdee.eas.base.wssc.app.sscLogin.SSCLoginProxyServiceLocator;
import com.kingdee.eas.base.wssc.app.sscLogin.SSContext;
import com.kingdee.eas.base.wssc.app.util.WSSCCacheManager;
import com.kingdee.eas.base.wssc.util.H;
import com.kingdee.eas.base.wssc.util.MD5Utils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class LoginSSCCfgControllerBean
extends AbstractLoginSSCCfgControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.LoginSSCCfgControllerBean");

    public void save(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.beforSave(ctx, model);
        super.save(ctx, pk, model);
        WSSCCacheManager.clearCache();
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.beforSave(ctx, model);
        IObjectPK pk = super.save(ctx, model);
        WSSCCacheManager.clearCache();
        return pk;
    }

    private void beforSave(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        LoginSSCCfgInfo info = (LoginSSCCfgInfo)model;
        if (info.getPassword().equals(MD5Utils.keyHolder) && LoginSSCCfgFactory.getLocalInstance(ctx).exists(H.PK(info.getId()))) {
            LoginSSCCfgInfo loginSSCCfgInfo = LoginSSCCfgFactory.getLocalInstance(ctx).getLoginSSCCfgInfo(H.PK(info.getId()));
            info.setPassword(loginSSCCfgInfo.getPassword());
        }
        LoginSSCCfgControllerBean.testConnect((CoreBaseInfo)info);
        try {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)info.getPassword()) && info.getPassword().equals(MD5Utils.md5Decode(info.getPassword()))) {
                info.setPassword(MD5Utils.md5Encode(info.getPassword()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static void testConnect(CoreBaseInfo model) throws WSSCException {
        if (EASWebServiceHandler.DPLOY_TYPE_UNION.equals(model.get("deployType"))) {
            return;
        }
        String ip = (String)model.get("sscIP");
        String port = (String)model.get("sscPort");
        String dcName = (String)model.get("dCenter");
        String userName = (String)model.get("eASUserName");
        String dbType = (String)model.get("dBType");
        String password = model.get("password") == null ? "" : (String)model.get("password");
        try {
            password = MD5Utils.md5Decode(password);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String slnName = "eas";
        String language = "L2";
        String loginWsdl = "http://" + ip + ":" + port + "/ormrpc/services/EASLogin?wsdl";
        SSCLoginProxyServiceLocator locator = new SSCLoginProxyServiceLocator();
        logger.info((Object)("eas Login wsdl URL:" + loginWsdl));
        locator.setSSCLoginEndpointAddress(loginWsdl);
        locator.setMaintainSession(true);
        try {
            SSCLoginProxy loginProxy = locator.getSSCLogin();
            SSContext ctx = loginProxy.login(userName, password, slnName, dcName, language, Integer.parseInt(dbType));
            String sessionID = ctx.getSessionId();
            if (StringUtils.isEmpty((String)sessionID)) {
                throw new WSSCException(WSSCException.WRONG_CINFIG);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)"login SSC Fail!");
            throw new WSSCException(WSSCException.WRONG_CINFIG);
        }
    }
}

