/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.app.AbstractPiaoFacadeControllerBean;
import com.kingdee.eas.base.wssc.piao.cache.PiaoCache;
import com.kingdee.eas.base.wssc.piao.pojo.PiaoBillInfo;
import com.kingdee.eas.base.wssc.util.H;
import com.kingdee.eas.base.wssc.util.MD5;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class PiaoFacadeControllerBean
extends AbstractPiaoFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.wssc.app.PiaoFacadeControllerBean");

    public JSONObject getUserKeyParam(Context ctx, String billId, String billNumber, String companyId, String userId, String random) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((CharSequence)companyId)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, companyId);
        String clientId = companyInfo.get("authorizationCode").toString();
        String clientSecret = companyInfo.get("authorizationKey").toString();
        String taxpayerId = companyInfo.getTaxNumber();
        String registeredCode = companyInfo.getRegisteredCode();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5236\u5355\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Object creator = null;
        if (creator != null) {
            userId = creator.getId().toString();
        }
        logger.error((Object)("###############wssc-piao showCloudInvoice SelectCloudInvoice clientId=" + clientId + " clientSecret=" + clientSecret + " taxNumber=" + taxpayerId + " registeredCode=" + registeredCode));
        if (taxpayerId == null || taxpayerId.isEmpty() || taxpayerId == "") {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a"));
        }
        String billType = this.getBillType(ctx, billId);
        String ticketParam = "1111";
        Long timeStamp = this.getTimeStamp();
        JSONObject retunObject = new JSONObject();
        retunObject.put("client_id", (Object)clientId);
        retunObject.put("bxd_key", (Object)billId);
        retunObject.put("sign", (Object)this.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        retunObject.put("eid", (Object)userId);
        retunObject.put("timestamp", (Object)timeStamp);
        retunObject.put("tin", (Object)taxpayerId);
        retunObject.put("ghf_mc", (Object)registeredCode);
        retunObject.put("random", (Object)random);
        retunObject.put("billNumber", (Object)billNumber);
        retunObject.put("billType", (Object)billType);
        retunObject.put("ticketParam", (Object)ticketParam);
        retunObject.put("resource", (Object)2);
        return retunObject;
    }

    public Long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public String getBillType(Context ctx, String billId) {
        return "";
    }

    public CompanyOrgUnitInfo getCompanyInfo(Context ctx, String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(H.PK(companyId));
        this.checkCompanyOrgUnit(ctx, companyInfo);
        return companyInfo;
    }

    private void checkCompanyOrgUnit(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException {
        Object authorizationCode = companyInfo.get("authorizationCode");
        if (authorizationCode == null || StringUtils.isEmpty((CharSequence)authorizationCode.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u516c\u53f8\u914d\u7f6e\u6388\u6743\u7801"));
        }
        Object authorizationKey = companyInfo.get("authorizationKey");
        if (authorizationKey == null || StringUtils.isEmpty((CharSequence)authorizationKey.toString())) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8bf7\u516c\u53f8\u914d\u7f6e\u6388\u6743\u5bc6\u94a5"));
        }
    }

    public String getSaveInvoiceSigniture(String clientId, String clientSecret, Long timeStamp) {
        return MD5.md5crypt(clientId + clientSecret + timeStamp);
    }

    @Override
    protected Map _getBaseInvoiceUrl(Context ctx, Map spareMap) throws BOSException, EASBizException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        if ("true".equalsIgnoreCase(PiaoCache.getPiaoConfig(ctx, "usetest"))) {
            returnMap.put("apiPiaoZone", PiaoCache.getPiaoConfig(ctx, "tokenrul_test"));
            returnMap.put("invoiceUrl", PiaoCache.getPiaoConfig(ctx, "invoiceurl_test"));
        } else {
            returnMap.put("apiPiaoZone", PiaoCache.getPiaoConfig(ctx, "tokenrul"));
            returnMap.put("invoiceUrl", PiaoCache.getPiaoConfig(ctx, "invoiceurl"));
        }
        return returnMap;
    }

    @Override
    protected Map _getAccessToken(Context ctx, PiaoBillInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, baseInfo.getCompanyId());
        String clientId = companyInfo.get("authorizationCode").toString();
        String clientSecret = companyInfo.get("authorizationKey").toString();
        String taxpayerId = companyInfo.getTaxNumber();
        String registeredCode = companyInfo.getRegisteredCode();
        Long timeStamp = this.getTimeStamp();
        String sign = this.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp);
        JSONObject tokenJson = new JSONObject();
        tokenJson.put("client_id", (Object)clientId);
        tokenJson.put("sign", (Object)sign);
        tokenJson.put("timestamp", (Object)timeStamp);
        logger.error((Object)("###########start invoiceCloudGui getAccessToken retunObject=" + tokenJson));
        String token = PiaoFacadeControllerBean.getAccessToken(ctx, tokenJson);
        logger.error((Object)("###########end invoiceCloudGui getAccessToken token=" + token));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("token", token);
        return returnMap;
    }

    public static String getAccessTokenBaseURL(Context ctx) throws BOSException {
        if ("true".equalsIgnoreCase(PiaoCache.getPiaoConfig(ctx, "usetest"))) {
            return PiaoCache.getPiaoConfig(ctx, "tokenrul_test");
        }
        return PiaoCache.getPiaoConfig(ctx, "tokenrul");
    }

    public static String getInvoiceBaseURL(Context ctx) throws BOSException {
        if ("true".equalsIgnoreCase(PiaoCache.getPiaoConfig(ctx, "usetest"))) {
            return PiaoCache.getPiaoConfig(ctx, "invoiceurl_test");
        }
        return PiaoCache.getPiaoConfig(ctx, "invoiceurl");
    }

    public static String getAccessToken(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String description = "";
        String url = PiaoFacadeControllerBean.getAccessTokenBaseURL(ctx) + "/base/oauth/token";
        String result = PiaoFacadeControllerBean.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        try {
            JSONObject parseObject = JSONObject.parseObject((String)result);
            if (!"0000".equals(parseObject.get((Object)"errcode"))) {
                description = parseObject.getString("description");
                throw new EASBizException(new NumericExceptionSubItem("00", description));
            }
            result = parseObject.getString("access_token");
            return result;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", description), (Throwable)e);
        }
    }

    @Override
    protected Map _getUserKey(Context ctx, PiaoBillInfo baseInfo, Map spareMap) throws BOSException, EASBizException {
        if (spareMap == null) {
            spareMap = new HashMap<String, Long>();
            spareMap.put("random", System.currentTimeMillis());
        }
        if (spareMap != null && spareMap.get("random") == null) {
            spareMap.put("random", System.currentTimeMillis());
        }
        JSONObject retunObject = this.getUserKeyParam(ctx, baseInfo.getId(), baseInfo.getNumber(), baseInfo.getCompanyId(), baseInfo.getCreatorId(), spareMap.get("random").toString());
        String userKeyJson = PiaoFacadeControllerBean.showInvoiceSigniture(ctx, retunObject);
        String userkey = JSONObject.parseObject((String)userKeyJson).getJSONObject("data").get((Object)"userKey").toString();
        logger.error((Object)("###########end invoiceCloudGui getUserKey userKey=" + userKeyJson));
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("userKey", userkey);
        returnMap.put("userKeyJson", userKeyJson);
        returnMap.put("easLog", retunObject.get((Object)"easLog"));
        returnMap.put("url", PiaoFacadeControllerBean.getInvoiceBaseURL(ctx) + "/m4-web/fpzs/index?userKey=" + userkey);
        return returnMap;
    }

    public static String showInvoiceSigniture(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String url = PiaoFacadeControllerBean.getInvoiceBaseURL(ctx) + "/m4/fpzs/getUserKey";
        String result = PiaoFacadeControllerBean.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        String description = "";
        try {
            JSONObject parseObject = JSONObject.parseObject((String)result);
            if (!"0000".equals(parseObject.get((Object)"errcode"))) {
                description = parseObject.getString("description");
                throw new EASBizException(new NumericExceptionSubItem("00", description));
            }
            return result;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
    }

    public static String httpsRequestPost(String url, String param, String charset) throws EASBizException, BOSException {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            logger.error((Object)("######cpbc runner httpsRequestPost ticket url =" + url + " ticket param = " + param));
            StringEntity se = new StringEntity(param, "UTF-8");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
            se.setContentType("application/json");
            httpPost.setEntity((HttpEntity)se);
            int timeout = Integer.parseInt("30000");
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(config);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
                    logger.error((Object)("#####cpbc runner common ticket result = " + result));
                }
            } else {
                logger.error((Object)("######cpbc runner common ticket result = " + result));
            }
            return result;
        }
        catch (ConnectTimeoutException e) {
            logger.error((Object)e, (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("00", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected Map _saveTicketBill(Context ctx, PiaoBillInfo baseInfo, Map parMap) throws BOSException, EASBizException {
        JSONObject jsonObject = this.getSaveTicketBillParam(ctx, baseInfo, parMap);
        String url = PiaoFacadeControllerBean.getInvoiceBaseURL(ctx) + "/m4/fpzs/expense/entry/save";
        String result = PiaoFacadeControllerBean.httpsRequestPost(url, jsonObject.toString(), "utf-8");
        if (result == null) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u8c03\u7528\u53d1\u7968\u4e91\u4fdd\u5b58\u5355\u636e\u63a5\u53e3\u8fd4\u56de\u7a7a"));
        }
        JSONObject parseObject = JSONObject.parseObject((String)result);
        if (!"0000".equals(parseObject.get((Object)"errcode"))) {
            throw new EASBizException(new NumericExceptionSubItem("00", parseObject.getString("description")));
        }
        return parseObject;
    }

    public JSONObject getSaveTicketBillParam(Context ctx, PiaoBillInfo baseInfo, Map parMap) throws BOSException, EASBizException {
        ObjectUuidPK uuidPK = new ObjectUuidPK(baseInfo.getId());
        BOSObjectType bosObjectType = uuidPK.getObjectType();
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosObjectType);
        String billTypeName = entityObjectInfo.getAlias();
        String billTypeId = bosObjectType.toString();
        Long timeStamp = this.getTimeStamp();
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, baseInfo.getCompanyId());
        String clientId = companyInfo.get("authorizationCode").toString();
        String clientSecret = companyInfo.get("authorizationKey").toString();
        String taxpayerId = companyInfo.getTaxNumber();
        String registeredCode = companyInfo.getRegisteredCode();
        String userId = baseInfo.getCreatorId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5236\u5355\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo(H.PK(userId));
        String imageNumber = BillImageFacadeFactory.getLocalInstance(ctx).getImageNumber(billTypeId, baseInfo.getId(), baseInfo.getNumber());
        JSONObject retunObject = new JSONObject();
        retunObject.put("userKey", (Object)"");
        retunObject.put("eid", (Object)userId);
        retunObject.put("billTypeId", (Object)billTypeId);
        retunObject.put("bxd_key", (Object)baseInfo.getId());
        retunObject.put("client_id", (Object)clientId);
        retunObject.put("tin", (Object)taxpayerId);
        retunObject.put("billnumber", (Object)baseInfo.getNumber());
        retunObject.put("timestamp", (Object)timeStamp);
        retunObject.put("sign", (Object)this.getSaveInvoiceSigniture(clientId, clientSecret, timeStamp));
        JSONArray data = new JSONArray();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("entryid", "");
        map.put("fid", (String)new JSONArray());
        map.put("costTypeId", "");
        map.put("costTypeName", "");
        data.add(map);
        retunObject.put("data", (Object)data);
        retunObject.put("billType", (Object)billTypeName);
        retunObject.put("expensePersonId", (Object)userInfo.getId().toString());
        retunObject.put("expensePersonName", (Object)userInfo.getName());
        retunObject.put("realExpenseAmount", (Object)"0");
        retunObject.put("remark", (Object)"");
        retunObject.put("coverNumber", (Object)imageNumber);
        return retunObject;
    }

    @Override
    protected String _getSocketEnv(Context ctx, Map spareMap) throws BOSException, EASBizException {
        return "true".equalsIgnoreCase(PiaoCache.getPiaoConfig(ctx, "usetest")) ? "test" : "prod";
    }

    @Override
    protected String _getPiaoConfigInfo(Context ctx, String key) throws BOSException {
        return PiaoCache.getPiaoConfig(ctx, key);
    }
}

