/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.notice.api;

import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.wssc.app.notice.api.IMessageSection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractMessage {
    private static Logger logger = Logger.getLogger(AbstractMessage.class);
    protected IMessageSection head = null;
    protected IMessageSection body = null;

    public AbstractMessage(String pubAcctCode) throws NullPointerException {
    }

    public void makeContent(Map<String, Object> fields) {
        try {
            this.head = (IMessageSection)fields.get("head");
            this.body = (IMessageSection)fields.get("body");
        }
        catch (ClassCastException var3) {
            logger.error((Object)("message content object cast error:" + var3.getMessage()));
        }
    }

    public Map<String, Object> getContent() {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.putAll(this.head.getContent());
        content.putAll(this.body.getContent());
        return content;
    }

    public boolean hasReady() {
        if (this.head != null && this.body != null) {
            return this.head.hasReady() && this.body.hasReady();
        }
        return false;
    }

    public boolean isSupportMultiEntries() {
        return this.body.isSupportMultiEntries();
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int indentFactor) {
        String msg = null;
        if (this.hasReady()) {
            JSONObject message = new JSONObject(this.getContent());
            try {
                msg = indentFactor < 0 ? message.toString() : message.toString(indentFactor);
                logger.info((Object)"push content has been built complete");
            }
            catch (JSONException e) {
                logger.error((Object)"error message", (Throwable)e);
            }
        }
        return msg;
    }
}

