/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.trd.webservice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.eas.base.wssc.LoginSSCCfgCollection;
import com.kingdee.eas.base.wssc.LoginSSCCfgFactory;
import com.kingdee.eas.base.wssc.LoginSSCCfgInfo;
import com.kingdee.eas.base.wssc.app.ImageSysEnum;
import com.kingdee.eas.base.wssc.app.util.LoggerUtils;
import com.kingdee.eas.base.wssc.app.util.WSSCCacheManager;
import com.kingdee.eas.base.wssc.util.MD5Utils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class WebServiceConfig {
    private static Logger logger = Logger.getLogger((String)WebServiceConfig.class.getName());
    public static final String FILE_NAME = "sharetask_webservice.properties";
    public static final String BILL_SHORT_CODE = "billShortCode";
    public static final String DEFAULT_SSC_KEY = "default_key";

    public static void clearCache() {
        WSSCCacheManager.clearCache();
    }

    @Deprecated
    public static String getPropertiesValue(String key) {
        return WebServiceConfig.getPropertiesValue(null, key);
    }

    public static String getPropertiesValue(Context ctx, String key) {
        return WebServiceConfig.getPropertiesValue(ctx, null, key);
    }

    public static String getPropertiesValue(Context ctx, String sscNumber, String key) {
        if (StringUtils.isEmpty((String)sscNumber)) {
            sscNumber = "EAS";
        }
        Properties properties = WebServiceConfig.loadProperties(ctx, sscNumber);
        String value = properties.getProperty(key);
        if (key.equals("deployType") && StringUtils.isEmpty((String)value)) {
            return "0";
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties() {
        Properties cacheObj = (Properties)WSSCCacheManager.getValue("sharetask_webservice_properties");
        Properties properties = null;
        Class<WebServiceConfig> clazz = WebServiceConfig.class;
        synchronized (WebServiceConfig.class) {
            String tmp = System.getProperty("java.security.auth.login.config");
            if (tmp == null) {
                properties = new Properties();
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return properties;
            }
            int i = tmp.lastIndexOf("/");
            if (i < 0) {
                properties = new Properties();
                logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return properties;
            }
            Properties map = new Properties();
            String path = tmp.substring(0, i) + "/";
            String file = path + FILE_NAME;
            WebServiceConfig.loadPropertie(file, map);
            Properties easMap = new Properties();
            easMap.put("EAS", map);
            properties = easMap;
            if (cacheObj == null) {
                cacheObj = new Properties();
            }
            cacheObj.put(DEFAULT_SSC_KEY, properties);
            WSSCCacheManager.put("sharetask_webservice_properties", cacheObj);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Context ctx, String sscNumber) {
        if (null == ctx) {
            ctx = ContextUtils.getContextFromSessionNoException();
        }
        if (null == ctx) {
            try {
                ctx = LoginSSCCfgFactory.getRemoteInstance().getContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Properties properties = null;
        Object cacheObj = null;
        String dbId = DEFAULT_SSC_KEY;
        Properties cfgMap = null;
        Properties props = null;
        cacheObj = WSSCCacheManager.getValue("sharetask_webservice_properties");
        if (cacheObj != null) {
            cfgMap = (Properties)cacheObj;
        } else {
            LoggerUtils.print(ctx, "wssc\u914d\u7f6e\u4ece\u7f13\u5b58\u83b7\u53d6key[sharetask_webservice_properties]\u7684\u5185\u5bb9\u4e3a\u7a7a,\u5c1a\u672a\u521d\u59cb\u5316\u7f13\u5b58.\u51c6\u5907\u521d\u59cb\u5316.");
            cfgMap = new Properties();
        }
        if (ctx != null) {
            dbId = ctx.getAIS();
            if (StringUtils.isEmpty((String)dbId)) {
                dbId = DEFAULT_SSC_KEY;
            }
            if (null == (props = (Properties)cfgMap.get(dbId))) {
                LoggerUtils.print(ctx, "wssc\u53d6\u914d\u7f6e[" + dbId + "][" + sscNumber + "],\u5bf9\u5e94\u6570\u636e\u4e2d\u5fc3\u914d\u7f6e\u4e3a\u7a7a,\u5c1a\u672a\u521d\u59cb\u5316,\u51c6\u5907\u521d\u59cb\u5316.");
                props = new Properties();
                cfgMap.put(dbId, props);
            }
            if (null != (properties = (Properties)props.get(sscNumber))) {
                return properties;
            }
            LoggerUtils.print(ctx, "wssc\u53d6\u914d\u7f6e[" + dbId + "][" + sscNumber + "],\u5bf9\u5e94\u5171\u4eab\u4e2d\u5fc3\u7f16\u7801\u914d\u7f6e\u4e3a\u7a7a,\u5c1a\u672a\u521d\u59cb\u5316,\u51c6\u5907\u521d\u59cb\u5316.");
            Class<WebServiceConfig> clazz = WebServiceConfig.class;
            synchronized (WebServiceConfig.class) {
                properties = WebServiceConfig.loadProperties();
                LoginSSCCfgInfo cfg = WebServiceConfig.getSSCCfg(ctx, sscNumber);
                if (null != cfg) {
                    Properties properties2 = WebServiceConfig.cfg2prop(cfg);
                    properties.putAll((Map<?, ?>)properties2);
                } else {
                    logger.error((Object)("wssc\u53d6\u914d\u7f6e[" + dbId + "][" + sscNumber + "],\u5bf9\u5e94\u5171\u4eab\u4e2d\u5fc3\u7f16\u7801\u914d\u7f6e\u4e3a\u7a7a,\u521d\u59cb\u5316\u65f6\u672a\u83b7\u53d6\u5230\u6570\u636e\u5e93\u4fe1\u606f!\u4ee5\u914d\u7f6e\u6587\u4ef6\u7684\u914d\u7f6e\u4e3a\u51c6."));
                }
                props.put(sscNumber, properties);
                // ** MonitorExit[var7_8] (shouldn't be in output)
            }
        } else {
            LoggerUtils.print(ctx, "ctx\u4e3a\u7a7a,\u53ea\u80fd\u4ece\u914d\u7f6e\u6587\u4ef6\u53d6\u5185\u5bb9\u4e86.sscNumber[" + sscNumber + "]");
            dbId = DEFAULT_SSC_KEY;
            props = (Properties)cfgMap.get(dbId);
            if (null == props) {
                props = new Properties();
                cfgMap.put(dbId, props);
            }
            if (null != (properties = (Properties)props.get(sscNumber))) {
                return properties;
            }
            properties = WebServiceConfig.loadProperties();
            props.put(sscNumber, properties);
        }
        {
            WSSCCacheManager.put("sharetask_webservice_properties", cfgMap);
            return properties;
        }
    }

    private static LoginSSCCfgInfo getSSCCfg(Context ctx, String sscNumber) {
        try {
            LoginSSCCfgCollection collection = LoginSSCCfgFactory.getLocalInstance(ctx).getLoginSSCCfgCollection("where sscNumber = '" + sscNumber + "'");
            if (null != collection && collection.size() > 0) {
                return collection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private static Properties cfg2prop(LoginSSCCfgInfo sscCfg) {
        String sscIp = sscCfg.getSscIP();
        String sscPort = sscCfg.getSscPort();
        Properties proper = new Properties();
        if (!StringUtils.isEmpty((String)sscIp) && !StringUtils.isEmpty((String)sscPort)) {
            proper.put("erp.ip", sscIp);
            proper.put("erp.port", sscPort);
            proper.put("sharetaskaddress", "http://" + sscIp + ":" + sscPort + "/ormrpc/services/WSTaskInterFacede?wsdl");
            proper.put("createShareTaskWebServiceUrl", "http://" + sscIp + ":" + sscPort + "/ormrpc/services/WSTaskInterFacede?wsdl");
            proper.put("eas.login.wsdl", "http://" + sscIp + ":" + sscPort + "/ormrpc/services/EASLogin?wsdl");
        }
        if (StringUtils.isEmpty((String)sscCfg.getPassword())) {
            proper.put("password", "");
        } else {
            String pw = "";
            try {
                pw = MD5Utils.md5Decode(sscCfg.getPassword());
            }
            catch (Exception e) {
                logger.error((Object)"\u89e3\u5bc6\u51fa\u9519", (Throwable)e);
                pw = sscCfg.getPassword();
            }
            proper.put("password", pw);
        }
        if (null != sscCfg.getDBType()) {
            proper.put("dbType", sscCfg.getDBType().getValue());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getDeployType())) {
            proper.put("deployType", sscCfg.getDeployType());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getEASUserName())) {
            proper.put("userName", sscCfg.getEASUserName());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getDCenter())) {
            proper.put("dcName", sscCfg.getDCenter());
        }
        if (null != sscCfg.getImageSys()) {
            proper.put("image.system.type", sscCfg.getImageSys().getValue());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getImagePrefix())) {
            proper.put("imagePrefix", sscCfg.getImagePrefix());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getErpNumber())) {
            proper.put("erpNumber", sscCfg.getErpNumber());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getImageIP()) && !StringUtils.isEmpty((String)sscCfg.getImagePort())) {
            proper.put("image.ip", sscCfg.getImageIP());
            proper.put("image.port", sscCfg.getImagePort());
            String imageWsdl = "/X-Smart.WebService/services/IScanWebServiceImplService.asmx?WSDL";
            String imageHttpUrl = "/X-Smart.WebService/services/IScanWebServiceBatchUploadImage.ashx?";
            if (ImageSysEnum.GXHC.equals((Object)sscCfg.getImageSys())) {
                imageWsdl = "/SiitFrameWs/services/AutoImageCenter.ws?wsdl";
                imageHttpUrl = "/HSImage/servlet/HttpJsonUpload?";
                proper.put("image", "http://" + sscCfg.getImageIP() + ":" + sscCfg.getImagePort() + imageWsdl);
                proper.put("voucher.file.image.url", "http://" + sscCfg.getImageIP() + ":" + sscCfg.getImagePort() + "/SiitFrameWs/services/AutoImageCenter.ws?wsdl");
            } else if (ImageSysEnum.TCZT.equals((Object)sscCfg.getImageSys())) {
                imageWsdl = "/TIMS-Server/services/ImageForCommonService";
                imageHttpUrl = "/TIMS-Server/services/ImageForCommonService";
                proper.put("image", "http://" + sscCfg.getImageIP() + ":" + sscCfg.getImagePort() + imageWsdl);
            } else {
                proper.put("image", "http://" + sscCfg.getImageIP() + ":" + sscCfg.getImagePort() + imageWsdl);
            }
            proper.put("image.system.http.url", "http://" + sscCfg.getImageIP() + ":" + sscCfg.getImagePort() + imageHttpUrl);
        }
        if (!StringUtils.isEmpty((String)sscCfg.getErpNumber())) {
            proper.put("erpNumber", sscCfg.getErpNumber());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getDominoSecret())) {
            proper.put("dominoSecret", sscCfg.getDominoSecret());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getTokenExpiration())) {
            proper.put("tokenExpiration", sscCfg.getTokenExpiration());
        }
        if (!StringUtils.isEmpty((String)sscCfg.getCookieDomain())) {
            proper.put("cookieDomain", sscCfg.getCookieDomain());
        }
        proper.put("usePcImage", sscCfg.isUsePcImage() + "");
        return proper;
    }

    private static void loadPropertie(String file, Properties map) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        catch (Exception e) {
            logger.error((Object)"load wf_ext.properties from  failed!", (Throwable)e);
        }
        Enumeration<Object> em = properties.keys();
        while (em.hasMoreElements()) {
            Object o;
            Object key = em.nextElement();
            Object value = properties.get(key);
            if (value instanceof String && value != null && !value.toString().matches("[\u4e00-\u9fa5]+")) {
                try {
                    key = new String(((String)key).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    value = new String(((String)value).getBytes("ISO8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = properties.get(key);
                }
            }
            if ((o = map.put(key, value)) == null) continue;
            StringBuffer msg = new StringBuffer();
            msg.append("wf_ext config {").append(key).append("=").append(o).append("} is overridden by {").append(file).append("}, with new value{").append(value).append("}");
        }
    }

    public static Map getBillShortCodeMap(Context ctx, String sscNumber) {
        String billShortCode = WebServiceConfig.getPropertiesValue(ctx, sscNumber, BILL_SHORT_CODE);
        HashMap<String, Object> cacheMap = (HashMap<String, Object>)WSSCCacheManager.getValue("imageNo_short_prefix_map");
        if (cacheMap != null && cacheMap.containsKey("str")) {
            String cache_str = (String)cacheMap.get("str");
            if (StringUtils.isEmpty((String)cache_str) && StringUtils.isEmpty((String)billShortCode)) {
                if (cacheMap == null) {
                    cacheMap = new HashMap();
                    HashMap billShortCodeMap = new HashMap();
                    cacheMap.put("str", billShortCode);
                    cacheMap.put("map", billShortCodeMap);
                    WSSCCacheManager.put("imageNo_short_prefix_map", cacheMap);
                } else if (cacheMap.get("map") == null) {
                    cacheMap = new HashMap();
                    HashMap billShortCodeMap = new HashMap();
                    cacheMap.put("str", billShortCode);
                    cacheMap.put("map", billShortCodeMap);
                    WSSCCacheManager.put("imageNo_short_prefix_map", cacheMap);
                }
                return (Map)cacheMap.get("map");
            }
            if (cache_str != null && cache_str.equals(billShortCode)) {
                return (Map)cacheMap.get("map");
            }
        }
        cacheMap = new HashMap<String, Object>();
        HashMap<String, String> billShortCodeMap = new HashMap<String, String>();
        cacheMap.put("str", billShortCode);
        cacheMap.put("map", billShortCodeMap);
        billShortCode = billShortCode == null ? "" : billShortCode;
        String[] billShortCodeArray = billShortCode.split(";");
        if (billShortCodeArray == null || billShortCodeArray.length == 0) {
            WSSCCacheManager.put("imageNo_short_prefix_map", cacheMap);
            return billShortCodeMap;
        }
        String[] billShortCodePair = null;
        String bosTypeTemp = null;
        String billshortCodeTemp = null;
        for (int i = 0; i < billShortCodeArray.length; ++i) {
            billShortCodePair = billShortCodeArray[i].split("!");
            if (billShortCodePair == null || billShortCodePair.length != 2) continue;
            bosTypeTemp = billShortCodePair[0];
            billshortCodeTemp = billShortCodePair[1];
            if (billShortCodeMap.get(bosTypeTemp) != null) continue;
            billShortCodeMap.put(bosTypeTemp, billshortCodeTemp);
        }
        WSSCCacheManager.put("imageNo_short_prefix_map", cacheMap);
        return billShortCodeMap;
    }

    public static String getFileFullPath(String fileName) {
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            logger.error((Object)"System.getProperty('java.security.auth.login.config') \u672a\u914d\u7f6e!");
            return fileName;
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            logger.error((Object)"System.getProperty('java.security.auth.login.config') \u914d\u7f6e\u7684\u8def\u5f84\u4e2d\u6ca1\u6709 /!");
            return fileName;
        }
        String path = tmp.substring(0, i) + "/";
        String filePath = path + fileName;
        return filePath;
    }
}

