/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.dynamicthreadpool.config;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.wssc.dynamicthreadpool.config.ThreadPoolProperties;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.QueueTypeEnum;
import com.kingdee.eas.base.wssc.dynamicthreadpool.enums.RejectedExecutionHandlerEnum;
import java.util.concurrent.TimeUnit;

public class ThreadPoolBuilder {
    private ThreadPoolProperties properties = new ThreadPoolProperties();

    public ThreadPoolBuilder ctx(Context ctx) {
        this.properties.setCtx(ctx);
        return this;
    }

    public ThreadPoolBuilder applicationName(String applicationName) {
        this.properties.setApplicationName(applicationName);
        return this;
    }

    public ThreadPoolBuilder threadPoolName(String threadPoolName) {
        this.properties.setThreadPoolName(threadPoolName);
        return this;
    }

    public ThreadPoolBuilder corePoolSize(int corePoolSize) {
        this.properties.setCorePoolSize(corePoolSize);
        return this;
    }

    public ThreadPoolBuilder maximumPoolSize(int maximumPoolSize) {
        this.properties.setMaximumPoolSize(maximumPoolSize);
        return this;
    }

    public ThreadPoolBuilder queueCapacity(int queueCapacity) {
        this.properties.setQueueCapacity(queueCapacity);
        this.properties.setQueueCapacityThreshold(queueCapacity);
        return this;
    }

    public ThreadPoolBuilder queueType(QueueTypeEnum typeEnum) {
        this.properties.setQueueType(typeEnum.getType());
        return this;
    }

    public ThreadPoolBuilder fair(boolean fair) {
        this.properties.setFair(fair);
        return this;
    }

    public ThreadPoolBuilder rejectedExecutionType(RejectedExecutionHandlerEnum typeEnum) {
        this.properties.setRejectedExecutionType(typeEnum.getType());
        return this;
    }

    public ThreadPoolBuilder keepAliveTime(Long keepAliveTime) {
        this.properties.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadPoolBuilder timeUnit(TimeUnit unit) {
        this.properties.setUnit(unit);
        return this;
    }

    public ThreadPoolBuilder queueCapacityThreshold(int queueCapacityThreshold) {
        this.properties.setQueueCapacityThreshold(queueCapacityThreshold);
        return this;
    }

    public ThreadPoolProperties getProperties() {
        return this.properties;
    }
}

