/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.xml;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.IXmlIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlUtil {
    private static final Logger log = LogUtil.getPackageLogger(XmlUtil.class);
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";

    public static Object loadChilds(Element elm, String childTag, IXmlIO io, ILoadHook hook) {
        List list = elm.getChildren(childTag);
        int len = list.size();
        Object obj = hook.newObject(len);
        for (int i = 0; i < len; ++i) {
            hook.loadChild(obj, (Element)list.get(i), i, io);
        }
        return obj;
    }

    public static void saveChilds(Object obj, Element elm, IXmlIO io, ISaveHook hook) {
        int len = hook.getChildCount(obj);
        for (int i = 0; i < len; ++i) {
            Element item = hook.saveChild(obj, i, io);
            if (item == null) continue;
            elm.addContent((Content)item);
        }
    }

    public static Element loadXmlStream(InputStream is) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(JDOMFactory.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            doc = builder.build(is);
        }
        catch (JDOMException je) {
            log.fatal((Object)"JDOM Parser ERROR!");
            log.fatal((Object)("this classloader = " + XmlUtil.class.getClassLoader()));
            log.fatal((Object)("thread classloader = " + Thread.currentThread().getContextClassLoader()));
            log.fatal((Object)("system classloader = " + ClassLoader.getSystemClassLoader()));
            throw je;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return doc.getRootElement();
    }

    public static Element loadXmlBytes(byte[] xmlBytes) throws IOException, JDOMException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
        for (int i = 0; i < xmlBytes.length && xmlBytes[i] <= 0; ++i) {
            inputStream.read();
        }
        return XmlUtil.loadXmlStream(inputStream);
    }

    public static Element loadXmlFile(String filePath) throws IOException, JDOMException {
        return XmlUtil.loadXmlFile(new File(filePath));
    }

    public static Element loadXmlFile(File file) throws IOException, JDOMException {
        Element element;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            element = XmlUtil.loadXmlStream(in);
        }
        catch (Throwable throwable) {
            CtrlUtil.Stream.closeStream(in);
            throw throwable;
        }
        CtrlUtil.Stream.closeStream(in);
        return element;
    }

    public static Element loadXmlString(String s) throws IOException, JDOMException {
        return XmlUtil.loadXmlBytes(s.getBytes());
    }

    public static boolean saveXmlStream(OutputStream fos, Element elm) throws IOException {
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        XMLOutputter outter = new XMLOutputter(format);
        outter.output(elm, fos);
        StreamUtil.closeCloseable((Closeable)fos);
        return true;
    }

    public static byte[] saveXmlBytes(Element elm) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XmlUtil.saveXmlStream(baos, elm);
        return baos.toByteArray();
    }

    public static boolean saveXmlFile(String filePath, Element elm) throws IOException {
        FileOutputStream fos = new FileOutputStream(filePath);
        return XmlUtil.saveXmlStream(fos, elm);
    }

    public static boolean saveXmlFile(File file, Element elm) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            boolean bl = XmlUtil.saveXmlStream(fos, elm);
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            StreamUtil.closeStream(fos);
        }
    }

    public static String outputString(Element elm) {
        Format format = Format.getPrettyFormat();
        format.setEncoding("GB2312");
        format.setIndent("\t");
        XMLOutputter outter = new XMLOutputter(format);
        return outter.outputString(elm);
    }

    public static void printElement(Element elm) {
        Format format = Format.getPrettyFormat();
        format.setEncoding("GB2312");
        format.setIndent("\t");
        XMLOutputter outter = new XMLOutputter(format);
        try {
            StringWriter sw = new StringWriter();
            outter.output(elm, (Writer)sw);
            log.debug((Object)sw);
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    public static final List hashMap2Attributes(HashMap attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        Iterator ikey = attrs.keySet().iterator();
        Iterator ival = attrs.values().iterator();
        while (ikey.hasNext()) {
            list.add(new Attribute(ikey.next().toString(), ival.next().toString()));
        }
        return list;
    }

    public static final HashMap attributes2HashMap(List attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    public static final List makeMapElements(Map map, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        Iterator keys = map.keySet().iterator();
        Iterator vals = map.values().iterator();
        while (keys.hasNext()) {
            Element e = new Element(tagName);
            e.setAttribute(ATTR_NAME, (String)keys.next());
            Object value = vals.next();
            if (value != null) {
                List itemsE;
                if (value instanceof String) {
                    e.setAttribute(ATTR_VALUE, (String)value);
                } else if (value instanceof Object[]) {
                    itemsE = null;
                    if (value instanceof String[]) {
                        e.setAttribute(ATTR_TYPE, "String[]");
                        itemsE = XmlUtil.makeStrArrayElements((String[])value, "Item");
                    } else if (value instanceof Map[]) {
                        e.setAttribute(ATTR_TYPE, "java.util.Map[]");
                        itemsE = XmlUtil.makeMapArrayElements((Map[])value, "Item");
                    } else {
                        throw new UnsupportedOperationException("Unkown value type:" + value);
                    }
                    e.setContent((Collection)itemsE);
                } else if (value instanceof Map) {
                    e.setAttribute(ATTR_TYPE, "java.util.Map");
                    itemsE = XmlUtil.makeMapElements((HashMap)value, "Property");
                    e.setContent((Collection)itemsE);
                }
            }
            list.add(e);
        }
        return list;
    }

    public static List makeStrArrayElements(String[] values, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < values.length; ++i) {
            Element e = new Element(tagName);
            e.addContent(values[i]);
            list.add(e);
        }
        return list;
    }

    public static List makeMapArrayElements(Map[] value, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < value.length; ++i) {
            Element e = new Element(tagName);
            e.setContent((Collection)XmlUtil.makeMapElements(value[i], "Property"));
            list.add(e);
        }
        return list;
    }

    public static Map[] makeMapArray(List es, String tagName) {
        Map[] mapArray = new Map[es.size()];
        for (int i = 0; i < mapArray.length; ++i) {
            Element eChild = (Element)es.get(i);
            mapArray[i] = XmlUtil.makeMap(eChild.getChildren(tagName));
        }
        return mapArray;
    }

    public static String[] makeStrArray(List es) {
        String[] strArray = new String[es.size()];
        for (int i = 0; i < strArray.length; ++i) {
            Element eChild = (Element)es.get(i);
            strArray[i] = eChild.getText();
        }
        return strArray;
    }

    public static final HashMap makeMap(List es) {
        HashMap<String, String> properties = null;
        for (Element eChild : es) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            String name = eChild.getAttributeValue(ATTR_NAME);
            Object value = eChild.getAttributeValue(ATTR_VALUE);
            if (value == null) {
                String type = eChild.getAttributeValue(ATTR_TYPE);
                if ("java.util.Map".equals(type)) {
                    value = XmlUtil.makeMap(eChild.getChildren("Property"));
                } else if ("String[]".equals(type)) {
                    value = XmlUtil.makeStrArray(eChild.getChildren("Item"));
                } else if ("java.util.Map[]".equals(type)) {
                    value = XmlUtil.makeMapArray(eChild.getChildren("Item"), "Property");
                }
            }
            properties.put(name, (String)value);
        }
        return properties;
    }

    public static final Element createNode(String name) {
        return new Element(name);
    }

    public static abstract class ASaveMap
    implements ISaveHook,
    ISaveMapHook {
        private Object[] entries;

        @Override
        public int getChildCount(Object obj) {
            this.entries = ((Map)obj).entrySet().toArray();
            return this.entries.length;
        }

        @Override
        public Element saveChild(Object obj, int index, IXmlIO io) {
            return this.saveEntry((Map.Entry)this.entries[index], io);
        }
    }

    public static interface ISaveMapHook {
        public Element saveEntry(Map.Entry var1, IXmlIO var2);
    }

    public static interface ISaveHook {
        public int getChildCount(Object var1);

        public Element saveChild(Object var1, int var2, IXmlIO var3);
    }

    public static abstract class ALoadArrayList
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;

        @Override
        public void loadChild(Object obj, Element elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((ArrayList)obj).add(this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new ArrayList(childCount);
        }
    }

    public static abstract class ALoadHashMap
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;
        protected Object returnKey;

        @Override
        public void loadChild(Object obj, Element elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((HashMap)obj).put(this.returnKey, this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new HashMap(childCount);
        }
    }

    public static interface ILoadExHook {
        public boolean loadChild(Element var1, IXmlIO var2);
    }

    public static interface ILoadHook {
        public Object newObject(int var1);

        public void loadChild(Object var1, Element var2, int var3, IXmlIO var4);
    }
}

