/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.Calendar;
import java.util.Date;

class VarDate
extends VarBase {
    VarDate() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)left.getValue());
        result.setObject(Util.addCalendar(cal, right.toBigDecimal()).getTime());
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)left.getValue());
        result.setObject(Util.addCalendar(cal, right.toBigDecimal().negate()).getTime());
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long leftval = ((Date)left.getValue()).getTime() * right.longValue();
        if (result.getVt() == 12) {
            ((Date)result.getValue()).setTime(leftval);
        } else {
            result.setObject(new Date(leftval), 12);
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long rightval = right.longValue();
        if (rightval == 0L) {
            ExprErr.goError(2L, null);
        }
        long leftval = ((Date)left.getValue()).getTime() / rightval;
        if (result.getVt() == 12) {
            ((Date)result.getValue()).setTime(leftval);
        } else {
            result.setObject(new Date(leftval), 12);
        }
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        long rightval = right.longValue();
        if (rightval == 0L) {
            ExprErr.goError(2L, null);
        }
        long leftval = ((Date)left.getValue()).getTime() % rightval;
        if (result.getVt() == 12) {
            ((Date)result.getValue()).setTime(leftval);
        } else {
            result.setObject(new Date(leftval), 12);
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97");
    }
}

