/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta;

import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.INameSpace;
import java.util.ArrayList;
import java.util.List;

public class MetaPackage
extends DefObj
implements INameSpace {
    private List packages;
    private List classes;

    public List getPackages() {
        if (this.packages == null) {
            this.init();
        }
        return this.packages;
    }

    public MetaPackage getPackage(String name) {
        List pkgs = this.getPackages();
        int len = pkgs.size();
        for (int i = 0; i < len; ++i) {
            MetaPackage pkg = (MetaPackage)pkgs.get(i);
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }

    public MetaPackage findPackage(String fullName) {
        if (fullName == null) {
            return this;
        }
        String[] names = PathUtil.splitPath(fullName);
        return this.findPackage(names, names.length);
    }

    private MetaPackage findPackage(String[] names, int len) {
        MetaPackage pkg = this;
        for (int i = 1; i < len; ++i) {
            if ((pkg = pkg.getPackage(names[i])) != null) continue;
            return null;
        }
        return pkg;
    }

    public MetaPackage createPackage(String pkgPath) {
        if (pkgPath == null) {
            return this;
        }
        String[] names = PathUtil.splitPath(pkgPath);
        MetaPackage pkg = this;
        for (int i = 1; i < names.length; ++i) {
            MetaPackage tmp = pkg.getPackage(names[i]);
            if (tmp == null) {
                while (i < names.length) {
                    tmp = new MetaPackage();
                    tmp.setName(names[i]);
                    pkg.addPackage(tmp);
                    pkg = tmp;
                    ++i;
                }
                return pkg;
            }
            pkg = tmp;
        }
        return pkg;
    }

    public List getClasses() {
        if (this.classes == null) {
            this.init();
        }
        return this.classes;
    }

    public MetaClass getClass(String name) {
        List lst = this.getClasses();
        int len = lst.size();
        for (int i = 0; i < len; ++i) {
            MetaClass cls = (MetaClass)lst.get(i);
            if (!cls.getName().equals(name)) continue;
            return cls;
        }
        return null;
    }

    public MetaClass findClass(String clsPath) {
        if (clsPath == null) {
            return null;
        }
        String[] names = PathUtil.splitPath(clsPath);
        MetaPackage pkg = this.findPackage(names, names.length - 1);
        if (pkg != null) {
            return pkg.getClass(names[names.length - 1]);
        }
        return null;
    }

    public void addPackage(MetaPackage pkg) {
        assert (pkg.getNameSpace() == null);
        this.getPackages().add(pkg);
        pkg.setNameSpace(this);
    }

    public void addClass(MetaClass cls) {
        assert (cls.getNameSpace() == null);
        this.getClasses().add(cls);
        cls.setNameSpace(this);
    }

    public void getAllClasses(List lst) {
        lst.addAll(this.getClasses());
        List pkgs = this.getPackages();
        int z = pkgs.size();
        for (int i = 0; i < z; ++i) {
            ((MetaPackage)pkgs.get(i)).getAllClasses(lst);
        }
    }

    @Override
    public Object getObject() {
        return this;
    }

    @Override
    public String getString() {
        return this.getFullName();
    }

    protected void init() {
        this.packages = new ArrayList();
        this.classes = new ArrayList();
    }
}

