/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;

public class CellBlock {
    RelationsListener listener;
    private int row;
    private int col;
    private int row2;
    private int col2;

    private CellBlock(RelationsListener listener, int row, int col, int row2, int col2) {
        assert (listener != null);
        this.listener = listener;
        this.row = row;
        this.col = col;
        this.row2 = row2;
        this.col2 = col2;
    }

    public static CellBlock getNewCellBlock(RelationsListener listener, int row, int col, int row2, int col2) {
        int left = Math.min(col, col2);
        int top = Math.min(row, row2);
        int right = Math.max(col, col2);
        int bottom = Math.max(row, row2);
        return new CellBlock(listener, top, left, bottom, right);
    }

    public RelationsListener getRelationsListener() {
        return this.listener;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getRow2() {
        return this.row2;
    }

    public int getCol2() {
        return this.col2;
    }

    public int getWidth() {
        return this.col2 - this.col + 1;
    }

    public int getHeight() {
        return this.row2 - this.row + 1;
    }

    public boolean contains(int row, int col) {
        return row >= this.row && row <= this.row2 && col >= this.col && col <= this.col2;
    }

    public boolean containsRow(int row) {
        return row >= this.row && row <= this.row2;
    }

    public boolean containsCol(int col) {
        return col >= this.col && col <= this.col2;
    }

    public int hashCode() {
        return this.col + this.col2 << 16 | this.row + this.row2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellBlock) {
            CellBlock a = (CellBlock)obj;
            return this.listener == a.getRelationsListener() && this.row == a.row && this.col == a.col && this.row2 == a.row2 && this.col2 == a.col2;
        }
        return false;
    }
}

