/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.common.util.NumberUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.AbstractRelations;
import com.kingdee.bos.ctrl.kdf.expr.CellBlock;
import com.kingdee.bos.ctrl.kdf.expr.CellPosition;
import com.kingdee.bos.ctrl.kdf.expr.Element;
import com.kingdee.bos.ctrl.kdf.expr.ExprError;
import com.kingdee.bos.ctrl.kdf.expr.InnerFunction;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.MacroEngineFactory;
import com.kingdee.bos.ctrl.kdf.expr.Parser;
import com.kingdee.bos.ctrl.kdf.expr.RelationKey;
import com.kingdee.bos.ctrl.kdf.expr.RelationNode;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class TableRelations
extends AbstractRelations {
    private static final int FORMULA_OFFSETED = 1;
    private static final int FORMULA_CHANGED = 2;
    private HashMap funcs;

    public TableRelations() {
        String strClass = "External.Table";
        this.funcs = new HashMap();
        this.funcs.put("CELL", new ExternalFunction_Cell(2, 3, strClass));
        this.funcs.put("GROUP", new ExternalFunction_Group(4, 5, strClass));
        this.funcs.put("MAX", new ExternalFunction_Max(1, Short.MAX_VALUE, strClass));
        this.funcs.put("MIN", new ExternalFunction_Min(1, Short.MAX_VALUE, strClass));
        this.funcs.put("SUM", new ExternalFunction_Sum(1, Short.MAX_VALUE, strClass));
        this.funcs.put("COUNT", new ExternalFunction_Count(1, Short.MAX_VALUE, strClass));
        this.funcs.put("AVERAGE", new ExternalFunction_Average(1, Short.MAX_VALUE, strClass));
    }

    public static CellBlock parseCell(String cellString) throws SyntaxErrorException {
        CellBlock cb = null;
        Parser psr = new Parser(new Element(null, cellString), cellString);
        psr.setSupportCellName(true);
        psr.advance();
        if (psr.meet(0x200000000000000L)) {
            int row = psr.cp.row;
            int col = psr.cp.col;
            psr.advance();
            if (psr.meet(0x8000000000000L)) {
                psr.advance();
                if (!psr.meet(0x200000000000000L)) {
                    ExprError.goError(16384L, "Cell");
                }
                cb = CellBlock.getNewCellBlock(null, row, col, psr.cp.row, psr.cp.col);
                psr.advance();
            } else {
                cb = CellBlock.getNewCellBlock(null, row, col, row, col);
            }
        }
        if (null == cb || !psr.meet(0x1000000000000000L)) {
            ExprError.goError(1L, cellString);
        }
        return cb;
    }

    public static String getCellName(CellBlock cb) {
        String cellName = null;
        if (cb.getWidth() <= 1 && cb.getHeight() <= 1) {
            cellName = TableRelations.getColumnName(cb.getCol()) + TableRelations.getRowName(cb.getRow());
        } else {
            cellName = TableRelations.getColumnName(cb.getCol()) + TableRelations.getRowName(cb.getRow()) + ":";
            cellName = cellName + TableRelations.getColumnName(cb.getCol2()) + TableRelations.getRowName(cb.getRow2());
        }
        return cellName;
    }

    public static final String getCellName(int row, int col) {
        return TableRelations.getColumnName(col) + TableRelations.getRowName(row);
    }

    private static String getColumnName(int col) {
        StringBuffer sb = new StringBuffer();
        sb.append((char)(65 + col % 26));
        col /= 26;
        while (col > 0) {
            int deal = col % 26 - 1;
            if (deal < 0) {
                col += deal;
                deal += 26;
            }
            sb.append((char)(65 + deal));
            col /= 26;
        }
        sb.reverse();
        return sb.toString();
    }

    private static String getRowName(int row) {
        return String.valueOf(row + 1);
    }

    @Override
    public boolean externalMethod(Parser psr, String funcName, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
        Object objFunc = this.funcs.get(funcName.toUpperCase());
        if (objFunc != null) {
            InnerFunction func = (InnerFunction)objFunc;
            if (params.size() < func.getMinArgs() || params.size() > func.getMaxArgs()) {
                ExprError.goError(8L, params.size() + ", MinMax[" + func.getMinArgs() + "," + func.getMaxArgs() + "]");
            }
            if (!psr.isSyntaxCheck()) {
                func.invoke(psr, params, rvarResult);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean queryVariable(Parser psr, String variableName, Variant varFormula, Variant rvarResult) throws SyntaxErrorException {
        RelationNode refer = (RelationNode)psr.getOwner();
        RelationsListener referListener = refer.getRelationKey().getRelationsListener();
        RelationKey referencedKey = new RelationKey(referListener, variableName, null);
        Object obj = this.nodes.get(referencedKey);
        if (obj != null) {
            RelationNode referenced = (RelationNode)obj;
            this.objectRef(refer, referencedKey);
            rvarResult.setVariant(referenced.getData());
        } else {
            rvarResult.setEmpty();
            varFormula.setEmpty();
            if (referListener.queryVariable(refer.getRelationKey(), variableName, varFormula, rvarResult)) {
                if (!varFormula.isEmpty()) {
                    RelationNode referenced = null;
                    String formula = varFormula.toString().trim();
                    if (!StringUtil.isEmptyString(formula)) {
                        referenced = new RelationNode(referencedKey, formula);
                        this.nodes.put(referencedKey, referenced);
                    }
                    this.objectRef(refer, referencedKey);
                    this.getNodeValue(referenced, referencedKey, rvarResult);
                } else {
                    this.objectRef(refer, referencedKey);
                    if (rvarResult.isEmpty()) {
                        ExprError.goError(512L, variableName + " Bad Value Query");
                    }
                }
            } else {
                ExprError.goError(512L, variableName);
            }
        }
        return true;
    }

    @Override
    public boolean queryCell(Parser psr, RelationsListener listener, int row, int col, Variant rvarResult) throws SyntaxErrorException {
        RelationNode refer = (RelationNode)psr.getOwner();
        RelationKey referencedKey = new RelationKey(listener, new CellPosition(row, col), null);
        RelationNode referenced = this.getReferencedNode(referencedKey);
        this.objectRef(refer, referencedKey);
        return this.getNodeValue(referenced, referencedKey, rvarResult);
    }

    @Override
    public boolean queryObjectInstance(Parser psr, String objectName, Variant varInstance) throws SyntaxErrorException {
        RelationKey keyPos = ((RelationNode)psr.getOwner()).getRelationKey();
        RelationsListener listener = keyPos.getRelationsListener();
        RelationKey referencedKey = new RelationKey(listener, objectName, null);
        varInstance.setEmpty();
        if (listener.queryInstance(referencedKey, keyPos, varInstance) && !varInstance.isEmpty()) {
            RelationNode refer = (RelationNode)psr.getOwner();
            this.objectRef(refer, referencedKey);
            return true;
        }
        return false;
    }

    @Override
    public String getMethodName(String methodName) {
        return methodName;
    }

    private RelationNode getReferencedNode(RelationKey key) throws SyntaxErrorException {
        RelationNode referenced = null;
        Object obj = this.nodes.get(key);
        if (obj != null) {
            referenced = (RelationNode)obj;
        } else {
            String formula;
            Variant varFormula = Variant.getNewEmptyVariant();
            if (!key.getRelationsListener().queryFormula(key, varFormula)) {
                ExprError.goError(512L, key.toString() + " Bad Formula Query");
            }
            if (!varFormula.isEmpty() && !StringUtil.isEmptyString(formula = varFormula.toString().trim())) {
                referenced = new RelationNode(key, formula);
                this.nodes.put(key, referenced);
            }
        }
        return referenced;
    }

    private boolean getNodeValue(RelationNode node, RelationKey key, Variant rvarResult) throws SyntaxErrorException {
        if (node != null) {
            if (node.isNeedCalculate()) {
                this.calculateNode(node);
            }
            rvarResult.setVariant(node.getData());
        } else if (!key.getRelationsListener().queryValue(key, rvarResult)) {
            ExprError.goError(512L, key + " Bad Value Query");
        }
        return true;
    }

    private void stat(Parser psr, ArrayList params, Variant sum, Variant max, Variant min, Variant count) throws SyntaxErrorException {
        Variant varValue = Variant.getNewEmptyVariant();
        Variant varQuery = Variant.getNewEmptyVariant();
        RelationNode referenced = null;
        int args = params.size();
        while (--args >= 0) {
            Variant varParam = (Variant)params.get(args);
            boolean isBlock = varParam.getValue() instanceof CellBlock;
            if (isBlock) {
                CellBlock block = (CellBlock)varParam.getValue();
                RelationsListener referencedListener = block.getRelationsListener();
                int row2 = block.getRow2();
                int col2 = block.getCol2();
                for (int row = block.getRow(); row <= row2; ++row) {
                    for (int col = block.getCol(); col <= col2; ++col) {
                        CellPosition pos = new CellPosition(row, col);
                        RelationKey referenceKey = new RelationKey(referencedListener, pos, null);
                        referenced = this.getReferencedNode(referenceKey);
                        this.objectRef((RelationNode)psr.getOwner(), referenceKey);
                        assert (referenced == null || !referenced.isNeedCalculate());
                        this.getNodeValue(referenced, referenceKey, varQuery);
                        if (!varQuery.isNumeric(varValue)) continue;
                        this.statOne(varValue, sum, max, min, count);
                    }
                }
                continue;
            }
            if (!varParam.isNumeric(varValue)) continue;
            this.statOne(varValue, sum, max, min, count);
        }
        if (max != null && max.doubleValue() == -1.7976931348623157E308) {
            max.setDouble(0.0);
        }
        if (min != null && min.doubleValue() == Double.MAX_VALUE) {
            min.setDouble(0.0);
        }
    }

    private void statOne(Variant var, Variant sum, Variant max, Variant min, Variant count) throws SyntaxErrorException {
        if (sum != null) {
            sum.add(var);
        }
        if (count != null) {
            count.add(new Variant(1));
        }
        if (max != null && var.compareTo(max) > 0) {
            max.setVariant(var);
        }
        if (min != null && var.compareTo(min) < 0) {
            min.setVariant(var);
        }
    }

    private RelationsListener getExternalRelationsListener(RelationsListener currentListener, Variant varParam) throws SyntaxErrorException {
        RelationsListener externalListener = null;
        if (varParam.getValue() instanceof RelationsListener) {
            externalListener = (RelationsListener)varParam.getValue();
        } else {
            if (!varParam.isString()) {
                ExprError.goError(16L, "sheet");
            }
            String listenerName = varParam.toString();
            String upperListenerName = varParam.toString().toUpperCase();
            Object obj = this.listeners.get(upperListenerName);
            if (obj == null) {
                if (!currentListener.queryRelationsListener(listenerName, varParam) || !(varParam.getValue() instanceof RelationsListener)) {
                    ExprError.goError(512L, listenerName + " Bad Listener Query");
                }
                this.listeners.put(upperListenerName, varParam.getValue());
            } else {
                varParam.setObject(obj, 17);
            }
            externalListener = (RelationsListener)varParam.getValue();
        }
        return externalListener;
    }

    public void insdelBlock(CellBlock cb, boolean insert, boolean xDir) {
        int inc;
        int n = inc = xDir ? cb.getWidth() : cb.getHeight();
        if (!insert) {
            inc = -inc;
        }
        this.offsetNodesPosition(cb, insert, inc, xDir);
        this.offsetNodesFormula(cb, inc, xDir);
    }

    private void offsetNodesPosition(CellBlock cb, boolean insert, int inc, boolean xDir) {
        RelationKey key;
        Map.Entry e;
        HashMap<RelationKey, RelationKey> changedNodes = new HashMap<RelationKey, RelationKey>();
        HashMap<RelationKey, RelationNode> tmpNodes = new HashMap<RelationKey, RelationNode>(this.nodes.size() / 2 + 1);
        RelationsListener sourceListener = cb.getRelationsListener();
        Iterator i = this.nodes.entrySet().iterator();
        while (i.hasNext()) {
            RelationNode no;
            e = i.next();
            key = (RelationKey)e.getKey();
            if (key.getRelationsListener() != sourceListener || !(key.getIndex() instanceof CellPosition)) continue;
            CellPosition pos = (CellPosition)key.getIndex();
            RelationNode node = null;
            boolean changed = false;
            if (xDir) {
                if (cb.containsRow(pos.row) && pos.col >= cb.getCol()) {
                    no = (RelationNode)e.getValue();
                    if (insert || pos.col > cb.getCol2()) {
                        node = this.changeRelationNodeByPos(no, new CellPosition(pos.row, pos.col + inc));
                    } else {
                        no.setDeleted(true);
                    }
                    i.remove();
                    changed = true;
                }
            } else if (cb.containsCol(pos.col) && pos.row >= cb.getRow()) {
                no = (RelationNode)e.getValue();
                if (insert || pos.row > cb.getRow2()) {
                    node = this.changeRelationNodeByPos(no, new CellPosition(pos.row + inc, pos.col));
                } else {
                    no.setDeleted(true);
                }
                i.remove();
                changed = true;
            }
            if (!changed) continue;
            if (node != null) {
                tmpNodes.put(node.getRelationKey(), node);
                changedNodes.put(key, node.getRelationKey());
                continue;
            }
            changedNodes.put(key, key);
        }
        for (RelationKey key2 : this.deps.keySet()) {
            if (changedNodes.containsKey(key2) || key2.getRelationsListener() != sourceListener || !(key2.getIndex() instanceof CellPosition)) continue;
            CellPosition pos = (CellPosition)key2.getIndex();
            RelationKey newKey = null;
            boolean changed = false;
            if (xDir) {
                if (cb.containsRow(pos.row) && pos.col >= cb.getCol()) {
                    if (insert || pos.col > cb.getCol2()) {
                        newKey = this.getNewRelationKeyByPos(key2, new CellPosition(pos.row, pos.col + inc));
                    }
                    changed = true;
                }
            } else if (cb.containsCol(pos.col) && pos.row >= cb.getRow()) {
                if (insert || pos.row > cb.getRow2()) {
                    newKey = this.getNewRelationKeyByPos(key2, new CellPosition(pos.row + inc, pos.col));
                }
                changed = true;
            }
            if (!changed) continue;
            if (newKey != null) {
                changedNodes.put(key2, newKey);
                continue;
            }
            changedNodes.put(key2, key2);
        }
        this.nodes.putAll(tmpNodes);
        tmpNodes.clear();
        i = this.deps.entrySet().iterator();
        while (i.hasNext()) {
            e = i.next();
            key = (RelationKey)e.getKey();
            RelationKey newkey = (RelationKey)changedNodes.get(key);
            if (newkey == null) continue;
            if (!key.equals(newkey)) {
                tmpNodes.put(newkey, (RelationNode)e.getValue());
            } else {
                this.queueElement(key, false);
            }
            i.remove();
        }
        this.deps.putAll(tmpNodes);
    }

    private RelationKey getNewRelationKeyByPos(RelationKey oldKey, CellPosition pos) {
        RelationKey key = (RelationKey)oldKey.clone();
        key.setIndex(pos);
        return key;
    }

    private RelationNode changeRelationNodeByPos(RelationNode node, CellPosition pos) {
        node.setRelationKey(this.getNewRelationKeyByPos(node.getRelationKey(), pos));
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offsetNodesFormula(CellBlock cb, int inc, boolean xDir) {
        StringBuffer sb = new StringBuffer();
        Variant varChanged = new Variant(false);
        for (Map.Entry e : this.nodes.entrySet()) {
            RelationNode node = (RelationNode)e.getValue();
            if (StringUtil.isEmptyString(node.getFormula())) continue;
            Macro m = MacroEngineFactory.createMacro(null, null, node, node.getFormula());
            Parser psr = m.getParser();
            psr.setSupportCellName(true);
            try {
                sb.setLength(0);
                varChanged.setEmpty();
                this.offsetNodeFormula(e, psr, sb, varChanged, cb, inc, xDir);
                int changed = varChanged.intValue();
                if (changed < 1) continue;
                node.setFormula(sb.toString());
                if (changed < 2) continue;
                this.queueElement(node.getRelationKey(), true);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
            continue;
            finally {
                MacroEngineFactory.recycleMacro(m);
            }
        }
    }

    private void offsetNodeFormula(Map.Entry e, Parser psr, StringBuffer sb, Variant varChanged, CellBlock cb, int inc, boolean xDir) throws SyntaxErrorException {
        boolean bRightBottomCorner = false;
        RelationKey key = (RelationKey)e.getKey();
        boolean currKey = key.getRelationsListener() == cb.getRelationsListener();
        boolean hasSheet = false;
        boolean currSheet = true;
        String lastWord = null;
        String lastCellName = null;
        while (!psr.meet(0x1000000000000000L)) {
            sb.append(psr.getComment());
            if (psr.meet(0x100000000000000L)) {
                String word;
                lastWord = word = psr.getCurrentWord();
                sb.append(word);
                psr.advance();
                if (!psr.meet(0x1000000000000L)) continue;
                sb.append(psr.getCurrentWord());
                psr.advance();
                boolean isCell = StringUtil.equals(word = word.toUpperCase(), "CELL");
                if (!isCell && !StringUtil.equals(word, "GROUP")) continue;
                this.offsetNodeFormula_Function(psr, sb, varChanged, cb, inc, xDir, isCell);
            } else if (psr.meet(0x400000000000000L)) {
                String word = psr.getCurrentWord();
                if (word != null) {
                    lastWord = '\'' == word.charAt(0) && '\'' == word.charAt(word.length() - 1) ? word.substring(1, word.length() - 1) : word;
                }
            } else if (psr.meet(0x40000000000L)) {
                hasSheet = true;
                Variant relationObject = Variant.getNewEmptyVariant();
                key.getRelationsListener().queryRelationsListener(lastWord, relationObject);
                RelationsListener listener = (RelationsListener)relationObject.getValue();
                currSheet = listener == cb.getRelationsListener();
            } else if (psr.meet(0x200000000000000L)) {
                if (hasSheet) {
                    if (currSheet) {
                        lastCellName = psr.getCurrentWord();
                        this.offsetNodeFormula_Cell(psr, sb, varChanged, cb, inc, xDir, bRightBottomCorner);
                    } else {
                        sb.append(psr.getCurrentWord());
                    }
                } else if (currKey) {
                    lastCellName = psr.getCurrentWord();
                    this.offsetNodeFormula_Cell(psr, sb, varChanged, cb, inc, xDir, bRightBottomCorner);
                } else {
                    sb.append(psr.getCurrentWord());
                }
                hasSheet = false;
                psr.advance();
                if (psr.meet(0x8000000000000L)) {
                    int inx = sb.lastIndexOf("#REF!");
                    if (inx >= 0 && inx == sb.length() - 5) {
                        sb.replace(inx, sb.length(), lastCellName);
                    }
                    bRightBottomCorner = true;
                } else {
                    bRightBottomCorner = false;
                }
            }
            sb.append(psr.getCurrentWord());
            psr.advance();
        }
    }

    private void offsetNodeFormula_Cell(Parser psr, StringBuffer sb, Variant varChanged, CellBlock cb, int inc, boolean xDir, boolean bRightBottomCorner) throws SyntaxErrorException {
        int row = psr.cp.row;
        int col = psr.cp.col;
        String newA1Name = psr.getCurrentWord();
        if (!bRightBottomCorner && inc < 0 && cb.contains(row, col)) {
            newA1Name = "#REF!";
            varChanged.setInt(2);
        } else if (xDir) {
            if (cb.containsRow(row) && col >= cb.getCol()) {
                newA1Name = TableRelations.getCellName(row, col += inc);
                if (bRightBottomCorner) {
                    varChanged.setInt(2);
                } else {
                    varChanged.setInt(1);
                }
            }
        } else if (cb.containsCol(col) && row >= cb.getRow()) {
            newA1Name = TableRelations.getCellName(row += inc, col);
            if (bRightBottomCorner) {
                varChanged.setInt(2);
            } else {
                varChanged.setInt(1);
            }
        }
        sb.append(newA1Name);
    }

    private void offsetNodeFormula_Function(Parser psr, StringBuffer sb, Variant varChanged, CellBlock cb, int inc, boolean xDir, boolean isCell) throws SyntaxErrorException {
        ArrayList<String> al = new ArrayList<String>();
        int startPos = sb.length();
        this.getOneStringParameter(psr, sb, varChanged, cb, inc, xDir);
        al.add(sb.substring(startPos, sb.length()));
        int currentPos = 0;
        while (psr.meet(0x4000000000000L)) {
            sb.append(psr.getCurrentWord());
            psr.advance();
            currentPos = sb.length();
            this.getOneStringParameter(psr, sb, varChanged, cb, inc, xDir);
            al.add(sb.substring(currentPos, sb.length()));
        }
        currentPos = sb.length();
        RelationsListener sourceListener = cb.getRelationsListener();
        RelationsListener currentlistener = ((RelationNode)psr.getOwner()).getRelationKey().getRelationsListener();
        if (currentlistener != sourceListener) {
            if (isCell && al.size() >= 3 || al.size() >= 5) {
                try {
                    int index = isCell ? 2 : 4;
                    String listenerName = (String)al.get(index);
                    if (!StringUtil.isEmptyString(listenerName)) {
                        int lastPos = listenerName.length() - 1;
                        if (listenerName.charAt(0) == '\"' && listenerName.charAt(lastPos) == '\"') {
                            listenerName = listenerName.substring(1, lastPos);
                        }
                        Variant varListenerName = new Variant(listenerName, 11);
                        currentlistener = this.getExternalRelationsListener(sourceListener, varListenerName);
                    }
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
            }
            if (currentlistener != sourceListener) {
                return;
            }
        }
        if (isCell && al.size() >= 2) {
            this.assembleParams(sb, varChanged, al, cb, 2, startPos, currentPos, inc, xDir);
        } else if (al.size() >= 4) {
            this.assembleParams(sb, varChanged, al, cb, 4, startPos, currentPos, inc, xDir);
        }
    }

    private void assembleParams(StringBuffer sb, Variant varChanged, ArrayList params, CellBlock cb, int min, int start, int end, int inc, boolean xDir) throws SyntaxErrorException {
        Variant[] vars = new Variant[min];
        for (int i = 0; i < min; ++i) {
            vars[i] = Variant.getNewEmptyVariant();
            this.translateNumberParameter((String)params.get(i), vars[i]);
        }
        boolean bRightBottomCorner = false;
        for (int i = 0; i < min; i += 2) {
            int row = this.getRowColIndexValue(vars[i]);
            int col = this.getRowColIndexValue(vars[i + 1]);
            boolean bl = bRightBottomCorner = i >= 2;
            if (!bRightBottomCorner && inc < 0 && cb.contains(row, col)) {
                if (xDir) {
                    vars[i + 1].setInt(min == 2 ? -1 : (i > 1 ? -1 : cb.getCol()));
                } else {
                    vars[i].setInt(min == 2 ? -1 : (i > 1 ? -1 : cb.getRow()));
                }
                varChanged.setInt(2);
                continue;
            }
            if (xDir) {
                if (!cb.containsRow(row) || col < cb.getCol()) continue;
                vars[i + 1].add(new Variant(inc));
                varChanged.setInt(1);
                continue;
            }
            if (!cb.containsCol(col) || row < cb.getRow()) continue;
            vars[i].add(new Variant(inc));
            varChanged.setInt(1);
        }
        if (varChanged.booleanValue()) {
            Variant var = null;
            StringBuffer newParams = new StringBuffer();
            for (int i = 0; i < min; i += 2) {
                if (i > 1) {
                    newParams.append(',');
                }
                if ((var = vars[i]).isNumber() && var.doubleValue() < 0.0) {
                    newParams.append("#REF!");
                } else {
                    newParams.append(var);
                }
                newParams.append(',');
                var = vars[i + 1];
                if (var.isNumber() && var.doubleValue() < 0.0) {
                    newParams.append("#REF!");
                    continue;
                }
                newParams.append(var);
            }
            if (params.size() > min) {
                newParams.append("," + (String)params.get(min));
            }
            sb.replace(start, end, newParams.toString());
        }
    }

    private boolean translateNumberParameter(String param, Variant varNumber) {
        boolean isNumber = true;
        try {
            boolean isFloat;
            boolean bl = isFloat = param.indexOf(46) >= 0;
            if (isFloat) {
                varNumber.setObject(Double.valueOf(param), 6);
            } else {
                try {
                    varNumber.setObject(Long.valueOf(param), 4);
                }
                catch (NumberFormatException e) {
                    varNumber.setObject(Double.valueOf(param), 6);
                }
            }
        }
        catch (Exception e) {
            isNumber = false;
            varNumber.setObject(param, 11);
        }
        return isNumber;
    }

    private int getRowColIndexValue(Variant var) throws SyntaxErrorException {
        return var.isNumber() ? var.intValue() - 1 : Integer.MAX_VALUE;
    }

    private void getOneStringParameter(Parser psr, StringBuffer sb, Variant varChanged, CellBlock cb, int inc, boolean xDir) throws SyntaxErrorException {
        boolean expression = false;
        while (!psr.touchToken(0x1006000000000000L)) {
            if (psr.meet(0x100000000000000L)) {
                expression = true;
                String word = psr.getCurrentWord();
                sb.append(word);
                word = word.toUpperCase(Locale.ENGLISH);
                psr.advance();
                if (psr.meet(0x1000000000000L)) {
                    sb.append('(');
                    psr.advance();
                    if (StringUtil.equals(word, "CELL") || StringUtil.equals(word, "GROUP")) {
                        this.offsetNodeFormula_Function(psr, sb, varChanged, cb, inc, xDir, StringUtil.equals(word, "CELL"));
                    }
                }
            } else if (psr.touchToken(0xC0000000000000L) && !expression) {
                sb.append(psr.getCurrentWord());
                psr.advance();
                if (psr.meet(0x4000000000000L) || psr.meet(0x2000000000000L)) continue;
                expression = true;
            }
            sb.append(psr.getCurrentWord());
            psr.advance();
        }
    }

    class ExternalFunction_Average
    extends InnerFunction {
        public ExternalFunction_Average(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            Variant varCount = new Variant(0.0);
            rvarResult.setDouble(0.0);
            TableRelations.this.stat(psr, params, rvarResult, null, null, varCount);
            if (varCount.longValue() == 0L) {
                rvarResult.setDouble(0.0);
            } else {
                rvarResult.divide(varCount);
            }
            NumberUtil.cutZero(rvarResult);
        }
    }

    class ExternalFunction_Count
    extends InnerFunction {
        public ExternalFunction_Count(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            rvarResult.setInt(0);
            TableRelations.this.stat(psr, params, null, null, null, rvarResult);
        }
    }

    class ExternalFunction_Min
    extends InnerFunction {
        public ExternalFunction_Min(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            rvarResult.setDouble(Double.MAX_VALUE);
            TableRelations.this.stat(psr, params, null, null, rvarResult, null);
        }
    }

    class ExternalFunction_Max
    extends InnerFunction {
        public ExternalFunction_Max(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            rvarResult.setDouble(-1.7976931348623157E308);
            TableRelations.this.stat(psr, params, null, rvarResult, null, null);
        }
    }

    class ExternalFunction_Sum
    extends InnerFunction {
        public ExternalFunction_Sum(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            rvarResult.setDouble(0.0);
            TableRelations.this.stat(psr, params, rvarResult, null, null, null);
            NumberUtil.cutZero(rvarResult);
        }
    }

    class ExternalFunction_Group
    extends InnerFunction {
        public ExternalFunction_Group(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            int row = ((Variant)params.get(0)).intValue() - 1;
            int col = ((Variant)params.get(1)).intValue() - 1;
            int row2 = ((Variant)params.get(2)).intValue() - 1;
            int col2 = ((Variant)params.get(3)).intValue() - 1;
            RelationsListener listener = ((RelationNode)psr.getOwner()).getRelationKey().getRelationsListener();
            if (params.size() == 5) {
                listener = TableRelations.this.getExternalRelationsListener(listener, (Variant)params.get(4));
            }
            rvarResult.setObject(CellBlock.getNewCellBlock(listener, row, col, row2, col2), 17);
        }
    }

    class ExternalFunction_Cell
    extends InnerFunction {
        public ExternalFunction_Cell(int minArgs, int maxArgs, String strClass) {
            super(minArgs, maxArgs, strClass);
        }

        @Override
        public void invoke(Parser psr, ArrayList params, Variant rvarResult) throws SyntaxErrorException {
            CellPosition pos = null;
            Variant varNumber = Variant.getNewEmptyVariant();
            Variant varParam = (Variant)params.get(0);
            if (!varParam.isNumeric(varNumber)) {
                ExprError.goError(16L, "row");
            }
            int row = varNumber.intValue() - 1;
            varParam = (Variant)params.get(1);
            if (!varParam.isNumeric(varNumber)) {
                ExprError.goError(16L, "col");
            }
            int col = varNumber.intValue() - 1;
            pos = new CellPosition(row, col);
            RelationsListener listener = ((RelationNode)psr.getOwner()).getRelationKey().getRelationsListener();
            if (params.size() == 3) {
                listener = TableRelations.this.getExternalRelationsListener(listener, (Variant)params.get(2));
            }
            RelationKey referencedKey = new RelationKey(listener, pos, null);
            TableRelations.this.getReferencedNode(referencedKey);
            TableRelations.this.objectRef((RelationNode)psr.getOwner(), referencedKey);
            rvarResult.setEmpty();
            if (!listener.queryInstance(referencedKey, referencedKey, rvarResult) || rvarResult.isEmpty()) {
                ExprError.goError(512L, referencedKey.toString() + " Bad Instance Query");
            }
        }
    }
}

