/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.exec.objs;

import com.kingdee.bos.ctrl.script.miniscript.exec.objs.Persistent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class Var
implements Comparable,
Persistent {
    private String name;
    private Object value;
    private int curIndex = -1;
    private int level = 0;
    private Var next = null;
    private Var pre = null;
    private boolean matchLevel = false;

    public void setMatchLevel(boolean b) {
        this.matchLevel = b;
    }

    public void addVarLink(Var var) {
        Var p = this;
        while (p.next != null) {
            p = p.next;
        }
        p.next = var;
        var.pre = p;
    }

    public Object getValue() {
        return this.value;
    }

    public static Var parse(String varString, int level) {
        String s;
        int j;
        int i = varString.indexOf(91);
        if (i != -1 && i + 1 < (j = varString.lastIndexOf(93)) && (s = varString.substring(i + 1, j)).matches("\\d+")) {
            int index = new Integer(s);
            return new Var(varString.substring(0, i), index, Integer.MAX_VALUE);
        }
        return new Var(varString, level);
    }

    public Var(String name, int level) {
        this.name = name;
        this.level = level;
    }

    public Var(String name, int curIndex, int level) {
        this.name = name;
        this.curIndex = curIndex;
        this.level = level;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object var) {
        return this.name.equals(var.toString());
    }

    public int compareTo(Object o) {
        Var v = (Var)o;
        return this.level - v.level;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private boolean visitArray() {
        return this.curIndex != -1;
    }

    public Object setLeveledValue(Object value, Map varMap, int curLevel) {
        Var v;
        if (value instanceof Var) {
            value = ((Var)value).getLeveledValue(varMap, curLevel);
        }
        if ((v = this.matchLinkedVar(curLevel, varMap)) == null) {
            v = this;
        } else if (this.matchLevel && v.level != curLevel) {
            v.addVarLink(this);
            this.value = value;
            return this.value;
        }
        v.curIndex = this.curIndex;
        return v.setValue(value, varMap);
    }

    private Object setValue(Object value, Map varMap) {
        if (this.visitArray()) {
            if (varMap.containsKey(this)) {
                Object v = this.value;
                if (v != null) {
                    if (v.getClass().isArray()) {
                        Object oldValue = Array.get(v, this.curIndex);
                        Array.set(v, this.curIndex, value);
                        return oldValue;
                    }
                    throw new RuntimeException("Object is not an array!");
                }
                throw new RuntimeException("Array object is null!");
            }
            throw new RuntimeException("Array has not be initialized!");
        }
        this.value = value;
        return varMap.put(this, value);
    }

    public Object getLeveledValue(Map varMap, int curLevel) {
        Var v;
        if (this.matchLevel) {
            curLevel = this.level;
        }
        if ((v = this.matchLinkedVar(curLevel, varMap)) == null) {
            return null;
        }
        v.curIndex = this.curIndex;
        return v.getValue(varMap);
    }

    private Object getValue(Map varMap) {
        Object v = this.value;
        if (this.visitArray()) {
            if (v != null) {
                if (v.getClass().isArray()) {
                    return Array.get(v, this.curIndex);
                }
                throw new RuntimeException("Object is not an array!");
            }
            throw new RuntimeException("Array object is null!");
        }
        return v;
    }

    private Var matchLinkedVar(int level, Map varMap) {
        if (!varMap.containsKey(this)) {
            return null;
        }
        Var head = null;
        for (Var v : varMap.keySet()) {
            if (!this.equals(v)) continue;
            head = v;
            break;
        }
        while (head.pre != null) {
            head = head.pre;
        }
        Var p = head;
        ArrayList<Var> list = new ArrayList<Var>();
        do {
            if (p.level == level) {
                return p;
            }
            if (p.level >= level) continue;
            list.add(p);
        } while ((p = p.next) != null);
        int n = list.size();
        if (n == 1) {
            return (Var)list.get(0);
        }
        if (n > 1) {
            Collections.sort(list);
            return (Var)list.get(n - 1);
        }
        return null;
    }

    public Var getLinkHead() {
        Var head = this;
        while (head.pre != null) {
            head = head.pre;
        }
        return head;
    }

    public Var next() {
        return this.next;
    }

    public int getLevel() {
        return this.level;
    }

    public Var removeByLevel(int level) {
        Var head = this;
        while (head.pre != null) {
            head = head.pre;
        }
        Var newHead = null;
        Var newP = null;
        Var p = head;
        do {
            if (p.level > level) {
                if (p.pre != null) {
                    p.pre.next = p.next;
                    if (p.next == null) continue;
                    p.next.pre = p.pre;
                    continue;
                }
                if (p.next == null) continue;
                p.next.pre = null;
                continue;
            }
            if (newHead == null) {
                newP = newHead = p;
                continue;
            }
            newP.next = p;
            p.pre = newP;
            newP = newP.next;
        } while ((p = p.next) != null);
        return newHead;
    }
}

