/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public abstract class ResourceManager {
    private static URL getResourceURL(Class cls, String resName) {
        return cls.getResource(resName);
    }

    private static URL getResourceURL(String packName, String resName) {
        String pkg;
        if (StringUtil.isEmptyString((String)packName)) {
            pkg = "";
        } else {
            pkg = packName.indexOf(".") != -1 ? packName.replaceAll("\\.", "/") : packName;
            pkg = pkg + "/";
        }
        return ResourceManager.class.getClassLoader().getResource(pkg + resName);
    }

    public static Image getImage(Class cls, String resName) {
        return ResourceManager.getIcon(cls, resName).getImage();
    }

    public static Image getImage(String packName, String resName) {
        return ResourceManager.getIcon(packName, resName).getImage();
    }

    public static ImageIcon getIcon(Class cls, String resName) {
        URL url = ResourceManager.getResourceURL(cls, resName);
        return ResourceManager.getIcon(url);
    }

    public static ImageIcon getIcon(String packName, String resName) {
        URL url = ResourceManager.getResourceURL(packName, resName);
        return ResourceManager.getIcon(url);
    }

    private static ImageIcon getIcon(URL url) {
        ImageIcon image = null;
        try {
            image = new ImageIcon(url);
        }
        catch (Exception ex1) {
            try {
                image = new ImageIcon(ResourceManager.getResourceURL("com.kingdee.bos.ctrl.common.ui.resource", "notfound.gif"));
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        return image;
    }
}

