/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;

class DigitDecorateCondition {
    static DigitDecorateCondition NO_FEWER_THAN_ZERO = new DigitDecorateCondition(">=0");
    static DigitDecorateCondition MORE_THAN_ZERO = new DigitDecorateCondition(">0");
    static DigitDecorateCondition FEWER_THAN_ZERO = new DigitDecorateCondition("<0");
    static DigitDecorateCondition IS_ZERO = new DigitDecorateCondition("=0");
    private static final String regex1 = "(>|=|<|>=|<=|<>){1}[0-9|.|-]{0,1}[0-9|.]*";
    private static final byte MORE = 1;
    private static final byte EQUAL = 2;
    private static final byte LESS = 4;
    private static final char CHAR_MORE = '>';
    private static final char CHAR_EQUAL = '=';
    private static final char CHAR_LESS = '<';
    private BigDecimal _limitValue;
    private byte _limitMode;

    static boolean isCondition(String condition) {
        if (StringUtil.isEmptyString((String)condition)) {
            return false;
        }
        return condition.matches(regex1);
    }

    public DigitDecorateCondition(String condition) throws IllegalArgumentException {
        if (!this.applyCondition(condition)) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efa\u6570\u5b57\u683c\u5f0f: " + condition);
        }
    }

    public boolean inCondition(BigDecimal value) {
        int cmp = value.compareTo(this._limitValue);
        if (cmp < 0) {
            return this.hasLess();
        }
        if (cmp > 0) {
            return this.hasMore();
        }
        return this.hasEqual();
    }

    private boolean applyCondition(String condition) {
        if (StringUtil.isEmptyString((String)condition)) {
            return false;
        }
        byte oldLimMode = this._limitMode;
        int valuePos = this.applySymbol(condition);
        if (valuePos == 0) {
            return false;
        }
        boolean valueOk = this.applyValue(valuePos, condition);
        if (valueOk) {
            return true;
        }
        this._limitMode = oldLimMode;
        return false;
    }

    private int applySymbol(String condition) {
        char c0 = condition.charAt(0);
        char c1 = condition.charAt(1);
        if (c0 == '>') {
            if (c1 == '=') {
                this._limitMode = (byte)3;
                return 2;
            }
            this._limitMode = 1;
            return 1;
        }
        if (c0 == '<') {
            if (c1 == '=') {
                this._limitMode = (byte)6;
                return 2;
            }
            if (c1 == '>') {
                this._limitMode = (byte)5;
                return 2;
            }
            this._limitMode = (byte)4;
            return 1;
        }
        if (c0 == '=') {
            this._limitMode = (byte)2;
            return 1;
        }
        return 0;
    }

    private boolean applyValue(int numPos, String condition) {
        if (condition.length() <= numPos) {
            return false;
        }
        try {
            this._limitValue = new Variant((Object)condition.substring(numPos)).toBigDecimal();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasLess() {
        return (this._limitMode & 4) != 0;
    }

    private boolean hasMore() {
        return (this._limitMode & 1) != 0;
    }

    private boolean hasEqual() {
        return (this._limitMode & 2) != 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (this.hasLess()) {
            sb.append('<');
        }
        if (this.hasMore()) {
            sb.append('>');
        }
        if (this.hasEqual()) {
            sb.append('=');
        }
        sb.append(this._limitValue);
        sb.append(']');
        return sb.toString();
    }

    public DigitDecorateCondition getCopy() {
        return new DigitDecorateCondition(this.toString());
    }
}

