/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.restree;

import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.spi.IResActionHandler;
import com.kingdee.bos.ctrl.common.restype.spi.IResObject;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.restree.ResTreeController;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.swing.KDTree;
import org.apache.log4j.Logger;

public abstract class AbstractResActionHandler
implements IResActionHandler {
    public static final Logger log = LogUtil.getPackageLogger(AbstractResActionHandler.class);
    private ActionDef actionDef;
    private ResObjectNode resNode;
    private ResTreeController controller;
    private boolean asSingleMode;
    private Object e;

    public boolean handle(ActionDef actionDef, IResObject source, Object e, boolean asSingleMode) throws Exception {
        this.actionDef = actionDef;
        this.resNode = (ResObjectNode)source;
        this.asSingleMode = asSingleMode;
        this.e = e;
        return this.onAction();
    }

    protected abstract boolean onAction() throws Exception;

    public ActionDef getActionDef() {
        return this.actionDef;
    }

    public void setActionDef(ActionDef def) {
        this.actionDef = def;
    }

    public ResObjectNode getResNode() {
        return this.resNode;
    }

    public String getPathText() {
        return this.getResNode().getResPath();
    }

    public void setResNode(ResObjectNode node) {
        this.resNode = node;
    }

    public ResTreeController getTreeController() {
        if (this.controller == null) {
            this.controller = (ResTreeController)TreeUI.findHook(this.getResNode());
        }
        return this.controller;
    }

    public KDTree getTree() {
        return this.getTreeUI().getTree();
    }

    public TreeUI getTreeUI() {
        return this.getTreeController().getTreeUI();
    }

    public boolean isAsSingleMode() {
        return this.asSingleMode;
    }

    public void forward(String actionName) throws Exception {
        ActionDef forwardAction = this.getResNode().getTypeTree().findAction(actionName);
        IResActionHandler newHandle = ResNodeAction.createResActionHandler(forwardAction);
        newHandle.handle(forwardAction, (IResObject)this.getResNode(), this.e, true);
    }

    public final Object getE() {
        return this.e;
    }
}

