/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.java.stat;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.res.tool.java.parser.JTBParser;
import com.kingdee.bos.ctrl.res.tool.java.parser.syntaxtree.Node;
import com.kingdee.bos.ctrl.res.tool.java.parser.syntaxtree.NodeToken;
import com.kingdee.bos.ctrl.res.tool.java.parser.visitor.DepthFirstVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.BaseVisitor;
import com.kingdee.bos.ctrl.res.tool.java.stat.JavaFileStatInfo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class JavaFileBean {
    private List tokenList = new ArrayList();
    private List lineList = new ArrayList();
    private int fileSize;
    private String error = null;
    private String fileName;
    private Node root;
    private JavaFileStatInfo info;

    public JavaFileBean(String fileName) {
        this.fileName = fileName;
        this.parse();
    }

    public JavaFileStatInfo getJavaFileStatInfo() {
        return this.info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        this.info = new JavaFileStatInfo();
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(FilenameUtils.normalize((String)this.fileName));
            this.fileSize = fis.available();
            br = new BufferedReader(new InputStreamReader(fis));
            StringBuilder s = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                s.append(line).append("\r\n");
                this.lineList.add(line);
            }
            StringReader sr = new StringReader(s.toString());
            JTBParser jp = new JTBParser(sr);
            this.root = jp.parse();
            this.root.accept(new LogTokenVisitor());
            this.info.getCommentList().addAll(JTBParser.getCommentList());
            this.info.setLine(this.lineList.size());
            this.info.setSize(this.fileSize);
            JTBParser.getCommentList().clear();
        }
        catch (Exception e) {
            try {
                this.error = e.getMessage();
            }
            catch (Throwable throwable) {
                StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, fis});
                throw throwable;
            }
            StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, fis});
        }
        StreamUtil.closeCloseable((Closeable[])new Closeable[]{br, fis});
    }

    public int getLineCount() {
        return this.lineList.size();
    }

    public String getLine(int i) {
        return (String)this.lineList.get(i);
    }

    public void setLine(int i, String value) {
        this.lineList.set(i, value);
    }

    public int getTokenCount() {
        return this.tokenList.size();
    }

    public Node getRoot() {
        return this.root;
    }

    public void accept(BaseVisitor visitor) {
        visitor.setJavaFileBean(this);
        visitor.setJavaFileStatInfo(this.info);
        this.root.accept(visitor);
        visitor.finishVisit();
    }

    public void finishAccept() throws Exception {
        this.info.doParseInfo();
    }

    public NodeToken getToken(int i) {
        return (NodeToken)this.tokenList.get(i);
    }

    public NodeToken nextToken(NodeToken current) {
        int i = this.tokenList.indexOf(current) + 1;
        if (i >= this.tokenList.size()) {
            return null;
        }
        return (NodeToken)this.tokenList.get(i);
    }

    public NodeToken preToken(NodeToken current) {
        int i = this.tokenList.indexOf(current) - 1;
        if (i < 0) {
            return null;
        }
        return (NodeToken)this.tokenList.get(i);
    }

    public boolean nextTokenWith(NodeToken current, String value) {
        NodeToken n = this.nextToken(current);
        return n != null && n.tokenImage.equals(value);
    }

    public boolean preTokenWith(NodeToken current, String value) {
        NodeToken n = this.preToken(current);
        return n != null && n.tokenImage.equals(value);
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getError() {
        return this.error;
    }

    public boolean withError() {
        return this.error != null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("File:\t").append(this.fileName).append("\n\tsize: ").append(this.fileSize).append("bytes").append("\n\tline: ").append(this.getLineCount());
        if (this.withError()) {
            s.append("\n\terror: ").append(this.error);
        } else {
            s.append("\n\ttoken: ").append(this.getTokenCount());
        }
        return s.toString();
    }

    public class LogTokenVisitor
    extends DepthFirstVisitor {
        @Override
        public void visit(NodeToken n) {
            JavaFileBean.this.tokenList.add(n);
        }
    }
}

