/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.core.SpreadViewUI;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class OutlineGroupRowHeaderUI
extends SpreadViewUI {
    private static OutlineGroupRowHeaderUI outlineGroupRowHeaderUI = new OutlineGroupRowHeaderUI();
    private SpreadView _view;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfRows;
    private SpreadView.RowBuffer[] _rbs;
    private int _rinx;
    private int _rinx2;

    @Override
    protected void installDefaults(SpreadView view) {
        view.setAutoscrolls(true);
    }

    public static ComponentUI createUI(JComponent c) {
        return outlineGroupRowHeaderUI;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        SortedAttributeSpanArray sasa = view.getSpread().getBook().getActiveSheet().getRowSpans();
        int depth = 0;
        for (int i = 0; i < sasa.size(); ++i) {
            int level = ((SortedAttributeSpanArray.AttributeSpan)sasa.get(i)).getOutlineGroupLevel();
            depth = level > depth ? level : depth;
        }
        int w = depth == 0 ? 0 : (depth + 1) * 15 + 8;
        return new Dimension(w, view.getPreferredHeight());
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        int i;
        this._g2d = g;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = this._g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cRow = SheetBaseMath.rowAtPoint(this._sheet, upperLeft);
        int cRow2 = SheetBaseMath.rowAtPoint(this._sheet, lowerRight);
        if (cRow < 0) {
            return false;
        }
        cRow2 = SheetBaseMath.dealInvalidRow(cRow2);
        this._rbs = this._view.getRowBuffers(cRow, cRow2);
        if (this._rbs == null) {
            return false;
        }
        this._sizeOfRows = this._rbs.length;
        for (i = 0; i < this._sizeOfRows; ++i) {
            if (cRow > this._rbs[i].getRow()) continue;
            this._rinx = i;
            break;
        }
        for (i = this._sizeOfRows - 1; i >= 0; --i) {
            if (cRow2 < this._rbs[i].getRow()) continue;
            this._rinx2 = i;
            break;
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        this._view = null;
        this._g2d = null;
        this._rbs = null;
        this._sheet = null;
    }
}

