/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.ConfirmPasswordDialog;
import com.kingdee.bos.ctrl.excel.impl.facade.FilterPopupButton;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.PopupListButton;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.fairy.FairyButton;
import com.kingdee.bos.ctrl.excel.impl.facade.fairy.FilledOptionAction;
import com.kingdee.bos.ctrl.excel.impl.facade.fairy.InsertOptionAction;
import com.kingdee.bos.ctrl.excel.impl.facade.fairy.PasteOptionAction;
import com.kingdee.bos.ctrl.excel.impl.facade.hyperlink.BookLinkToPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IWizzardComment;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardAdvancedFilter;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardCellInsDel;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardChart;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardClassifiedStatistics;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardColumnWidth;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardComment;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardConditionalFormat;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardConfigGroup;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardCreateGroup;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardDelGroup;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardDiagonal;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardEmbedObjectConfig;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardHyperlink;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardInsertPaste;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardLocalize;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardMultiRowIns;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardNameDefine;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardProBook;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardProRange;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardProSheet;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardRowheight;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardScale;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardSelectablePaste;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardSort;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardStyle;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardValidation;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.WizzardFinder;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.FillType;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDInfoTip;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDRadioButtonMenuItem;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public final class FacadeManager
implements SheetChangeListener,
BookChangeListener,
SheetPropertyChangeListener,
GraphChangeListener {
    public static final WizzardType WIZZARD_RowHeight = new WizzardType();
    public static final WizzardType WIZZARD_ColumnWidth = new WizzardType();
    public static final WizzardType WIZZARD_MultiRowIns = new WizzardType();
    public static final WizzardType WIZZARD_Validation = new WizzardType();
    public static final WizzardType WIZZARD_AdvancedFilter = new WizzardType();
    public static final WizzardType WIZZARD_CreateGroup = new WizzardType();
    public static final WizzardType WIZZARD_DelGroup = new WizzardType();
    public static final WizzardType WIZZARD_ConfigGroup = new WizzardType();
    public static final WizzardType WIZZARD_ConditionalFormat = new WizzardType();
    public static final WizzardType WIZZARD_Comment = new WizzardType();
    public static final WizzardType WIZZARD_SheetComment = new WizzardType();
    public static final WizzardType WIZZARD_BookComment = new WizzardType();
    public static final WizzardType WIZZARD_ProtectRange = new WizzardType();
    public static final WizzardType WIZZARD_ProtectSheet = new WizzardType();
    public static final WizzardType WIZZARD_ProtectBook = new WizzardType();
    public static final WizzardType WIZZARD_NameDefine = new WizzardType();
    public static final WizzardType WIZZARD_Localize = new WizzardType();
    public static final WizzardType WIZZARD_Style = new WizzardType();
    public static final WizzardType WIZZARD_HyperLink = new WizzardType();
    public static final WizzardType WIZZARD_Diagonal = new WizzardType();
    public static final WizzardType WIZZARD_Formula = new WizzardType();
    public static final WizzardType WIZZARD_Finder = new WizzardType();
    public static final WizzardType WIZZARD_Replace = new WizzardType();
    public static final WizzardType WIZZARD_CellInsert = new WizzardType();
    public static final WizzardType WIZZARD_CellDelete = new WizzardType();
    public static final WizzardType WIZZARD_Scale = new WizzardType();
    public static final WizzardType WIZZARD_SelectablePaste = new WizzardType();
    public static final WizzardType WIZZARD_InsertPaste = new WizzardType();
    public static final WizzardType WIZZARD_SortCustom = new WizzardType();
    public static final WizzardType WIZZARD_ClassifiedStatistics = new WizzardType();
    public static final WizzardType WIZZARD_Chart = new WizzardType();
    public static final WizzardType WIZZARD_EmbedObjectConfig = new WizzardType();
    public static final String Insert_OPTION_BUTTON = "Insert_OPTION_BUTTON";
    public static final String PASTE_OPTION_BUTTON = "PASTE_OPTION_BUTTON";
    public static final String FILLED_OPTION_BUTTON = "FILLED_OPTION_BUTTON";
    public static final String CONFIRM_PW_DIALOG = "CONFIRM_PW_DIALOG";
    public static final String PROMPT_PANEL = "PROMPT_PANEL";
    public static final String INFO_TIP = "INFO_TIP";
    public static final String POPUP_LIST_BUTTON = "POPUP_LIST_BUTTON";
    public static final String COMMENT_COMPONENT = "COMMENT_COMPONENT";
    private WeakHashMap _comps;
    private IErrorMessageBox _errorMsgBox;
    private SpreadContext _context;

    FacadeManager(SpreadContext context) {
        this._context = context;
        this._comps = new WeakHashMap();
    }

    public void putWizzard(WizzardType wizzardType, ISpreadWizzard wizzard) {
        this._comps.put(wizzardType, wizzard);
    }

    public ISpreadWizzard getWizzard(WizzardType wizzardType) {
        return this.getWizzard(wizzardType, true);
    }

    private ISpreadWizzard getWizzard(WizzardType wizzardType, boolean bCreate) {
        if (wizzardType == WIZZARD_Finder || wizzardType == WIZZARD_Replace) {
            return this.getWizzardForFindRpl(wizzardType, bCreate);
        }
        if (wizzardType == WIZZARD_CellInsert || wizzardType == WIZZARD_CellDelete) {
            return this.getWizzardForCellInsDel(wizzardType, bCreate);
        }
        if (wizzardType == WIZZARD_Comment || wizzardType == WIZZARD_SheetComment || wizzardType == WIZZARD_BookComment) {
            return this.getWizzardForComment(wizzardType, bCreate);
        }
        ISpreadWizzard wizzard = (ISpreadWizzard)this._comps.get(wizzardType);
        if (bCreate && null == wizzard) {
            wizzard = this.createWizzard(wizzardType);
            this._comps.put(wizzardType, wizzard);
        }
        return wizzard;
    }

    private ISpreadWizzard getWizzardForComment(WizzardType wizzardType, boolean bCreate) {
        ISpreadWizzard wizzard = (ISpreadWizzard)this._comps.get(WIZZARD_Comment);
        if (bCreate && null == wizzard) {
            wizzard = this.createWizzard(WIZZARD_Comment);
            this._comps.put(WIZZARD_Comment, wizzard);
        }
        if (wizzard != null) {
            if (wizzardType == WIZZARD_Comment) {
                ((IWizzardComment)wizzard).setMode(0);
            } else if (wizzardType == WIZZARD_SheetComment) {
                ((IWizzardComment)wizzard).setMode(1);
            } else if (wizzardType == WIZZARD_BookComment) {
                ((IWizzardComment)wizzard).setMode(2);
            }
        }
        return wizzard;
    }

    private ISpreadWizzard getWizzardForCellInsDel(WizzardType wizzardType, boolean bCreate) {
        ISpreadWizzard wizzard = (ISpreadWizzard)this._comps.get(WIZZARD_CellInsert);
        if (bCreate && null == wizzard) {
            wizzard = this.createWizzard(WIZZARD_CellInsert);
            this._comps.put(WIZZARD_CellInsert, wizzard);
        }
        if (wizzard != null) {
            ((WizzardCellInsDel)wizzard).setInsert(wizzardType == WIZZARD_CellInsert);
        }
        return wizzard;
    }

    private ISpreadWizzard getWizzardForFindRpl(WizzardType wizzardType, boolean bCreate) {
        ISpreadWizzard wizzard = (ISpreadWizzard)this._comps.get(WIZZARD_Finder);
        if (bCreate && null == wizzard) {
            wizzard = this.createWizzard(WIZZARD_Finder);
            this._comps.put(WIZZARD_Finder, wizzard);
        }
        if (wizzard != null) {
            ((WizzardFinder)wizzard).setPanel(wizzardType == WIZZARD_Finder);
        }
        return wizzard;
    }

    private ISpreadWizzard createWizzard(WizzardType wizzardType) {
        if (wizzardType == WIZZARD_Style) {
            return this.createWizzard_Style();
        }
        if (wizzardType == WIZZARD_Finder) {
            return this.createWizzard_Finder();
        }
        if (wizzardType == WIZZARD_Validation) {
            return this.createWizzard_Validation();
        }
        if (wizzardType == WIZZARD_AdvancedFilter) {
            return this.createWizzard_AdvancedFilter();
        }
        if (wizzardType == WIZZARD_CreateGroup) {
            return this.createWizzard_CreateGroup();
        }
        if (wizzardType == WIZZARD_DelGroup) {
            return this.createWizzard_DelGroup();
        }
        if (wizzardType == WIZZARD_ConfigGroup) {
            return this.createWizzard_ConfigGroup();
        }
        if (wizzardType == WIZZARD_ConditionalFormat) {
            return this.createWizzard_ConditionalFormat();
        }
        if (wizzardType == WIZZARD_Comment) {
            return this.createWizzard_Comment();
        }
        if (wizzardType == WIZZARD_ProtectSheet) {
            return this.createWizzard_ProtectSheet();
        }
        if (wizzardType == WIZZARD_ProtectRange) {
            return this.createWizzard_ProtectRange();
        }
        if (wizzardType == WIZZARD_ProtectBook) {
            return this.createWizzard_ProtectBook();
        }
        if (wizzardType == WIZZARD_NameDefine) {
            return this.createWizzard_NameDefine();
        }
        if (wizzardType == WIZZARD_Localize) {
            return this.createWizzard_Localize();
        }
        if (wizzardType == WIZZARD_HyperLink) {
            return this.createWizzard_HyperLink();
        }
        if (wizzardType == WIZZARD_Diagonal) {
            return this.createWizzard_Diagonal();
        }
        if (wizzardType == WIZZARD_Formula) {
            return this.createWizzard_Formula();
        }
        if (wizzardType == WIZZARD_CellInsert) {
            return this.createWizzard_CellInsert();
        }
        if (wizzardType == WIZZARD_Scale) {
            return this.createWizzard_Scale();
        }
        if (wizzardType == WIZZARD_SelectablePaste) {
            return this.createWizzard_SelectablePaste();
        }
        if (wizzardType == WIZZARD_RowHeight) {
            return this.createWizzard_RowHeight();
        }
        if (wizzardType == WIZZARD_ColumnWidth) {
            return this.createWizzard_ColumnWidth();
        }
        if (wizzardType == WIZZARD_MultiRowIns) {
            return this.createWizzard_MultiRowIns();
        }
        if (wizzardType == WIZZARD_InsertPaste) {
            return this.createWizzard_InsertPaste();
        }
        if (wizzardType == WIZZARD_SortCustom) {
            return this.createWizzard_SortCustom();
        }
        if (wizzardType == WIZZARD_ClassifiedStatistics) {
            return this.createWizzard_ClassifiedStatistics();
        }
        if (wizzardType == WIZZARD_Chart) {
            return this.createWizzard_Chart();
        }
        if (wizzardType == WIZZARD_EmbedObjectConfig) {
            return this.createWizzard_EmbedObjectConfig();
        }
        return null;
    }

    private ISpreadWizzard createWizzard_MultiRowIns() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardMultiRowIns d = w instanceof Dialog ? new WizzardMultiRowIns((Dialog)w, this._context) : (w instanceof Frame ? new WizzardMultiRowIns((Frame)w, this._context) : new WizzardMultiRowIns((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_MULTI_ROW_INS"));
        return d;
    }

    private ISpreadWizzard createWizzard_ColumnWidth() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardColumnWidth d = w instanceof Dialog ? new WizzardColumnWidth((Dialog)w, this._context) : (w instanceof Frame ? new WizzardColumnWidth((Frame)w, this._context) : new WizzardColumnWidth((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_COLUMNWIDTH"));
        return d;
    }

    private ISpreadWizzard createWizzard_RowHeight() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardRowheight d = w instanceof Dialog ? new WizzardRowheight((Dialog)w, this._context) : (w instanceof Frame ? new WizzardRowheight((Frame)w, this._context) : new WizzardRowheight((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_ROWHEIGHT"));
        return d;
    }

    private ISpreadWizzard createWizzard_SelectablePaste() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardSelectablePaste d = w instanceof Dialog ? new WizzardSelectablePaste((Dialog)w, this._context) : (w instanceof Frame ? new WizzardSelectablePaste((Frame)w, this._context) : new WizzardSelectablePaste((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_SELECTABLE_PASTE"));
        return d;
    }

    private ISpreadWizzard createWizzard_Scale() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardScale d = w instanceof Dialog ? new WizzardScale((Dialog)w, this._context) : (w instanceof Frame ? new WizzardScale((Frame)w, this._context) : new WizzardScale((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_SCALE"));
        return d;
    }

    private ISpreadWizzard createWizzard_CellInsert() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardCellInsDel d = w instanceof Dialog ? new WizzardCellInsDel((Dialog)w, this._context) : (w instanceof Frame ? new WizzardCellInsDel((Frame)w, this._context) : new WizzardCellInsDel((Frame)null, this._context));
        d.setLocationRelativeTo(w);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_CELL"));
        return d;
    }

    private ISpreadWizzard createWizzard_NameDefine() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardNameDefine hd = w instanceof Dialog ? new WizzardNameDefine((Dialog)w, this._context) : (w instanceof Frame ? new WizzardNameDefine((Frame)w, this._context) : new WizzardNameDefine((Frame)null, this._context));
        hd.setLocationRelativeTo(w);
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_DEFINENAME"));
        return hd;
    }

    private ISpreadWizzard createWizzard_Validation() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardValidation hd = w instanceof Dialog ? new WizzardValidation((Dialog)w, this._context) : (w instanceof Frame ? new WizzardValidation((Frame)w, this._context) : new WizzardValidation((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_DATA_VALIDATION", "\u6570\u636e\u6709\u6548\u6027"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_AdvancedFilter() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardAdvancedFilter hd = w instanceof Dialog ? new WizzardAdvancedFilter((Dialog)w, this._context) : (w instanceof Frame ? new WizzardAdvancedFilter((Frame)w, this._context) : new WizzardAdvancedFilter((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_AdvancedFilter_Title", "\u9ad8\u7ea7\u7b5b\u9009"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_CreateGroup() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardCreateGroup hd = w instanceof Dialog ? new WizzardCreateGroup((Dialog)w, this._context) : (w instanceof Frame ? new WizzardCreateGroup((Frame)w, this._context) : new WizzardCreateGroup((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_GROUP_CREATE", "\u521b\u5efa\u7ec4"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_DelGroup() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardDelGroup hd = w instanceof Dialog ? new WizzardDelGroup((Dialog)w, this._context) : (w instanceof Frame ? new WizzardDelGroup((Frame)w, this._context) : new WizzardDelGroup((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_GROUP_DELETE", "\u53d6\u6d88\u7ec4\u5408"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_ConfigGroup() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardConfigGroup hd = w instanceof Dialog ? new WizzardConfigGroup((Dialog)w, this._context) : (w instanceof Frame ? new WizzardConfigGroup((Frame)w, this._context) : new WizzardConfigGroup((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_SET", "\u8bbe\u7f6e"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_ConditionalFormat() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardConditionalFormat hd = w instanceof Dialog ? new WizzardConditionalFormat((Dialog)w, this._context) : (w instanceof Frame ? new WizzardConditionalFormat((Frame)w, this._context) : new WizzardConditionalFormat((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_CONDITIONALFORMAT", "\u6761\u4ef6\u683c\u5f0f"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_Localize() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardLocalize hd = w instanceof Dialog ? new WizzardLocalize((Dialog)w, this._context) : (w instanceof Frame ? new WizzardLocalize((Frame)w, this._context) : new WizzardLocalize((Frame)null, this._context));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_ProtectRange() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardProRange hd = w instanceof Dialog ? new WizzardProRange((Dialog)w, this._context) : (w instanceof Frame ? new WizzardProRange((Frame)w, this._context) : new WizzardProRange((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_ALLOWEDITRANGE", "\u5141\u8bb8\u7528\u6237\u7f16\u8f91\u533a\u57df"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_ProtectSheet() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardProSheet hd = w instanceof Dialog ? new WizzardProSheet((Dialog)w, this._context) : (w instanceof Frame ? new WizzardProSheet((Frame)w, this._context) : new WizzardProSheet((Frame)null, this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_PROTECTSHEET"));
        hd.setLocationRelativeTo(w);
        return hd;
    }

    private ISpreadWizzard createWizzard_ProtectBook() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardProBook d = w instanceof Dialog ? new WizzardProBook((Dialog)w, this._context) : (w instanceof Frame ? new WizzardProBook((Frame)w, this._context) : new WizzardProBook((Frame)null, this._context));
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_PROTECTBOOK"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_Comment() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardComment sd = w instanceof Dialog ? new WizzardComment((Dialog)w, this._context) : (w instanceof Frame ? new WizzardComment((Frame)w, this._context) : new WizzardComment((Frame)null, this._context));
        sd.setLocationRelativeTo(w);
        return sd;
    }

    private ISpreadWizzard createWizzard_HyperLink() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardHyperlink hd = w instanceof Dialog ? new WizzardHyperlink((Dialog)w, this._context) : (w instanceof Frame ? new WizzardHyperlink((Frame)w, this._context) : new WizzardHyperlink((Frame)null, this._context));
        hd.setLocationRelativeTo(w);
        hd.registerHyperLinkPanel("#", MultiLanguageKeys.getLocalText("KEY_BOOK"), new BookLinkToPanel(this._context));
        hd.setTitle(MultiLanguageKeys.getLocalText("KEY_INSERT_HYPERLINK"));
        return hd;
    }

    private ISpreadWizzard createWizzard_Style() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardStyle sd = w instanceof Dialog ? new WizzardStyle((Dialog)w, this._context) : (w instanceof Frame ? new WizzardStyle((Frame)w, this._context) : new WizzardStyle((Frame)null, this._context));
        sd.setTitle(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE"));
        sd.setLocationRelativeTo(w);
        return sd;
    }

    private ISpreadWizzard createWizzard_Diagonal() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardDiagonal sd = w instanceof Dialog ? new WizzardDiagonal((Dialog)w, this._context) : (w instanceof Frame ? new WizzardDiagonal((Frame)w, this._context) : new WizzardDiagonal((Frame)null, this._context));
        sd.setTitle(MultiLanguageKeys.getLocalText("KEY_DIAGONALWIZZARD"));
        sd.setLocationRelativeTo(w);
        return sd;
    }

    private ISpreadWizzard createWizzard_Formula() {
        return null;
    }

    private ISpreadWizzard createWizzard_Finder() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardFinder d = w instanceof Dialog ? new WizzardFinder((Dialog)w, this._context) : (w instanceof Frame ? new WizzardFinder((Frame)w, this._context) : new WizzardFinder((Frame)null, this._context));
        d.setModal(false);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_FINDREPLACE"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_InsertPaste() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardInsertPaste d = w instanceof Dialog ? new WizzardInsertPaste((Dialog)w, this._context) : (w instanceof Frame ? new WizzardInsertPaste((Frame)w, this._context) : new WizzardInsertPaste((Frame)null, this._context));
        d.setModal(true);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_INSERT"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_SortCustom() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardSort d = w instanceof Dialog ? new WizzardSort((Dialog)w, this._context) : (w instanceof Frame ? new WizzardSort((Frame)w, this._context) : new WizzardSort((Frame)null, this._context));
        d.setModal(true);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_SORT"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_ClassifiedStatistics() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardClassifiedStatistics d = w instanceof Dialog ? new WizzardClassifiedStatistics((Dialog)w, this._context) : (w instanceof Frame ? new WizzardClassifiedStatistics((Frame)w, this._context) : new WizzardClassifiedStatistics((Frame)null, this._context));
        d.setModal(true);
        d.setTitle(MultiLanguageKeys.getLocalText("KEY_ClassifiedStatistics", "\u5206\u7c7b\u6c47\u603b"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_Chart() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardChart d = w instanceof Dialog ? new WizzardChart((Dialog)w, this._context) : (w instanceof Frame ? new WizzardChart((Frame)w, this._context) : new WizzardChart((Frame)null, this._context));
        d.setModal(true);
        d.setTitle(MultiLanguageKeys.getLocalText("Key_Chart", "\u56fe\u8868"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private ISpreadWizzard createWizzard_EmbedObjectConfig() {
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
        WizzardEmbedObjectConfig d = w instanceof Dialog ? new WizzardEmbedObjectConfig((Dialog)w, this._context) : (w instanceof Frame ? new WizzardEmbedObjectConfig((Frame)w, this._context) : new WizzardEmbedObjectConfig((Frame)null, this._context));
        d.setModal(true);
        d.setTitle(MultiLanguageKeys.getLocalText("Key_EmbededObjectProperties", "\u5d4c\u5165\u5f0f\u5bf9\u8c61\u5c5e\u6027\u8bbe\u7f6e"));
        d.setLocationRelativeTo(w);
        return d;
    }

    private void addPopupFilledOption(SpreadContext context, KDPopupMenu menu, SpreadView view, Range rg, CellBlock dstBlock, FillType ft, String fillTypeInfo, boolean enable) {
        FilledOptionAction fa = new FilledOptionAction(context, ft, dstBlock, rg, false);
        fa.putValue("Name", fillTypeInfo);
        KDMenuItem item = new KDMenuItem((Action)fa);
        item.setEnabled(enable);
        menu.add((JMenuItem)item);
    }

    private void addFilledOption(SpreadContext context, FairyButton fb, Range rg, CellBlock dstBlock, FillType ft, String fillTypeInfo, FillType selFt) {
        FilledOptionAction fa = new FilledOptionAction(context, ft, dstBlock, rg);
        fa.putValue("Name", fillTypeInfo);
        KDRadioButtonMenuItem item = new KDRadioButtonMenuItem((Action)fa);
        item.setSelected(ft.equals(selFt));
        fb.addAssistMenuItem((JMenuItem)item);
    }

    private void addInsertOption(SpreadContext context, FairyButton fb, Range rg, boolean yDir, InsertType insType, String info) {
        InsertOptionAction fa = new InsertOptionAction(context, yDir, insType, rg);
        fa.putValue("Name", info);
        KDRadioButtonMenuItem item = new KDRadioButtonMenuItem((Action)fa);
        fb.addAssistMenuItem((JMenuItem)item);
        item.setSelected(insType == InsertType.FLLOW_UP_STYLE);
    }

    private void addPasteOption(SpreadContext context, FairyButton fb, Range rg, PasteMode model, String info) {
        this.addPasteOption(context, fb, rg, model, info, false);
    }

    private void addPasteOption(SpreadContext context, FairyButton fb, Range rg, PasteMode model, String info, boolean selected) {
        PasteOptionAction fa = new PasteOptionAction(context, model, rg);
        fa.putValue("Name", info);
        KDRadioButtonMenuItem item = new KDRadioButtonMenuItem((Action)fa);
        item.setSelected(selected);
        fb.addAssistMenuItem((JMenuItem)item);
    }

    public WizzardHyperlink getWizzardHyperLink() {
        return (WizzardHyperlink)this.getWizzard(WIZZARD_HyperLink);
    }

    public WizzardSelectablePaste getWizzardSelectablePaste() {
        return (WizzardSelectablePaste)this.getWizzard(WIZZARD_SelectablePaste);
    }

    public WizzardFinder getWizzardFinder() {
        return this.getWizzardFinder(true);
    }

    public PromptPanel getPromptPanel() {
        return this.getPromptPanel(true);
    }

    private WizzardFinder getWizzardFinder(boolean bCreate) {
        return (WizzardFinder)this.getWizzard(WIZZARD_Finder, bCreate);
    }

    private PromptPanel getPromptPanel(boolean bCreate) {
        Object o = this._comps.get(PROMPT_PANEL);
        if (bCreate && null == o) {
            PromptPanel pp = new PromptPanel(this._context);
            o = pp;
            this._comps.put(PROMPT_PANEL, o);
        }
        return (PromptPanel)((Object)o);
    }

    private KDInfoTip getInfoTip(boolean bCreate) {
        Object o = this._comps.get(INFO_TIP);
        if (bCreate && null == o) {
            KDInfoTip it = new KDInfoTip((JComponent)((Object)this._context), new Rectangle(0, 0, 0, 0), "", 0);
            it.setArrowHeight(0);
            it.setRadian(0);
            o = it;
            this._comps.put(INFO_TIP, o);
        }
        return (KDInfoTip)o;
    }

    private KDInfoTip getCommentComponent(boolean bCreate) {
        Object o = this._comps.get(COMMENT_COMPONENT);
        if (bCreate && null == o) {
            KDInfoTip it = new KDInfoTip((JComponent)this._context.getSpread().getActiveView(), new Rectangle(0, 0, 0, 0), "", 0);
            o = it;
            this._comps.put(COMMENT_COMPONENT, o);
        }
        return (KDInfoTip)o;
    }

    private PopupListButton getPopupListButton(boolean bCreate) {
        Object o = this._comps.get(POPUP_LIST_BUTTON);
        if (bCreate && null == o) {
            PopupListButton it = new PopupListButton();
            it.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    FacadeManager.this._context.getStateManager().stopEditing();
                }
            });
            o = it;
            this._comps.put(POPUP_LIST_BUTTON, o);
        }
        return (PopupListButton)((Object)o);
    }

    public ConfirmPasswordDialog getConfirmPWDialog() {
        Object o = this._comps.get("confrim");
        if (null == o) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
            ConfirmPasswordDialog d = w instanceof Dialog ? new ConfirmPasswordDialog((Dialog)w) : (w instanceof Frame ? new ConfirmPasswordDialog((Frame)w) : new ConfirmPasswordDialog((Frame)null));
            d.setLocationRelativeTo(w);
            o = d;
            this._comps.put("confrim", o);
        }
        return (ConfirmPasswordDialog)((Object)o);
    }

    public FairyButton getInsertOptionButton() {
        String key = Insert_OPTION_BUTTON;
        Object o = this._comps.get(key);
        if (null == o) {
            FairyButton fb = new FairyButton(ResourceManager.getImageIcon("tbtn_formatpainter.gif"));
            o = fb;
            this._comps.put(key, o);
        }
        return (FairyButton)((Object)o);
    }

    public FairyButton getPasteOptionButton() {
        String key = PASTE_OPTION_BUTTON;
        Object o = this._comps.get(key);
        if (null == o) {
            FairyButton fb = new FairyButton(ResourceManager.getImageIcon("paste_option.gif"));
            o = fb;
            this._comps.put(key, o);
        }
        return (FairyButton)((Object)o);
    }

    public FairyButton getFilledOptionButton() {
        String key = FILLED_OPTION_BUTTON;
        Object o = this._comps.get(key);
        if (null == o) {
            FairyButton fb = new FairyButton(ResourceManager.getImageIcon("fill_option.gif"));
            o = fb;
            this._comps.put(key, o);
        }
        return (FairyButton)((Object)o);
    }

    public KDPopupMenu getFillOptionPopup(SpreadView view, Range rg, CellBlock dstBlock) {
        KDPopupMenu menu = new KDPopupMenu();
        FillType resultType = rg.getPossibleFillType(dstBlock);
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.COPY, MultiLanguageKeys.getLocalText("KEY_FillBycopycells", "\u590d\u5236\u5355\u5143\u683c"), resultType.touchFlag(256));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.SERIES, MultiLanguageKeys.getLocalText("KEY_FillByseries", "\u4ee5\u5e8f\u5217\u65b9\u5f0f\u586b\u5145"), resultType.touchFlag(2));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.WEEKDAYS, MultiLanguageKeys.getLocalText("KEY_FillByweekdays", "\u4ee5\u5de5\u4f5c\u65e5\u586b\u5145"), resultType.touchFlag(32));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.GROWTHTREND, MultiLanguageKeys.getLocalText("KEY_FillBygrowthtrend", "\u7b49\u5dee\u5e8f\u5217"), resultType.touchFlag(4));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.LINEARTREND, MultiLanguageKeys.getLocalText("KEY_FillBylineartrend", "\u7b49\u6bd4\u5e8f\u5217"), resultType.touchFlag(8));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.DAYS, MultiLanguageKeys.getLocalText("KEY_FillBydays", "\u4ee5\u5929\u6570\u586b\u5145"), resultType.touchFlag(16));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.MONTHS, MultiLanguageKeys.getLocalText("KEY_FillBymonths", "\u4ee5\u6708\u586b\u5145"), resultType.touchFlag(64));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.YEARS, MultiLanguageKeys.getLocalText("KEY_FillByyears", "\u4ee5\u5e74\u586b\u5145"), resultType.touchFlag(128));
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.FORMAT, MultiLanguageKeys.getLocalText("KEY_FillBystyle", "\u4ec5\u586b\u5145\u683c\u5f0f"), true);
        this.addPopupFilledOption(this._context, menu, view, rg, dstBlock, FillType.VALUES, MultiLanguageKeys.getLocalText("KEY_FillByvalues", "\u4e0d\u5e26\u683c\u5f0f\u586b\u5145"), true);
        return menu;
    }

    public void showFilledOption(SpreadView view, Range rg, CellBlock dstBlock, FillType resultType) {
        FairyButton fb = this.getFilledOptionButton();
        fb.removeAllItems();
        FillType selectedFillType = resultType.getSelectedType();
        if (resultType.touchFlag(256)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.COPY, MultiLanguageKeys.getLocalText("KEY_FillBycopycells", "\u590d\u5236\u5355\u5143\u683c"), selectedFillType);
        }
        if (resultType.touchFlag(2)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.SERIES, MultiLanguageKeys.getLocalText("KEY_FillByseries", "\u4ee5\u5e8f\u5217\u65b9\u5f0f\u586b\u5145"), selectedFillType);
        }
        if (resultType.touchFlag(32)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.WEEKDAYS, MultiLanguageKeys.getLocalText("KEY_FillByweekdays", "\u4ee5\u5de5\u4f5c\u65e5\u586b\u5145"), selectedFillType);
        }
        if (resultType.touchFlag(12)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.GROWTHTREND, MultiLanguageKeys.getLocalText("KEY_FillBygrowthtrend", "\u7b49\u5dee\u5e8f\u5217"), selectedFillType);
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.LINEARTREND, MultiLanguageKeys.getLocalText("KEY_FillBylineartrend", "\u7b49\u6bd4\u5e8f\u5217"), selectedFillType);
        }
        if (resultType.touchFlag(16)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.DAYS, MultiLanguageKeys.getLocalText("KEY_FillBydays", "\u4ee5\u5929\u6570\u586b\u5145"), selectedFillType);
        }
        if (resultType.touchFlag(64)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.MONTHS, MultiLanguageKeys.getLocalText("KEY_FillBymonths", "\u4ee5\u6708\u586b\u5145"), selectedFillType);
        }
        if (resultType.touchFlag(128)) {
            this.addFilledOption(this._context, fb, rg, dstBlock, FillType.YEARS, MultiLanguageKeys.getLocalText("KEY_FillByyears", "\u4ee5\u5e74\u586b\u5145"), selectedFillType);
        }
        this.addFilledOption(this._context, fb, rg, dstBlock, FillType.FORMAT, MultiLanguageKeys.getLocalText("KEY_FillBystyle", "\u4ec5\u586b\u5145\u683c\u5f0f"), selectedFillType);
        this.addFilledOption(this._context, fb, rg, dstBlock, FillType.VALUES, MultiLanguageKeys.getLocalText("KEY_FillByvalues", "\u4e0d\u5e26\u683c\u5f0f\u586b\u5145"), selectedFillType);
        view.add((Component)((Object)fb));
        this.showFairyBtn(view, fb, dstBlock);
    }

    public void showInsertOption(SpreadView view, Range rg, boolean yDir) {
        FairyButton fb = this.getInsertOptionButton();
        fb.removeAllItems();
        this.addInsertOption(this._context, fb, rg, yDir, InsertType.FLLOW_UP_STYLE, MultiLanguageKeys.getLocalText(yDir ? "KEY_FllowUp" : "KEY_FllowLeft"));
        this.addInsertOption(this._context, fb, rg, yDir, InsertType.FLLOW_DOWN_STYLE, MultiLanguageKeys.getLocalText(yDir ? "KEY_FllowDown" : "KEY_FllowRight"));
        this.addInsertOption(this._context, fb, rg, yDir, InsertType.NOSTYLE, MultiLanguageKeys.getLocalText("KEY_CLEARSTYLE"));
        view.add((Component)((Object)fb));
        this.showFairyBtn(view, fb, rg.getBlock(0));
    }

    public RangeSelector createRangeSelector(String title) {
        return new RangeSelector(this._context, title);
    }

    public void showPasteOption(SpreadView view, Range rg) {
        FairyButton fb = this.getPasteOptionButton();
        fb.removeAllItems();
        this.addPasteOption(this._context, fb, rg, PasteMode.ALL, MultiLanguageKeys.getLocalText("KEY_Pasteall", "\u5168\u90e8"), true);
        this.addPasteOption(this._context, fb, rg, PasteMode.FORMULASANDVALUES, MultiLanguageKeys.getLocalText("KEY_Pastenostyle", "\u4e0d\u7c98\u8d34\u683c\u5f0f"));
        this.addPasteOption(this._context, fb, rg, PasteMode.VALUESANDNUMBERFORMATS, MultiLanguageKeys.getLocalText("KEY_Pastevalueandnf", "\u53ea\u7c98\u8d34\u503c\u548c\u6570\u5b57\u683c\u5f0f"));
        this.addPasteOption(this._context, fb, rg, PasteMode.VALUES, MultiLanguageKeys.getLocalText("KEY_Pastevalues", "\u53ea\u7c98\u8d34\u503c"));
        this.addPasteOption(this._context, fb, rg, PasteMode.FORMATS, MultiLanguageKeys.getLocalText("KEY_Pastestyle", "\u53ea\u7c98\u8d34\u683c\u5f0f"));
        this.addPasteOption(this._context, fb, rg, PasteMode.LINK, MultiLanguageKeys.getLocalText("KEY_Pastelink", "\u94fe\u63a5\u5230\u539f\u59cb\u5355\u5143\u683c"));
        view.add((Component)((Object)fb));
        CellBlock cb = rg.getBlock(0);
        this.showFairyBtn(view, fb, cb);
    }

    private void showFairyBtn(SpreadView view, FairyButton fb, CellBlock cb) {
        int y;
        int x;
        Sheet sheet = this._context.getBook().getActiveSheet();
        if (cb.isRow()) {
            x = SheetBaseMath.getColX(sheet, cb.getCol()) + 3;
            y = SheetBaseMath.getRowY(sheet, cb.getRow2()) + SheetBaseMath.getRowHeight(sheet, cb.getRow2()) + 3;
        } else if (cb.isCol()) {
            x = SheetBaseMath.getColX(sheet, cb.getCol2()) + SheetBaseMath.getColWidth(sheet, cb.getCol2()) + 3;
            y = SheetBaseMath.getRowY(sheet, cb.getRow()) + 3;
        } else {
            y = SheetBaseMath.getRowY(sheet, cb.getRow2()) + SheetBaseMath.getRowHeight(sheet, cb.getRow2()) + 3;
            x = SheetBaseMath.getColX(sheet, cb.getCol2()) + SheetBaseMath.getColWidth(sheet, cb.getCol2()) + 3;
        }
        Rectangle r = view.getVisibleRect();
        if (x + 22 > r.x + r.width) {
            x = r.x + r.width - 22;
        }
        if (y + 22 > r.y + r.height) {
            y = r.y + r.height - 22;
        }
        fb.setBounds(x, y, 22, 22);
        fb.setVisible(true);
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
            WizzardFinder wf = this.getWizzardFinder(false);
            if (wf != null) {
                wf.changed(e);
            }
            this.showCellEditTip();
            this.showPopupListButton(true);
        } else if (e.hasState(SheetChangeEvent.Changed_Sheet_Scale) || e.hasState(SheetChangeEvent.Changed_Resize) || e.hasState(SheetChangeEvent.Changed_Delete)) {
            this.showPopupListButton(false);
            this.showPopupListButton(true);
            this.revalidateFilterPopupButton();
        } else if (e.hasState(SheetChangeEvent.Changed_AutoFilter) || e.hasState(SheetChangeEvent.Changed_ViewSplit)) {
            this.showHideFilterPopupButton();
        } else if (e.hasState(SheetChangeEvent.Changed_RangeSelect) && e.getChangedBlocks() != null) {
            SortedCellBlockArray changedBlocks = e.getChangedBlocks();
            for (int i = 0; i < changedBlocks.size(); ++i) {
                CellBlock block = changedBlocks.getBlock(i);
                if (null == block || block.isWholeSheet()) continue;
                e.getSheet().register(null);
                break;
            }
        }
        PromptPanel pp = this.getPromptPanel(false);
        if (pp != null) {
            pp.getLeftPane().changed(e);
        }
    }

    @Override
    public void changed(BookChangeEvent e) {
        if (e.isSheetActive() && !e.isGroup()) {
            PromptPanel pp;
            WizzardFinder wf = this.getWizzardFinder(false);
            if (wf != null) {
                wf.changed(e);
            }
            if ((pp = this.getPromptPanel(false)) != null) {
                pp.getLeftPane().changed(e);
            }
            this.showCellEditTip();
            this.showHideFilterPopupButton();
        }
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
    }

    @Override
    public void changed(GraphChangedEvent e) {
        PromptPanel pp = this.getPromptPanel(false);
        if (pp != null) {
            pp.getLeftPane().changed(e);
        }
    }

    @Override
    public void propertyChanged(GraphPropertyChangedEvent e) {
        PromptPanel pp = this.getPromptPanel(false);
        if (pp != null) {
            pp.getLeftPane().propertyChanged(e);
        }
    }

    public boolean showConfirmMessageBox(String title, String msg, int msgType, int optionType, int focusType) {
        return 0 == MessageDialog.show((Component)((Object)this._context), (Object)msg, (String)title, (int)optionType, (int)msgType, (int)focusType, null);
    }

    public boolean showConfirmMessageBox(String title, String msg, int msgType) {
        return this.showConfirmMessageBox(title, msg, msgType, 0, 0);
    }

    public boolean showConfirmMessageBox(String title, String msg) {
        return this.showConfirmMessageBox(title, msg, 3, 0, 0);
    }

    public boolean showConfirmMessageBox(String msg) {
        return this.showConfirmMessageBox(FacadeManager.getDefaultMsgTitle(), msg, 3, 0, 0);
    }

    public void showErrorMessageBox(String msg, int msgType) {
        this.showErrorMessageBox(FacadeManager.getDefaultMsgTitle(), msg, msgType);
    }

    public void showErrorMessageBox(String title, String msg, int msgType) {
        if (this._errorMsgBox == null) {
            MessageDialog.show((Component)((Object)this._context), (Object)msg, (String)title, (int)-1, (int)msgType, (int)0, null);
        } else {
            this._errorMsgBox.show((Component)((Object)this._context), title, msg, msgType);
        }
    }

    public void showPasteMessageBox() {
        boolean ret = false;
        Sheet.ICellsIterator iter = this._context.getBook().getRangeCellsIterator(this._context.getRangeManager().getSelectionRangeInBook(), false, true);
        while (iter.hasNext()) {
            Variant var;
            Object o;
            Cell cell = iter.next();
            if (cell.hasFormula() || !((o = cell.getVar()) instanceof Variant) || (var = (Variant)cell.getVar()) == null || !var.isString()) continue;
            BigDecimal bd = null;
            try {
                bd = var.toBigDecimal();
            }
            catch (SyntaxErrorException e1) {
                bd = null;
            }
            if (bd == null) continue;
            ret = this._context.getFacadeManager().showConfirmMessageBox(FacadeManager.getDefaultMsgTitle(), MultiLanguageKeys.getLocalText("Key_CellValue_ToNumber_Tip"));
            break;
        }
        if (ret) {
            this._context.getActionManager().getAction("CellValue_ToNumber").actionPerformed(null);
        }
    }

    public static String getDefaultMsgTitle() {
        return MultiLanguageKeys.getLocalText("KEY_SPREAD_TITLE");
    }

    public void setErrorMessageBox(IErrorMessageBox errorMsgBox) {
        this._errorMsgBox = errorMsgBox;
    }

    public void showCommentComponent(SpreadView view, int row, int col, boolean visible) {
        if (visible) {
            this.getCommentComponent(true).setParent((JComponent)view);
        }
        this.showCommentComponent(row, col, visible);
    }

    public void showCommentComponent(int row, int col, boolean visible) {
        if (visible) {
            Sheet sheet = this._context.getBook().getActiveSheet();
            Comment comment = sheet.getCell(row, col, false).getComment();
            String author = comment.getAuthor();
            String text = comment.getText();
            boolean bNoAuthor = StringUtil.isEmptyString((String)author);
            boolean bNoText = StringUtil.isEmptyString((String)text);
            if (bNoAuthor && bNoText) {
                KDInfoTip it = this.getCommentComponent(false);
                if (it != null && it.isShowing()) {
                    it.setShowing(false);
                }
            } else {
                KDInfoTip it = this.getCommentComponent(true);
                MergeBlocks merger = sheet.getSheetOption().getMerger(false);
                CellBlock mergeBlock = null;
                if (merger != null) {
                    mergeBlock = merger.searchBlock(row, col);
                }
                int targetRow = -1;
                int targetCol = -1;
                if (mergeBlock == null) {
                    targetRow = row - 1;
                    targetCol = col + 1;
                } else {
                    targetRow = mergeBlock.getRow() - 1;
                    targetCol = mergeBlock.getCol2() + 1;
                }
                Rectangle rect = SheetBaseMath.getCellRect(sheet, targetRow, targetCol, true);
                it.setText("<B>" + (bNoAuthor ? "" : FacadeManager.toXmlString(author)) + ":</B><BR>" + (bNoText ? "" : FacadeManager.toXmlString(text)));
                it.setInnerRectangle(rect);
                it.setShowing(true);
            }
        } else {
            KDInfoTip it = this.getCommentComponent(false);
            if (it != null && it.isShowing()) {
                it.setShowing(false);
            }
        }
    }

    static String toXmlString(String str) {
        String ret = str.replaceAll("&", "&amp;");
        ret = ret.replaceAll("\"", "&quot;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        return ret;
    }

    public void revalidateFilterPopupButton() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        CellBlock cb = sheet.getAutoFilterArea();
        KDSpread spread = this._context.getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)this._context.getSpread().getView(i, j);
                int idx = (i - fvC) * (hC - fhC) + (j - fhC);
                this.revalidateFilterPopupButton(sv, cb, idx, sheet);
            }
        }
    }

    private void revalidateFilterPopupButton(SpreadView sv, CellBlock cb, int idx, Sheet sheet) {
        FilterPopupButton[] fpbs = (FilterPopupButton[])sv.getClientProperty("fileterbutton");
        if (cb != null && fpbs.length > 0) {
            int row = cb.getRow();
            int col = cb.getCol();
            int col2 = cb.getCol2();
            for (int i = col; i <= col2; ++i) {
                FilterPopupButton fpb = fpbs[i - col];
                Rectangle rect = SheetBaseMath.getActualCellRect(sheet, row, i, true);
                fpb.setBounds(rect.x + rect.width - 16, rect.y + rect.height - 16, 16, 16);
            }
            sv.revalidate();
            sv.repaint();
        }
    }

    public void resetFilterPopupBtnsIcon() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        KDSpread spread = this._context.getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)this._context.getSpread().getView(i, j);
                int idx = (i - fvC) * (hC - fhC) + (j - fhC);
                this.resetFilterPopupBtnsIcon(sv, idx, sheet);
            }
        }
    }

    public void resetFilterPopupBtnsIcon(SpreadView sv, int idx, Sheet sheet) {
        FilterPopupButton[] fpbs = (FilterPopupButton[])sv.getClientProperty("fileterbutton");
        if (fpbs == null) {
            return;
        }
        for (int i = 0; i < fpbs.length; ++i) {
            fpbs[i].resetIcon(false);
        }
        List<Integer> autoFilters = sheet.getAutoFileterColIndexs();
        int col = sheet.getAutoFilterArea().getCol();
        for (int colIndex : autoFilters) {
            fpbs[colIndex - col].resetIcon(true);
        }
        if (autoFilters.size() > 0) {
            AlgorithmUtil.calcFilterResult(sheet, -1);
        }
    }

    public void showHideFilterPopupButton() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        CellBlock cb = sheet.getAutoFilterArea();
        KDSpread spread = this._context.getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)this._context.getSpread().getView(i, j);
                int idx = (i - fvC) * (hC - fhC) + (j - fhC);
                this.showHideFilterPopupButton(sv, cb, idx, sheet);
            }
        }
    }

    private void showHideFilterPopupButton(SpreadView sv, CellBlock cb, int idx, Sheet sheet) {
        int i;
        FilterPopupButton[] fpbs = (FilterPopupButton[])sv.getClientProperty("fileterbutton");
        if (fpbs != null && fpbs.length != 0) {
            for (int i2 = 0; i2 < fpbs.length; ++i2) {
                sv.remove((Component)((Object)fpbs[i2]));
            }
        }
        if (cb == null) {
            fpbs = new FilterPopupButton[]{};
            sv.putClientProperty("fileterbutton", fpbs);
            sv.revalidate();
            sv.repaint();
            return;
        }
        int row = cb.getRow();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        int fpbCount = col2 - col + 1;
        fpbs = new FilterPopupButton[fpbCount];
        sv.putClientProperty("fileterbutton", fpbs);
        for (i = 0; i < fpbCount; ++i) {
            Cell cell = sheet.getCell(row, col + i, false);
            String title = "";
            if (cell != null && !cell.isEmptyContent2()) {
                title = cell.getText();
                if (title.length() > 6) {
                    title = title.substring(0, 6) + "...";
                }
            } else {
                title = MessageFormat.format(MultiLanguageKeys.getLocalText("NoColumn", "\u7b2c" + SheetBaseMath.getColumnName(sheet, col + i) + "\u5217"), SheetBaseMath.getColumnName(sheet, col + i));
            }
            fpbs[i] = new FilterPopupButton(sheet, col + i, title);
        }
        this.resetFilterPopupBtnsIcon();
        FilterPopupButton.initGlobalStructOfAutoFilterArea(fpbs);
        for (i = col; i <= col2; ++i) {
            FilterPopupButton fpb = fpbs[i - col];
            Rectangle rect = SheetBaseMath.getActualCellRect(sheet, row, i, true);
            fpb.setBounds(rect.x + rect.width - 16, rect.y + rect.height - 16, 16, 16);
            sv.add((Component)((Object)fpb));
        }
        sv.revalidate();
        sv.repaint();
    }

    public void showPopupListButton(boolean visible) {
        Sheet sheet = this._context.getBook().getActiveSheet();
        Selection sel = sheet.getSheetOption().getSelection();
        int activeRow = sel.getActiveRow();
        int activeCol = sel.getActiveCol();
        MessagedValidate mv = sheet.getValidations().getValidate(sheet, activeRow, activeCol);
        if (!(visible && mv != null && Validate.Type_List.equalsIgnoreCase(mv.getType()) && mv.hasCellRangeList())) {
            PopupListButton plb = this.getPopupListButton(false);
            if (plb != null && plb.isVisible()) {
                plb.setVisible(false);
                SpreadView sv = this._context.getSpread().getActiveView();
                sv.remove((Component)((Object)plb));
                sv.revalidate();
                sv.repaint();
            }
        } else {
            Rectangle rect = SheetBaseMath.getActualCellRect(sheet, activeRow, activeCol, true);
            PopupListButton plb = this.getPopupListButton(true);
            plb.setParentDimension(rect.getSize());
            plb.setBounds(rect.x + rect.width, rect.y + rect.height - 16, 16, 16);
            plb.setListData(mv.getListTextValuePair(sheet));
            plb.setSelectedValue(this._context.getRangeManager().getActiveCellRange().getFormula());
            plb.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Range range = FacadeManager.this._context.getRangeManager().getActiveCellRange();
                    Variant value = ((Validate.TextValuePair)e.getSource()).getValue();
                    range.setFormula("");
                    range.setValue(value);
                    FacadeManager.this._context.requestFocus();
                }
            });
            plb.setUpdateDataListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Sheet sheet = FacadeManager.this._context.getBook().getActiveSheet();
                    Selection sel = sheet.getSheetOption().getSelection();
                    int activeRow = sel.getActiveRow();
                    int activeCol = sel.getActiveCol();
                    MessagedValidate mv = sheet.getValidations().getValidate(sheet, activeRow, activeCol);
                    FacadeManager.this.getPopupListButton(false).setListData(mv.getListTextValuePair(sheet));
                }
            });
            plb.setVisible(true);
            ViewSplitInfo viewSplitInfo = sheet.getSheetOption().getViewSplitInfo();
            boolean freezed = viewSplitInfo.isFreezed();
            int colFixLine = viewSplitInfo.getColFixLine();
            SpreadView sv = freezed && activeCol + 1 == colFixLine ? this._context.getSpread().getActiveNextHView() : this._context.getSpread().getActiveView();
            sv.add((Component)((Object)plb));
            sv.revalidate();
            sv.repaint();
        }
    }

    private void showCellEditTip() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        Selection sel = sheet.getSheetOption().getSelection();
        MessagedValidate mv = sheet.getValidations().getValidate(sheet, sel.getActiveRow(), sel.getActiveCol());
        if (mv != null && !mv.isInputHide() && !StringUtil.isEmptyString((String)(mv.getInputTitle() + mv.getInputMessage()))) {
            int y = SheetBaseMath.getRowY(sheet, sel.getActiveRow());
            int x = SheetBaseMath.getColX(sheet, sel.getActiveCol());
            int h = SheetBaseMath.getRowHeight(sheet, sel.getActiveRow());
            int w = SheetBaseMath.getColWidth(sheet, sel.getActiveCol());
            SpreadView view = this._context.getSpread().getActiveView();
            Point p = SwingUtilities.convertPoint(view, x, y, (Component)((Object)this._context));
            KDInfoTip it = this.getInfoTip(true);
            it.setText("<B>" + mv.getInputTitle() + "</B><br>" + mv.getInputMessage());
            it.setInnerRectangle(new Rectangle(p.x, p.y, w, h));
            it.setShowing(true);
        } else {
            KDInfoTip it = this.getInfoTip(false);
            if (it != null && it.isShowing()) {
                it.setShowing(false);
            }
        }
    }

    public static interface IErrorMessageBox {
        public boolean show(Component var1, String var2, String var3, int var4);
    }

    public static class WizzardType {
    }
}

