/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.ConfirmPasswordDialog;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MessageType;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import java.util.ArrayList;
import java.util.HashMap;

class RangeDecorator
extends Range {
    private SpreadContext _context;

    public RangeDecorator(SpreadContext context, Book book, Sheet sheet, CellBlock block) {
        super(book, sheet, block);
        this._context = context;
    }

    public RangeDecorator(SpreadContext context, Book book, Sheet sheet, Object[] array) {
        super(book, sheet, array);
        this._context = context;
    }

    public RangeDecorator(SpreadContext context, Book book, SortedSheetArray sheets, CellBlock block) {
        super(book, sheets, block);
        this._context = context;
    }

    public RangeDecorator(SpreadContext context, Book book, SortedSheetArray sheets, Object[] array) {
        super(book, sheets, array);
        this._context = context;
    }

    @Override
    protected boolean hasDiffMerge() {
        int col2;
        int col1;
        int row2;
        int row1;
        CellBlock block = this.getBlock(0);
        if (block.isRow()) {
            row1 = block.getRow();
            row2 = block.getRow2();
            col1 = block.getCol();
            col2 = this._book.getActiveSheet().getMaxColIndex();
        } else if (block.isCol()) {
            row1 = block.getRow();
            row2 = this._book.getActiveSheet().getMaxRowIndex();
            col1 = block.getCol();
            col2 = block.getCol2();
        } else {
            row1 = block.getRow();
            row2 = block.getRow2();
            col1 = block.getCol();
            col2 = block.getRow2();
        }
        for (int i = row1; i <= row2; ++i) {
            for (int j = col1; j <= col2; ++j) {
                CellBlock tempBlock = this._book.getActiveSheet().getMergeBlock(i, j);
                if (tempBlock == null) continue;
                this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_HasDiffMerge"), 0);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean actionBreak(MessageType type, HashMap state) {
        if (state == null) {
            return false;
        }
        Object otherCause = state.get("OtherCause");
        if (otherCause == "OtherCause_CellLock") {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_OPER_CELL_LOCKED"), 0);
            return true;
        }
        if (otherCause == "OtherCause_MergeLimit") {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_PASTE"), 0);
            return true;
        }
        if (otherCause == "OtherCause_MultiSelection") {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_OPER_ON_MULTISELECTION"), 0);
            return true;
        }
        if (otherCause == "OtherCause_Overlapped") {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_OPER_ON_OVERLAP"), 0);
            return true;
        }
        if (otherCause == "OtherCause_Mixed") {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_OPER_ON_MULTISELECTION"), 0);
            return true;
        }
        ArrayList al = (ArrayList)state.get("Cause");
        if (al != null) {
            if (al.size() == 0) {
                this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_EDIT_ON_PROTECTED_OBJECT"), 0);
                return true;
            }
            if (al.size() == 1) {
                Protection.EditableArea blockArray = (Protection.EditableArea)al.get(0);
                ConfirmPasswordDialog d = this._context.getFacadeManager().getConfirmPWDialog();
                d.setVisible(true);
                if (!d.isCanceled()) {
                    if (blockArray.checkPassword(d.getPassword())) {
                        return false;
                    }
                    this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_PASSWORDERROR"), 0);
                    return true;
                }
                return true;
            }
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_MultiProtection"), 0);
            return true;
        }
        return true;
    }
}

