/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.flex;

import com.kingdee.bos.ctrl.excel.impl.facade.flex.ActionDelegate;
import com.kingdee.bos.ctrl.excel.impl.facade.flex.FlexTextAreaUI;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class FlexTextArea
extends KDTextArea {
    protected double _defWidth;
    protected double _defHeight;
    protected Style _style;
    protected ActionDelegate _actionDelegate;

    public FlexTextArea() {
        this.setAutoAdjustCaret(false);
        this.setSelectAllOnFocus(false);
        this.setBackground(Color.white);
        this.updateUI();
        this.replaceWrapKey();
        this._actionDelegate = new ActionDelegate((JComponent)((Object)this));
    }

    private void replaceWrapKey() {
        InputMap im = this.getInputMap();
        Object wrap = im.get(KeyStroke.getKeyStroke(10, 0));
        im.put(KeyStroke.getKeyStroke(10, 512), wrap);
        im.put(KeyStroke.getKeyStroke(10, 0), "haha");
    }

    public void updateUI() {
        this.setUI(FlexTextAreaUI.createUI((JComponent)((Object)this)));
    }

    public ActionDelegate getActionDelegate() {
        return this._actionDelegate;
    }

    public int getRowHeight() {
        if (this._style == null) {
            return super.getRowHeight();
        }
        KDFont font = this._style.getKDFont();
        FontMetrics metrics = this.getFontMetrics((Font)font);
        return metrics.getHeight();
    }

    public Color getForeground() {
        if (this._style == null) {
            return super.getForeground();
        }
        return this._style.getFontColor();
    }

    public Font getFont() {
        if (this._style == null) {
            return super.getFont();
        }
        return this._style.getKDFont();
    }

    public void setStyle(Style style) {
        this._style = style;
    }

    public void setDefWidth(double w) {
        this._defWidth = w;
    }

    public void setDelegated(boolean isDelegated) {
        this._actionDelegate.setDelegated(isDelegated);
    }

    public Style getStyle() {
        return this._style;
    }

    public double getDefWidth() {
        return this._defWidth;
    }

    public void setDefHeight(double h) {
        this._defHeight = h;
    }

    public double getDefHeight() {
        return this._defHeight;
    }

    public boolean isThroughable() {
        return this._actionDelegate.isDelegated();
    }

    public void scrollRectToVisible(Rectangle aRect) {
    }

    public Dimension getPreferredSize() {
        double oldHeight = this.getHeight();
        double maxWidth = this.getMaxWidth();
        Insets insets = this.getInsets();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        String text = this.getText();
        int lines = this.getLineCount();
        double newWidth = this.getDefWidth();
        double newHeight = oldHeight;
        int allRows = 0;
        try {
            for (int i = 0; i < lines; ++i) {
                float allW;
                int soff = this.getLineStartOffset(i);
                int eoff = this.getLineEndOffset(i);
                String subText = text.substring(soff, eoff);
                double subWidth = this.getDefWidth();
                int subRows = 1;
                if (subText != null && (double)(allW = (float)(fm.stringWidth(subText) + 4)) > this.getDefWidth()) {
                    int rows;
                    double width = (double)allW / maxWidth;
                    String widthStr = Double.toString(width);
                    try {
                        rows = Double.parseDouble("0" + widthStr.substring(widthStr.indexOf("."), widthStr.length())) > 0.0 ? (int)((double)allW / maxWidth) + 1 + 1 : (int)((double)allW / maxWidth) + 1;
                    }
                    catch (Exception e) {
                        rows = (int)((double)allW / maxWidth) + 1;
                    }
                    subWidth = rows > 1 ? maxWidth : (double)allW % maxWidth;
                    subRows = rows;
                }
                if (newWidth < subWidth) {
                    newWidth = subWidth;
                }
                allRows += subRows;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        newHeight = insets.bottom + insets.top + allRows * this.getRowHeight();
        newHeight = Math.max(newHeight, this._defHeight);
        return new Dimension((int)newWidth, (int)newHeight);
    }

    public void resetSize() {
        this.setSize(this.getPreferredSize());
    }

    public float getMaxWidth() {
        Container parent = this.getParent();
        if (parent instanceof JComponent) {
            return (float)(((JComponent)parent).getVisibleRect().getMaxX() - this.getLocation().getX());
        }
        if (parent != null) {
            return (float)(parent.getBounds().getMaxX() - this.getLocation().getX());
        }
        return (float)(-this.getLocation().getX());
    }
}

