/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.StyleDesigner;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class WizzardConditionalFormat
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private List<ConditionalPanel> conditionalPanelPool = new ArrayList<ConditionalPanel>();
    private ButtonPanel buttonPanel;
    private Condition[] _oldConditions;
    private ShareStyleAttributes[] _oldSas;
    private DeleteWindow deleteWindow;
    private KDPanel panel;
    private static int MAX_HEIGHT = 495;
    private static int MAX_COUNT = 10;
    private static int[] KEY_STORKE = new int[]{69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
    private static String[] KEY_TEXT = new String[]{"E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String CONDITION_TEXT = MultiLanguageKeys.getLocalText("KEY_STYLE", "\u683c\u5f0f");
    private Sheet origalSheet;

    public WizzardConditionalFormat(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardConditionalFormat(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    private void initComps() {
        ConditionalPanel conditionalPanel = new ConditionalPanel(this._context);
        this.conditionalPanelPool.add(conditionalPanel);
        this.buttonPanel = new ButtonPanel();
        this.deleteWindow = new DeleteWindow((Dialog)((Object)this));
        KDScrollPane scrollPane = new KDScrollPane();
        scrollPane.setCustomInsets(new Insets(0, 0, 0, 0));
        this.panel = new KDPanel();
        this.panel.setLayout((LayoutManager)new BoxLayout((Container)this.panel, 1));
        this.panel.setCustomInsets(new Insets(0, 0, 0, 0));
        scrollPane.setViewportView((Component)this.panel);
        Container con = this.getContentPane();
        con.add((Component)scrollPane);
    }

    private void resetBorderTitles() {
        KDPanel c = this.panel;
        String preText = CONDITION_TEXT + "(";
        String afterText = ")...";
        int j = 1;
        for (int i = 0; i < c.getComponentCount(); ++i) {
            Component comp = c.getComponent(i);
            if (!comp.isVisible()) continue;
            ((ConditionalPanel)((Object)comp)).setBorder(BorderFactory.createTitledBorder(CONDITION_TEXT + " " + j + "(" + j + ")"));
            ((ConditionalPanel)((Object)comp)).styleConfig.setText(preText + KEY_TEXT[j - 1] + afterText);
            this.initActionMapListener((ConditionalPanel)((Object)comp), j - 1);
            ++j;
        }
    }

    private ConditionalPanel[] getVisibleConditionalPanels() {
        ArrayList<Component> al = new ArrayList<Component>();
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component comp = this.panel.getComponent(i);
            if (!comp.isVisible()) continue;
            al.add(comp);
        }
        ConditionalPanel[] cps = new ConditionalPanel[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            cps[i] = (ConditionalPanel)((Object)al.get(i));
        }
        return cps;
    }

    private int getVisibleConditionalPanelCount() {
        int i = 0;
        for (int j = 0; j < this.conditionalPanelPool.size(); ++j) {
            ConditionalPanel conditionalPanel = this.conditionalPanelPool.get(i);
            if (!conditionalPanel.isVisible()) continue;
            ++i;
        }
        return i;
    }

    private void resizeWindow() {
        int height = 155 + 85 * (this.getVisibleConditionalPanelCount() - 1);
        boolean isNeedScrollBar = height > MAX_HEIGHT;
        height = isNeedScrollBar ? MAX_HEIGHT : height;
        int width = isNeedScrollBar ? 560 : 540;
        this.setSize(width, height);
    }

    private ConditionalPanel[] getVisibleConditionalPanelsInRightOrder() {
        ConditionalPanel[] cons = new ConditionalPanel[this.getVisibleConditionalPanelCount()];
        int index = 0;
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component comp = this.panel.getComponent(i);
            if (!(comp instanceof ConditionalPanel) || !comp.isVisible()) continue;
            cons[index++] = (ConditionalPanel)((Object)comp);
        }
        return cons;
    }

    private ConditionalPanel getInvisibleConditionalPanelFromPool() {
        if (this.conditionalPanelPool.size() >= MAX_COUNT) {
            return null;
        }
        ConditionalPanel conditionalPanel = new ConditionalPanel(this._context);
        this.conditionalPanelPool.add(conditionalPanel);
        return conditionalPanel;
    }

    private void layoutComps() {
        Container con = this.getContentPane();
        con.setLayout(new BoxLayout(con, 1));
        this.setResizable(false);
        if (this.conditionalPanelPool.size() == 0) {
            this.conditionalPanelPool.add(new ConditionalPanel(this._context));
        }
        this.panel.add((Component)((Object)this.conditionalPanelPool.get(0)));
        con.add((Component)((Object)this.buttonPanel));
        this.resetBorderTitles();
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                for (int i = 0; i < WizzardConditionalFormat.this.conditionalPanelPool.size(); ++i) {
                    ((ConditionalPanel)((Object)WizzardConditionalFormat.this.conditionalPanelPool.get(i))).clear();
                }
            }
        });
    }

    private void initActionMapListener(final ConditionalPanel cp, int j) {
        String keyStr = "style" + j;
        InputMap im = this.rootPane.getInputMap(2);
        ActionMap am = this.rootPane.getActionMap();
        am.remove(keyStr);
        im.remove(KeyStroke.getKeyStroke(KEY_STORKE[j], 8));
        im.put(KeyStroke.getKeyStroke(KEY_STORKE[j], 8), keyStr);
        am.put(keyStr, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cp.styleConfig.doClick();
            }
        });
    }

    private void closeDialog() {
        for (int i = 0; i < this.conditionalPanelPool.size(); ++i) {
            this.conditionalPanelPool.get(i).clear();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        if (this._context.getSpread().getBook().getSelectSheets().size() > 1) {
            WindowUtil.msgboxInfo((Object)MultiLanguageKeys.getLocalText("KEY_GROUP_MultiSheet_Deny", "\u4e0d\u80fd\u5bf9\u591a\u8868\u9875\u9009\u62e9\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"), (String)MultiLanguageKeys.getLocalText("KEY_SPREAD_TITLE", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this._context));
            return false;
        }
        this._oldConditions = null;
        this._oldSas = null;
        Range rg = this._context.getRangeManager().getSelectionRange();
        ConditionalFormatList cfl = this._context.getBook().getActiveSheet().getConditionalFormats();
        this.origalSheet = this._context.getBook().getActiveSheet();
        IntArray intersects = new IntArray();
        boolean allSeted = cfl.calcIntersects(rg, intersects);
        int count = intersects.size();
        if (count > 1) {
            boolean b = WindowUtil.msgboxYesNo((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG1", "\u9009\u5b9a\u533a\u57df\u5305\u542b\u591a\u79cd\u6761\u4ef6\u683c\u5f0f\uff0c\u662f\u5426\u6e05\u9664\u5f53\u524d\u8bbe\u7f6e\u5e76\u7ee7\u7eed!"), (String)"KDSpread");
            if (!b) {
                return false;
            }
        } else if (count == 1) {
            if (!allSeted) {
                int ret = WindowUtil.msgboxYesNoCancel((Component)((Object)this._context), (Object)MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG2", "\u9009\u5b9a\u533a\u57df\u67d0\u4e9b\u5355\u5143\u683c\u672a\u8bbe\u7f6e\u6761\u4ef6\u683c\u5f0f\uff0c\u662f\u5426\u5bf9\u5176\u5b9e\u65bd\u5f53\u524d\u7684\u6570\u636e\u6709\u6548\u6027\u8bbe\u7f6e"), (String)"KDSpread");
                if (0 == ret) {
                    ConditionalFormat cf = cfl.getConditionalFormat(intersects.get(0));
                    this._oldConditions = cf.getConditions();
                    this._oldSas = cf.getSSAs();
                } else if (2 == ret) {
                    return false;
                }
            } else {
                ConditionalFormat cf = cfl.getConditionalFormat(intersects.get(0));
                this._oldConditions = cf.getConditions();
                this._oldSas = cf.getSSAs();
            }
        }
        this.updateByConditionalFormat(this._oldConditions, this._oldSas);
        return true;
    }

    private void updateByConditionalFormat(Condition[] conditions, ShareStyleAttributes[] sas) {
        Container parent = this.getParent();
        this.setLocationRelativeTo(parent);
        this.setLocation(parent.getWidth() / 4, parent.getHeight() / 4);
        if (conditions == null || conditions.length == 0) {
            this.conditionalPanelPool.clear();
            this.panel.removeAll();
            this.layoutComps();
            this.setSize(542, 155);
            return;
        }
        int panelSize = this.conditionalPanelPool.size();
        int conditionSize = conditions.length;
        while (panelSize < conditionSize) {
            this.getInvisibleConditionalPanelFromPool();
            panelSize = this.conditionalPanelPool.size();
        }
        for (int i = 0; i < conditions.length; ++i) {
            ConditionalPanel condPanel = this.conditionalPanelPool.get(i);
            condPanel.configPanel(conditions[i], sas[i]);
            this.panel.remove((Component)((Object)condPanel));
            this.panel.add((Component)((Object)condPanel));
        }
        this.resetBorderTitles();
        this.resizeWindow();
    }

    private void reformatAllCells(Sheet sheet, SortedCellBlockArray scba) {
        CellBlock cb = null;
        for (int i = 0; i < scba.size(); ++i) {
            cb = scba.getBlock(i);
            Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                ci.next().setFormatted(false);
            }
        }
        this._context.getSpread().repaintPartial(sheet, scba, true, true);
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton add;
        private KDButton del;
        private KDButton ok;
        private KDButton cancel;

        public ButtonPanel() {
            this.initComps();
            this.layoutComps();
            this.initListeners();
        }

        private void initComps() {
            this.add = new KDButton(MultiLanguageKeys.getLocalText("KEY_CONDITION_ADD", "\u6dfb\u52a0") + "(A) >>");
            this.del = new KDButton(MultiLanguageKeys.getLocalText("KEY_DELETE", "\u5220\u9664") + "(D)...");
            this.ok = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
        }

        private void layoutComps() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(525, 40));
            this.add((Component)this.add);
            this.add((Component)this.del);
            this.add((Component)this.ok);
            this.add((Component)this.cancel);
            this.add.setBounds(135, 10, 90, 20);
            this.del.setBounds(235, 10, 90, 20);
            this.ok.setBounds(335, 10, 90, 20);
            this.cancel.setBounds(435, 10, 90, 20);
        }

        private void initListeners() {
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == ButtonPanel.this.ok) {
                        ArrayList<Condition> conditionAL = new ArrayList<Condition>();
                        ArrayList<ShareStyleAttributes> saAL = new ArrayList<ShareStyleAttributes>();
                        ConditionalPanel[] rightCps = WizzardConditionalFormat.this.getVisibleConditionalPanelsInRightOrder();
                        for (int i = 0; i < rightCps.length; ++i) {
                            int check = rightCps[i].assembleCondition();
                            if (Condition.isOk(check)) {
                                conditionAL.add(rightCps[i].condition);
                                saAL.add(rightCps[i].ssa);
                                continue;
                            }
                            if (Condition.isSyntaxError(check)) {
                                if (!WizzardConditionalFormat.this._context.getFacadeManager().showConfirmMessageBox(MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG3", "\u5b57\u6bb5\u7684\u8f93\u5165\u516c\u5f0f\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01"))) {
                                    return;
                                }
                                conditionAL.add(rightCps[i].condition);
                                saAL.add(rightCps[i].ssa);
                                continue;
                            }
                            if (!Condition.isValueError(check)) continue;
                            WizzardConditionalFormat.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_CONDITION_MEG4", "\u6240\u9700\u7684\u6700\u5927\u503c\u6216\u6700\u5c0f\u503c\u6570\u503c\u4e22\u5931\u3002"), 64);
                            return;
                        }
                        int size = conditionAL.size();
                        Condition[] conditions = new Condition[size];
                        ShareStyleAttributes[] sas = new ShareStyleAttributes[size];
                        for (int i = 0; i < size; ++i) {
                            conditions[i] = (Condition)conditionAL.get(i);
                            sas[i] = (ShareStyleAttributes)saAL.get(i);
                        }
                        Range range = WizzardConditionalFormat.this.origalSheet.getSelectionRange();
                        range.mergeSelf();
                        WizzardConditionalFormat.this.reformatAllCells(WizzardConditionalFormat.this.origalSheet, range);
                        range.insertConditionalformat(conditions, sas);
                        WizzardConditionalFormat.this.closeDialog();
                    } else if (e.getSource() == ButtonPanel.this.cancel) {
                        WizzardConditionalFormat.this.closeDialog();
                    } else if (e.getSource() == ButtonPanel.this.add) {
                        ConditionalPanel cp = WizzardConditionalFormat.this.getInvisibleConditionalPanelFromPool();
                        if (cp == null) {
                            return;
                        }
                        cp.setVisible(true);
                        WizzardConditionalFormat.this.panel.add((Component)((Object)cp));
                        WizzardConditionalFormat.this.resetBorderTitles();
                        WizzardConditionalFormat.this.resizeWindow();
                    } else if (e.getSource() == ButtonPanel.this.del) {
                        List cps = WizzardConditionalFormat.this.deleteWindow.showDeleteWindow();
                        for (ConditionalPanel cp : cps) {
                            if (cp == null) continue;
                            WizzardConditionalFormat.this.panel.remove((Component)((Object)cp));
                            WizzardConditionalFormat.this.conditionalPanelPool.remove((Object)cp);
                        }
                        int vcp = WizzardConditionalFormat.this.getVisibleConditionalPanelCount();
                        if (vcp == 0) {
                            ConditionalPanel cPanel = WizzardConditionalFormat.this.getInvisibleConditionalPanelFromPool();
                            cPanel.setVisible(true);
                            WizzardConditionalFormat.this.panel.add((Component)((Object)cPanel));
                            ++vcp;
                        }
                        WizzardConditionalFormat.this.resetBorderTitles();
                        WizzardConditionalFormat.this.resizeWindow();
                    }
                    Sheet sheet = WizzardConditionalFormat.this._context.getBook().getActiveSheet();
                    sheet.clearStyleCache();
                }
            };
            this.add.addActionListener(al);
            this.del.addActionListener(al);
            this.ok.addActionListener(al);
            this.cancel.addActionListener(al);
            InputMap im = this.add.getInputMap(2);
            ActionMap am = this.add.getActionMap();
            im.put(KeyStroke.getKeyStroke(65, 8), "add");
            am.put("add", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.add.doClick();
                }
            });
            im = this.del.getInputMap(2);
            am = this.del.getActionMap();
            im.put(KeyStroke.getKeyStroke(68, 8), "del");
            am.put("del", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.del.doClick();
                }
            });
        }
    }

    private class ConditionalPanel
    extends KDPanel {
        private SpreadContext _context;
        private KDComboBox type;
        private KDComboBox op;
        private RangeSelector _tfCustom;
        private KDLabel and;
        private RangeSelector _tfCustom2;
        private KDLabel tip1;
        private KDLabel tip2;
        private PreviewPanel previewPanel;
        private KDButton styleConfig;
        private ShareStyleAttributes ssa;
        private Condition condition;

        private ConditionalPanel(SpreadContext _context) {
            this._context = _context;
            this.initComps();
            this.layoutComps();
            this.initListeners();
        }

        private void configPanel(Condition condition, ShareStyleAttributes ssa) {
            this.ssa = ssa;
            this._tfCustom.setText(condition.getMin());
            this._tfCustom2.setText(condition.getMax());
            this.op.setSelectedIndex(condition.getQualifierIndex());
            this.type.setSelectedIndex(condition.getTypeIndex());
            this.previewPanel.repaint();
        }

        private int assembleCondition() {
            this.condition = new Condition();
            Sheet sheet = this._context.getBook().getActiveSheet();
            this.condition.setTypeIndex(this.type.getSelectedIndex());
            this.condition.setQualifierIndex(this.op.getSelectedIndex());
            int check = this.condition.setMinMax(this._tfCustom.getText(), this._tfCustom2.getText(), sheet);
            return check;
        }

        private void clear() {
            this.type.setSelectedIndex(0);
            this.op.setSelectedIndex(0);
            this._tfCustom.setText("");
            this._tfCustom2.setText("");
            this.ssa = null;
            this.previewPanel.repaint();
        }

        public void requestFocus() {
            this.type.requestFocusInWindow();
        }

        private void initComps() {
            this.type = new KDComboBox((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_CONDITION_VALUE", "\u5355\u5143\u683c\u6570\u503c"), MultiLanguageKeys.getLocalText("KEY_FORMULA", "\u516c\u5f0f")});
            this.op = new KDComboBox((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_VALIDATION_between", "\u4ecb\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_notbetween", "\u672a\u4ecb\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_equal", "\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_notequal", "\u4e0d\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_greater", "\u5927\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_less", "\u5c0f\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_greaterorequal", "\u5927\u4e8e\u6216\u7b49\u4e8e"), MultiLanguageKeys.getLocalText("KEY_VALIDATION_lessorequal", "\u5c0f\u4e8e\u6216\u7b49\u4e8e")});
            this._tfCustom = this._context.getFacadeManager().createRangeSelector("");
            this._tfCustom.setWithOpreatorEqual(true);
            this.and = new KDLabel(MultiLanguageKeys.getLocalText("KEY_CONDITION_TOGETHER", "\u4e0e"));
            this._tfCustom2 = this._context.getFacadeManager().createRangeSelector("");
            this._tfCustom2.setWithOpreatorEqual(true);
            this.tip1 = new KDLabel();
            this.tip1.setText(MultiLanguageKeys.getLocalText("KEY_CONDITION_TIP1", "\u6761\u4ef6\u4e3a\u771f\u65f6\uff0c\u5f85\u7528"));
            this.tip2 = new KDLabel();
            this.tip2.setText(MultiLanguageKeys.getLocalText("KEY_CONDITION_TIP2", "\u683c\u5f0f\u5982\u53f3\u56fe\u6240\u793a:"));
            this.previewPanel = new PreviewPanel();
            this.styleConfig = new KDButton();
        }

        private void layoutComps() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(525, 85));
            this.add((Component)this.type);
            this.add((Component)this.op);
            this.add(this._tfCustom);
            this.add((Component)this.and);
            this.add(this._tfCustom2);
            this.add((Component)this.tip1);
            this.add((Component)this.tip2);
            this.add((Component)((Object)this.previewPanel));
            this.add((Component)this.styleConfig);
            this.type.setBounds(10, 20, 105, 20);
            this.op.setBounds(125, 20, 105, 20);
            this._tfCustom.setBounds(240, 20, 120, 20);
            this.and.setBounds(380, 20, 20, 20);
            this._tfCustom2.setBounds(405, 20, 120, 20);
            this.tip1.setBounds(10, 45, 105, 15);
            this.tip2.setBounds(10, 60, 105, 15);
            this.previewPanel.setBounds(125, 45, 250, 30);
            this.styleConfig.setBounds(405, 50, 90, 20);
        }

        private void initListeners() {
            this.type.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (ConditionalPanel.this.type.getSelectedIndex() == 0) {
                            if (ConditionalPanel.this.op.getSelectedIndex() == 0 || ConditionalPanel.this.op.getSelectedIndex() == 1) {
                                ConditionalPanel.this.op.setVisible(true);
                                ConditionalPanel.this.and.setVisible(true);
                                ConditionalPanel.this._tfCustom2.setVisible(true);
                                ConditionalPanel.this._tfCustom.setBounds(240, 20, 120, 20);
                            } else {
                                ConditionalPanel.this.op.setVisible(true);
                                ConditionalPanel.this._tfCustom.setBounds(240, 20, 285, 20);
                            }
                        } else {
                            ConditionalPanel.this.op.setVisible(false);
                            ConditionalPanel.this.and.setVisible(false);
                            ConditionalPanel.this._tfCustom2.setVisible(false);
                            ConditionalPanel.this._tfCustom.setBounds(125, 20, 400, 20);
                        }
                    }
                }
            });
            this.op.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (ConditionalPanel.this.op.getSelectedIndex() == 0 || ConditionalPanel.this.op.getSelectedIndex() == 1) {
                            ConditionalPanel.this.and.setVisible(true);
                            ConditionalPanel.this._tfCustom2.setVisible(true);
                            ConditionalPanel.this._tfCustom.setBounds(240, 20, 120, 20);
                        } else {
                            ConditionalPanel.this.and.setVisible(false);
                            ConditionalPanel.this._tfCustom2.setVisible(false);
                            ConditionalPanel.this._tfCustom.setBounds(240, 20, 285, 20);
                        }
                    }
                }
            });
            this.styleConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LazyStyleDesigner sd = new LazyStyleDesigner();
                    sd.setPanels(new String[]{"font", "interior"});
                    StyleAttributes sa = null;
                    if (ConditionalPanel.this.ssa == null) {
                        sa = Styles.getDefaultSA();
                    } else {
                        sa = Styles.getSA((ShareStyleAttributes)ConditionalPanel.this.ssa);
                        sa.append((ShareStyleAttributes)Styles.getDefaultStyle(), false);
                        sa.clearDirtyFlag();
                    }
                    sd.setSA(sa);
                    sd.setTitle(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE", "\u5355\u5143\u683c\u683c\u5f0f:"));
                    sd.setLocationRelativeTo((Component)((Object)WizzardConditionalFormat.this));
                    sd.showDialog();
                    boolean needFire = false;
                    if (sd.isChanged()) {
                        StyleAttributes saTemp = ConditionalPanel.this.ssa == null ? Styles.getEmptySA() : Styles.getSA((ShareStyleAttributes)ConditionalPanel.this.ssa);
                        saTemp.setOwner(null);
                        saTemp.clearDirtyFlag();
                        saTemp.replaceDirty((ShareStyleAttributes)sd.getSA());
                        ConditionalPanel.this.ssa = Styles.getSSA((StyleAttributes)saTemp);
                        needFire = true;
                    }
                    sd.dispose();
                    if (needFire) {
                        ConditionalPanel.this.previewPanel.repaint();
                    }
                }
            });
        }

        private class PreviewPanel
        extends KDPanel {
            private TextRender tr = new TextRender(StyleDesigner.getMLS((String)"previewString", (String)"\u91d1\u8776EAS"), StyleDesignerUtil.getStyle4Paint());

            private PreviewPanel() {
                this.setBackground(Color.white);
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            }

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (ConditionalPanel.this.ssa != null) {
                    this.paintViewBackground(g);
                    this.paintViewText(g);
                }
            }

            private void paintViewBackground(Graphics g) {
                if (ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.PATTERN) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.PATTERN_COLOR) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.BACKGROUND_COLOR)) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g;
                int x = 5;
                int y = 5;
                int w = this.getWidth() - 10;
                int h = this.getHeight() - 10;
                Pattern pattern = ConditionalPanel.this.ssa.getPattern();
                if (pattern != null && pattern.equals(Pattern.getPattern((int)0))) {
                    g2.setBackground(this.getBackground());
                    g2.clearRect(x, y, w, h);
                } else {
                    Paint paint = Styles.getStyle((ShareStyleAttributes)ConditionalPanel.this.ssa).getFillPaint();
                    g2.setPaint(paint);
                    g2.fillRect(x, y, w, h);
                }
                g2.setColor(Color.BLACK);
                g2.drawRect(x, y, w, h);
            }

            private void paintViewText(Graphics g) {
                if (ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_COLOR) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_STRIKETHROUGH) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_UNDERLINE) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_NAME) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_SIZE) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_BOLD) || ConditionalPanel.this.ssa.isUnsureValue(StyleAttributes.FONT_ITALIC)) {
                    return;
                }
                Rectangle rect = new Rectangle(this.getWidth(), this.getHeight());
                this.tr.setCellStyle(Styles.getStyle((ShareStyleAttributes)ConditionalPanel.this.ssa));
                this.tr.draw(g, (Shape)rect);
            }
        }
    }

    private class DeleteWindow
    extends KDDialog {
        private KDPanel panel;
        private List<KDCheckBox> cbs;
        private KDButton submit;
        private KDButton cancel;
        private List<ConditionalPanel> result;

        private DeleteWindow(Dialog w) {
            super(w);
            this.panel = new KDPanel();
            this.cbs = new ArrayList<KDCheckBox>();
            this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
            this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
            this.result = new ArrayList<ConditionalPanel>();
            this.panel.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageKeys.getLocalText("KEY_CONDITION_BORDER", "\u9009\u5b9a\u8981\u5220\u9664\u7684\u6761\u4ef6")));
            this.setModal(true);
            this.layoutComps();
            this.addListeners();
        }

        void layoutComps() {
            Container c = this.getContentPane();
            c.setLayout(null);
            KDScrollPane scrolpane = new KDScrollPane();
            scrolpane.setViewportView((Component)this.panel);
            c.add((Component)scrolpane);
            c.add((Component)this.submit);
            c.add((Component)this.cancel);
            this.panel.setLayout((LayoutManager)new BoxLayout((Container)this.panel, 1));
            scrolpane.setBounds(2, 0, 200, 160);
            this.submit.setBounds(30, 170, 80, 20);
            this.cancel.setBounds(120, 170, 80, 20);
            this.setResizable(false);
            this.setSize(210, 220);
        }

        void addListeners() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    for (int i = 0; i < DeleteWindow.this.cbs.size(); ++i) {
                        ((KDCheckBox)DeleteWindow.this.cbs.get(i)).setSelected(false);
                    }
                }
            });
            ActionListener al = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object o = e.getSource();
                    if (o == DeleteWindow.this.submit) {
                        DeleteWindow.this.closeDialog();
                    } else if (o == DeleteWindow.this.cancel) {
                        for (int i = 0; i < DeleteWindow.this.cbs.size(); ++i) {
                            ((KDCheckBox)DeleteWindow.this.cbs.get(i)).setSelected(false);
                        }
                        DeleteWindow.this.closeDialog();
                    }
                }
            };
            this.submit.addActionListener(al);
            this.cancel.addActionListener(al);
        }

        private void initCheckBoxs() {
            int j = 1;
            this.cbs.clear();
            this.panel.removeAll();
            for (int i = 0; i < WizzardConditionalFormat.this.conditionalPanelPool.size(); ++i) {
                KDCheckBox cb = new KDCheckBox(CONDITION_TEXT + " " + j + "(" + j + ")");
                this.cbs.add(cb);
                this.panel.add((Component)cb);
                ++j;
            }
        }

        private List<ConditionalPanel> showDeleteWindow() {
            int i;
            this.initCheckBoxs();
            this.result.clear();
            for (int i2 = 0; i2 < this.cbs.size(); ++i2) {
                this.cbs.get(i2).setSelected(false);
            }
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
            ConditionalPanel[] cps = WizzardConditionalFormat.this.getVisibleConditionalPanels();
            for (i = 0; i < cps.length; ++i) {
                if (!this.cbs.get(i).isSelected()) continue;
                this.result.add(cps[i]);
            }
            for (i = 0; i < this.cbs.size(); ++i) {
                this.cbs.get(i).setSelected(false);
            }
            return this.result;
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

