/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class WizzardNameDefine
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDTextField _nameField;
    private KDList _namesList;
    private RangeSelector _rs;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private KDButton _btnInsert;
    private KDButton _btnDelete;

    public WizzardNameDefine(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(300, 240);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    public WizzardNameDefine(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(300, 240);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this.updateValues();
        return true;
    }

    private void updateValues() {
        this._namesList.removeAllElements();
        if (this._context != null) {
            Book book = this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            SortedNamedObjectNodeArray bookNames = book.getNames();
            int size = bookNames.size();
            for (int i = 0; i < size; ++i) {
                NamedObjectNode node = (NamedObjectNode)bookNames.get(i);
                if (!node.isVisible() || node.isUndefined()) continue;
                this._namesList.addElement((Object)node.getFullName());
            }
            SortedNamedObjectNodeArray sheetNames = sheet.getNames();
            int size2 = sheetNames.size();
            for (int i = 0; i < size2; ++i) {
                NamedObjectNode node = (NamedObjectNode)sheetNames.get(i);
                if (!node.isVisible() || node.isUndefined()) continue;
                this._namesList.addElement((Object)node.getFullName());
            }
            this._rs.prepare();
            this._nameField.setText("");
        }
    }

    private void initComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        KDLabel defineLabel = new KDLabel();
        defineLabel.setText(MultiLanguageKeys.getLocalText("KEY_DEFINENAME"));
        this._nameField = new KDTextField();
        KDScrollPane sp = new KDScrollPane();
        this._namesList = new KDList();
        sp.setViewportView((Component)this._namesList);
        KDLabel refLabel = new KDLabel();
        refLabel.setText(MultiLanguageKeys.getLocalText("KEY_REFPOSITION"));
        this._rs = this._context.getFacadeManager().createRangeSelector(MultiLanguageKeys.getLocalText("KEY_REFPOSITION"));
        this._rs.setAbsRangeName(true);
        this._rs.setWithOpreatorEqual(true);
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CLOSE"));
        this._btnInsert = new KDButton(MultiLanguageKeys.getLocalText("KEY_INSERT"));
        this._btnDelete = new KDButton(MultiLanguageKeys.getLocalText("KEY_DELETE"));
        cp.add((Component)defineLabel);
        cp.add((Component)this._nameField);
        cp.add((Component)sp);
        cp.add((Component)refLabel);
        cp.add(this._rs);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        cp.add((Component)this._btnInsert);
        cp.add((Component)this._btnDelete);
        defineLabel.setBounds(5, 5, 200, 20);
        this._nameField.setBounds(5, 30, 200, 20);
        sp.setBounds(5, 55, 200, 100);
        refLabel.setBounds(5, 160, 200, 20);
        this._rs.setBounds(5, 185, 280, 20);
        this._btnOk.setLimitedSize(false);
        this._btnOk.setBounds(215, 30, 70, 20);
        this._btnCancel.setLimitedSize(false);
        this._btnCancel.setBounds(215, 55, 70, 20);
        this._btnInsert.setLimitedSize(false);
        this._btnInsert.setBounds(215, 80, 70, 20);
        this._btnDelete.setLimitedSize(false);
        this._btnDelete.setBounds(215, 105, 70, 20);
    }

    private void initListeners() {
        BtnHandler bh = new BtnHandler();
        this._nameField.addActionListener((ActionListener)bh);
        this._rs.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this._rs.getActionMap().put("enter", bh);
        this._btnOk.addActionListener((ActionListener)bh);
        this._btnCancel.addActionListener((ActionListener)bh);
        this._btnInsert.addActionListener((ActionListener)bh);
        this._btnDelete.addActionListener((ActionListener)bh);
        this._namesList.addListSelectionListener((ListSelectionListener)new ListHandler());
        this._namesList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this._namesList.getActionMap().put("enter", bh);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WizzardNameDefine.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.setVisible(false);
        super.dispose();
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Sheet sheet;
            NamedObjectNode node;
            Object o = WizzardNameDefine.this._namesList.getSelectedValue();
            if (o == null) {
                return;
            }
            String name = o.toString();
            int index = name.indexOf(33);
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            if ((node = (sheet = WizzardNameDefine.this._context.getBook().getActiveSheet()).getNamedObject(name, true)) != null) {
                WizzardNameDefine.this._nameField.setText(node.getFullName());
                WizzardNameDefine.this._rs.setText(node.getRefersTo());
            }
        }
    }

    private class BtnHandler
    extends AbstractAction {
        private BtnHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String name = WizzardNameDefine.this._nameField.getText();
            String refersTo = WizzardNameDefine.this._rs.getText();
            Range rg = WizzardNameDefine.this._context.getRangeManager().getSelectionRange();
            try {
                if (source == WizzardNameDefine.this._btnOk || source == WizzardNameDefine.this._nameField || source == WizzardNameDefine.this._rs || source == WizzardNameDefine.this._namesList) {
                    if (!StringUtil.isEmptyString((String)name) && !StringUtil.isEmptyString((String)refersTo)) {
                        rg.setName(name, refersTo);
                    }
                    WizzardNameDefine.this.closeDialog();
                } else if (source == WizzardNameDefine.this._btnCancel) {
                    WizzardNameDefine.this.closeDialog();
                } else if (source == WizzardNameDefine.this._btnInsert) {
                    if (!StringUtil.isEmptyString((String)name) && !StringUtil.isEmptyString((String)refersTo)) {
                        rg.setName(name, refersTo);
                        WizzardNameDefine.this.updateValues();
                    } else {
                        WizzardNameDefine.this._nameField.setText("");
                    }
                } else if (source == WizzardNameDefine.this._btnDelete) {
                    rg.setName(name, null);
                    WizzardNameDefine.this.updateValues();
                    WizzardNameDefine.this._rs.setText("");
                    WizzardNameDefine.this._nameField.setText("");
                }
            }
            catch (SyntaxErrorException e2) {
                if (e2.getExtData().equals("name")) {
                    WizzardNameDefine.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_NAME", "\u540d\u79f0\u65e0\u6548"), 0);
                    WizzardNameDefine.this._nameField.requestFocus();
                }
                WizzardNameDefine.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE", "\u533a\u57df\u65e0\u6548"), 0);
                WizzardNameDefine.this._rs.requestFocus();
            }
        }
    }
}

