/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.codahale.metrics.Timer;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.action.StatDialog;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprConst;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOps;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUnknownMethod;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BookFormulaHelper {
    private static StatDialog console = null;
    public static String Sheet_Count = "Sheet_Count";
    public static String Cell_Count = "Cell_Count";
    public static String All_Expr = "All_Expr";
    public static String All_Function = "All_Function";
    public static String Excel_Function = "Excel_Function";
    public static String Biz_Function = "Biz_Function";

    private static boolean isParsed(Book book, Sheet sheet, String formula) {
        ObjectArray al;
        if (StringUtil.isEmptyString((String)formula)) {
            return false;
        }
        Expr expr = sheet.getExpr(null, formula);
        if (expr.hasMethod()) {
            if (expr.hasExternMethod() || expr.isExtensible() || expr.hasAbsMethod()) {
                return false;
            }
            IExprNode[] nodes = expr.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (node instanceof ExprUnknownMethod) {
                    return false;
                }
                if (!(node instanceof ExprMethod) || ((ExprMethod)node).getMethod().getDeclaringClass().isAssignableFrom(ExcelFuncProvider.class)) continue;
                return false;
            }
        }
        if (expr.getParameters(al = new ObjectArray(), true) > 0) {
            int size = al.size();
            for (int ai = 0; ai < size; ++ai) {
                IExprNode[] nodes = ((Expr)al.get(ai)).getParameters();
                for (int i = 0; i < nodes.length; ++i) {
                    Variant v;
                    IExprNode node = nodes[i];
                    if (node instanceof NamedObjectNode) {
                        return false;
                    }
                    if (!(node instanceof ExprConst) || (v = ((ExprConst)node).getValue()) == null || !v.isError()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isExcelFunction(Book book, Sheet sheet, String formula) {
        return BookFormulaHelper.isParsed(book, sheet, formula);
    }

    public static boolean isExcelFunctionNodigit(Book book, Sheet sheet, String formula) {
        boolean isParsed = BookFormulaHelper.isParsed(book, sheet, formula);
        if (!isParsed) {
            return false;
        }
        if (formula.indexOf("=") == -1) {
            return false;
        }
        return !BookFormulaHelper.isDigit(formula);
    }

    private static boolean isDigit(String formula) {
        boolean isDigit;
        String newFormula = formula.replaceAll("=", "");
        try {
            Integer.parseInt(newFormula);
            isDigit = true;
        }
        catch (Exception e) {
            isDigit = false;
        }
        if (isDigit) {
            return true;
        }
        try {
            Double.parseDouble(newFormula);
            isDigit = true;
        }
        catch (Exception e) {
            isDigit = false;
        }
        if (isDigit) {
            return true;
        }
        try {
            Float.parseFloat(newFormula);
            isDigit = true;
        }
        catch (Exception e) {
            isDigit = false;
        }
        return isDigit;
    }

    public static StatResult statBook(Book book) {
        StatResult result = new StatResult();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int cellCount = 0;
        int cellHasContentCount = 0;
        int allExpr = 0;
        int excelFunction = 0;
        int bizFunction = 0;
        ObjectArray al = new ObjectArray();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            Sheet.ICellsIterator cells = sheet.getCellsIterator(null, true, true);
            while (cells.hasNext()) {
                ++cellHasContentCount;
                Cell cell = cells.next();
                if (!cell.hasFormula()) continue;
                ++allExpr;
                Expr expr = ((Cell.ExprData)cell.getVar()).getExpr();
                al.clear();
                expr.getExprOps(al);
                int size = al.size();
                for (int ai = 0; ai < size; ++ai) {
                    IExprNode[] nodes = ((ExprOps)al.get(ai)).getNodes();
                    for (int j = 0; j < nodes.length; ++j) {
                        boolean isBizFunction = true;
                        String functionName = null;
                        IExprNode node = nodes[j];
                        if (node instanceof ExprUnknownMethod) {
                            functionName = ((ExprUnknownMethod)node).getMethodName();
                        } else if (node instanceof ExprMethod) {
                            if (((ExprMethod)node).isExcelMethod()) {
                                isBizFunction = false;
                            }
                            functionName = ((ExprMethod)node).getName();
                        }
                        if (functionName == null) continue;
                        Object obj = map.get(functionName);
                        if (obj != null) {
                            int count = (Integer)obj + 1;
                            map.put(functionName, new Integer(count));
                        } else {
                            map.put(functionName, new Integer(1));
                        }
                        if (isBizFunction) {
                            ++bizFunction;
                            continue;
                        }
                        ++excelFunction;
                    }
                }
            }
            cellCount += (sheet.getMaxRowIndex() + 1) * (sheet.getMaxColIndex() + 1);
        }
        result.setSheetCount(book.getSheetCount());
        result.setCellCount(cellCount);
        result.setCellHasContentCount(cellHasContentCount);
        result.setExprCount(allExpr);
        result.setFunctionCount(bizFunction + excelFunction);
        result.setBizFunctionCount(bizFunction);
        result.setExcelFunctionCount(excelFunction);
        result.setFunctionMap(map);
        return result;
    }

    public static List statBookToList(Book book) {
        StatResult result = BookFormulaHelper.statBook(book);
        HashMap map = result.getFunctionMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add(MultiLanguageKeys.getLocalText("numberOfSheets", "\u8868\u9875\u4e2a\u6570: ") + result.getSheetCount());
        list.add(MultiLanguageKeys.getLocalText("numberOfCells", "\u5355\u5143\u683c\u4e2a\u6570: ") + result.getCellCount());
        list.add(MultiLanguageKeys.getLocalText("numberOfCellsWithContent", "\u6709\u5185\u5bb9\u5355\u5143\u683c\u4e2a\u6570: ") + result.getCellHasContentCount());
        list.add(MultiLanguageKeys.getLocalText("totalNumberOfFormulas", "\u603b\u516c\u5f0f\u4e2a\u6570: ") + result.getExprCount());
        list.add(MultiLanguageKeys.getLocalText("totalNumberOfFunctions", "\u603b\u51fd\u6570\u4e2a\u6570: ") + result.getFunctionCount());
        list.add(MultiLanguageKeys.getLocalText("numberOfInternalFunctions", "\u5185\u90e8\u51fd\u6570\u4e2a\u6570: ") + result.getExcelFunctionCount());
        list.add(MultiLanguageKeys.getLocalText("numberOfBusinessFunctions", "\u4e1a\u52a1\u51fd\u6570\u4e2a\u6570: ") + result.getBizFunctionCount());
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            if (All_Expr == key || All_Function == key || Biz_Function == key || Excel_Function == key) continue;
            Integer value = (Integer)entry.getValue();
            list.add(key.toString() + ": " + value);
        }
        return list;
    }

    public static boolean shouldLog() {
        return console != null && console.isShowing();
    }

    public static void markFunctionCalls() {
        if (!BookFormulaHelper.shouldLog()) {
            return;
        }
        console.markFunctionCalls();
    }

    public static void incressFunctionNums() {
        if (!BookFormulaHelper.shouldLog()) {
            return;
        }
        console.incressFunctionNums();
    }

    public static void decressFunctionNums() {
        if (!BookFormulaHelper.shouldLog()) {
            return;
        }
        console.decressFunctionNums();
    }

    public static Timer getTimer(String name) {
        if (!BookFormulaHelper.shouldLog()) {
            return null;
        }
        return console.getTimer(name);
    }

    public static synchronized void setConsole(StatDialog cp) {
        console = cp;
    }

    public static class StatResult {
        private int sheetCount;
        private int cellCount;
        private int cellHasContentCount;
        private int exprCount;
        private int functionCount;
        private int excelFunctionCount;
        private int bizFunctionCount;
        private HashMap functionMap;

        public int getBizFunctionCount() {
            return this.bizFunctionCount;
        }

        public void setBizFunctionCount(int bizFunctionCount) {
            this.bizFunctionCount = bizFunctionCount;
        }

        public int getCellCount() {
            return this.cellCount;
        }

        public void setCellCount(int cellCount) {
            this.cellCount = cellCount;
        }

        public int getCellHasContentCount() {
            return this.cellHasContentCount;
        }

        public void setCellHasContentCount(int cellHasContentCount) {
            this.cellHasContentCount = cellHasContentCount;
        }

        public int getExcelFunctionCount() {
            return this.excelFunctionCount;
        }

        public void setExcelFunctionCount(int excelFunctionCount) {
            this.excelFunctionCount = excelFunctionCount;
        }

        public int getExprCount() {
            return this.exprCount;
        }

        public void setExprCount(int exprCount) {
            this.exprCount = exprCount;
        }

        public int getFunctionCount() {
            return this.functionCount;
        }

        public void setFunctionCount(int functionCount) {
            this.functionCount = functionCount;
        }

        public HashMap getFunctionMap() {
            return this.functionMap;
        }

        public void setFunctionMap(HashMap functionMap) {
            this.functionMap = functionMap;
        }

        public int getSheetCount() {
            return this.sheetCount;
        }

        public void setSheetCount(int sheetCount) {
            this.sheetCount = sheetCount;
        }
    }
}

