/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlockShadowSpan;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.SortedCellBlockCRArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedCellBlockCenterArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSingleCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;

public class SortedCellBlockNodeShadowSpanArray
extends SortedSpanArray {
    private static final long serialVersionUID = -2075202494702270142L;
    private SortedSingleCellBlockArray _singles = new SortedSingleCellBlockArray();
    private SortedCellBlockCenterArray _blocks = new SortedCellBlockCenterArray();

    public SortedCellBlockNodeShadowSpanArray() {
        super(1048575);
    }

    public int size() {
        return this._singles.size() + this._blocks.size();
    }

    public CellBlockNode[] getReferToBlocks() {
        Object[] all = new CellBlockNode[this._singles.size() + this._blocks.size()];
        if (all.length > 0) {
            this._singles.toArray(all, 0);
            this._blocks.toArray(all, this._singles.size());
        }
        return all;
    }

    public Object getBlockAt(int index) {
        int size1 = this._singles.size();
        int size2 = this._blocks.size();
        if (index < size1) {
            return this._singles.get(index);
        }
        if (index < size1 + size2) {
            return this._blocks.get(index - size1);
        }
        return null;
    }

    public CellBlockNode setDependent(ICalculable refer, CellBlockNode cbReferTo) {
        CellBlockNode referTo = this.insertBlock(cbReferTo);
        Object depList = referTo.getRefs();
        if (depList == null) {
            referTo.setRefs(refer);
        } else if (depList instanceof SortedObjectArray) {
            ((SortedObjectArray)depList).insert((Object)refer);
        } else if (refer != depList) {
            SortedObjectArray newList = new SortedObjectArray();
            newList.insert(depList);
            newList.insert((Object)refer);
            referTo.setRefs(newList);
        }
        return referTo;
    }

    private CellBlockNode insertBlock(CellBlockNode cbReferTo) {
        CellBlockNode referTo;
        boolean singleCell = cbReferTo.isSingleCell();
        SortedObjectArray array = singleCell ? this._singles : this._blocks;
        SortedObjectArray array2 = !singleCell ? this._singles : this._blocks;
        int pos = array.search((Object)cbReferTo);
        if (pos >= 0) {
            referTo = (CellBlockNode)array.get(pos);
        } else {
            referTo = cbReferTo;
            array.insert(pos, (Object)referTo);
            if (!singleCell) {
                this.cover(referTo);
            }
        }
        if (singleCell) {
            array2.remove((Object)cbReferTo);
        }
        return referTo;
    }

    public CellBlockNode searchBlock(CellBlock cb) {
        Object node = null;
        if (cb.isSingleCell()) {
            int pos = this._singles.search(cb.getRow(), cb.getCol());
            if (pos >= 0) {
                node = this._singles.get(pos);
            }
        } else {
            int pos = this._blocks.search(cb);
            if (pos >= 0) {
                node = this._blocks.get(pos);
            }
        }
        return (CellBlockNode)node;
    }

    public void moveBlock(CellBlockNode cbReferTo, int toRow, int toCol) {
        int row = cbReferTo.getRow();
        int col = cbReferTo.getCol();
        if (row != toRow || col != toCol) {
            SortedObjectArray array;
            boolean singleCell = cbReferTo.isSingleCell();
            SortedObjectArray sortedObjectArray = array = singleCell ? this._singles : this._blocks;
            if (!singleCell) {
                this.unCover(cbReferTo);
            }
            array.remove((Object)cbReferTo);
            cbReferTo.offset(toRow - row, toCol - col);
            cbReferTo = this.insertBlock(cbReferTo);
            Object depList = cbReferTo.getRefs();
            if (depList instanceof SortedObjectArray) {
                SortedObjectArray list = (SortedObjectArray)depList;
                for (int i = list.size() - 1; i >= 0; --i) {
                    ICalculable node = (ICalculable)list.get(i);
                    node.updateFormula();
                }
            } else {
                ((ICalculable)depList).updateFormula();
            }
        }
    }

    public ObjectArray removeBlockRefs(int row, int col) {
        if (this.isBothEmpty()) {
            return null;
        }
        ObjectArray al = null;
        int pos = this._singles.search(row, col);
        while (pos >= 0) {
            al = this.collectRefers(al, (CellBlockNode)this._singles.removeByPos(pos));
            pos = this._singles.search(row, col);
        }
        pos = this.searchSpan(row);
        if (pos >= 0) {
            Object refs = ((CellBlockShadowSpan)this.get(pos)).getRefs();
            if (refs instanceof CellBlockNode) {
                CellBlockNode cb = (CellBlockNode)refs;
                if (cb.containsCol(col)) {
                    al = this.collectRefers(al, cb);
                    this._blocks.remove(cb);
                    this.removeByPos(pos);
                }
            } else {
                SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                for (int i = array.searchLeft(col + 1); i >= 0; --i) {
                    CellBlockNode cb = (CellBlockNode)array.get(i);
                    if (!cb.containsCol(col)) continue;
                    al = this.collectRefers(al, cb);
                    this._blocks.remove(cb);
                    this.unCover(cb);
                }
            }
        }
        return al;
    }

    public ObjectArray[] insdel(CellBlock block, boolean bInsert, boolean bRow, boolean bState) {
        ObjectArray aChanged = new ObjectArray();
        ObjectArray aSrc = new ObjectArray();
        this.insdel(block, bInsert, bRow, true, aChanged, aSrc);
        int singleCount = aChanged.size();
        this.insdel(block, bInsert, bRow, false, aChanged, aSrc);
        ObjectArray[] blocks = null;
        int size = aChanged.size();
        if (size > 0) {
            CellBlockNode cbNode;
            int i;
            blocks = new ObjectArray[]{aChanged, aSrc};
            for (i = singleCount - 1; i >= 0; --i) {
                cbNode = (CellBlockNode)aChanged.get(i);
                cbNode.queue(true);
                if (cbNode.isRowColReversed() || cbNode.isRowColInvalid()) continue;
                this._singles.insert(cbNode);
            }
            for (i = size - 1; i >= singleCount; --i) {
                cbNode = (CellBlockNode)aChanged.get(i);
                cbNode.queue(true);
                if (cbNode.isRowColReversed() || cbNode.isRowColInvalid() || this._blocks.insert(cbNode) != null) continue;
                this.cover(cbNode);
            }
            this.merge(null, true);
        }
        return blocks;
    }

    private void insdel(CellBlock block, boolean bInsert, boolean bRow, boolean single, ObjectArray aChanged, ObjectArray aSrc) {
        SortedObjectArray array = single ? this._singles : this._blocks;
        int offset = bRow ? block.getHeight() : block.getWidth();
        int row = block.getRow();
        int col = block.getCol();
        int max = bRow ? 1048575 : 16383;
        for (int i = array.size() - 1; i >= 0; --i) {
            int pos;
            CellBlockNode cbFind;
            int newrc2;
            int rc;
            CellBlockNode cb = (CellBlockNode)array.get(i);
            if (!block.isImpact(cb, bRow)) continue;
            if (!single) {
                this.unCover(cb);
            }
            if (aSrc != null) {
                aSrc.append(cb.clone());
            }
            int n = rc = bRow ? cb.getRow2() : cb.getCol2();
            int n2 = bInsert ? Math.min(max, rc + offset) : (newrc2 = Math.max(bRow ? row - 1 : col - 1, rc - offset));
            if (bRow) {
                cb.setRow2(newrc2);
            } else {
                cb.setCol2(newrc2);
            }
            rc = bRow ? cb.getRow() : cb.getCol();
            if ((bRow ? row : col) <= rc) {
                int newrc;
                int n3 = bInsert ? Math.min(max + 1, rc + offset) : (newrc = Math.max(bRow ? row : col, rc - offset));
                if (bRow) {
                    cb.setRow(newrc);
                } else {
                    cb.setCol(newrc);
                }
            }
            if (!single && cb.isSingleCell() && (cbFind = (pos = this._singles.search(cb)) < 0 ? ((pos = aChanged.indexOf((Object)cb)) >= 0 ? (CellBlockNode)aChanged.get(pos) : null) : (CellBlockNode)this._singles.get(pos)) != null) {
                this.reBindReferTo(cb, cbFind);
            }
            if (aChanged == null) continue;
            aChanged.append(array.removeByPos(i));
        }
    }

    private void reBindReferTo(CellBlockNode src, CellBlockNode targ) {
        Object refs = src.getRefs();
        if (refs instanceof ObjectArray) {
            Object[] cells;
            for (Object cell : cells = ((ObjectArray)refs).getArray()) {
                this.reBindParameter(cell, src, targ);
            }
        } else {
            this.reBindParameter(refs, src, targ);
        }
    }

    private void reBindParameter(Object refs, CellBlockNode src, CellBlockNode targ) {
        if (refs instanceof Cell && ((Cell)refs).getExpr() != null) {
            IExprNode[] parameters = ((Cell)refs).getExpr().getParameters();
            for (int index = 0; index < parameters.length; ++index) {
                if (!src.equals(parameters[index])) continue;
                parameters[index] = targ;
                break;
            }
        }
    }

    public void resumeBlocks(ObjectArray[] blocks) {
        CellBlockNode cb;
        int i;
        if (blocks == null) {
            return;
        }
        ObjectArray acb = blocks[0];
        ObjectArray acbOld = blocks[1];
        for (i = 0; i < acb.size(); ++i) {
            cb = (CellBlockNode)acb.get(i);
            if (cb.isSingleCell()) {
                this._singles.remove(cb);
                continue;
            }
            this._blocks.remove(cb);
            this.unCover(cb);
        }
        this.merge(null, true);
        for (i = 0; i < acb.size(); ++i) {
            cb = (CellBlockNode)acb.get(i);
            cb.copyFrom((CellBlockNode)acbOld.get(i));
            cb.queue(true);
            this.insertBlock(cb);
        }
    }

    private ObjectArray collectRefers(ObjectArray al, CellBlockNode cb) {
        Object depList;
        if (al == null) {
            al = new ObjectArray();
        }
        if ((depList = cb.getRefs()) != null) {
            if (depList instanceof ICalculable) {
                al.append(depList);
            } else {
                al.appendAll((ObjectArray)((SortedObjectArray)depList));
            }
            cb.setRefs(null);
        }
        return al;
    }

    private void cover(CellBlock block) {
        Span list = this.makeContinuousSpanList(block.getRowSpan());
        int end = list.getEnd();
        for (int i = list.getStart(); i <= end; ++i) {
            CellBlockShadowSpan span = (CellBlockShadowSpan)this.get(i);
            Object refs = span.getRefs();
            if (refs instanceof SortedCellBlockCRArray) {
                ((SortedCellBlockCRArray)refs).insert(block);
                continue;
            }
            if (refs instanceof CellBlock) {
                SortedCellBlockCRArray a = new SortedCellBlockCRArray();
                a.insert(refs);
                a.insert(block);
                span.setRefs(a);
                continue;
            }
            span.setRefs(block);
        }
    }

    private void unCover(CellBlock block) {
        int pos = this.searchSpan(block.getRow());
        if (pos >= 0) {
            for (int pos2 = this.searchSpan(block.getRow2()); pos2 >= pos; --pos2) {
                Object refs = ((CellBlockShadowSpan)this.get(pos2)).getRefs();
                if (refs instanceof SortedCellBlockCRArray) {
                    SortedCellBlockCRArray array = (SortedCellBlockCRArray)refs;
                    array.remove(block);
                    if (!array.isEmpty()) continue;
                    this.removeByPos(pos2);
                    continue;
                }
                this.removeByPos(pos2);
            }
        }
    }

    @Override
    public Span createDefaultSpan(Span span) {
        return new CellBlockShadowSpan(span);
    }

    public boolean isBothEmpty() {
        return this._singles.size() == 0 && this._blocks.size() == 0;
    }

    public void updateFormula() {
        int i;
        ObjectArray al = new ObjectArray();
        for (i = this._singles.size() - 1; i >= 0; --i) {
            this.collectRefers(al, (CellBlockNode)this._singles.get(i));
        }
        for (i = this._blocks.size() - 1; i >= 0; --i) {
            this.collectRefers(al, (CellBlockNode)this._blocks.get(i));
        }
        for (i = al.size() - 1; i >= 0; --i) {
            ((ICalculable)al.get(i)).updateFormula();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(16);
        sb.append("[this:");
        sb.append(this.size());
        sb.append("[Covers]");
        int count = 0;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object refs = ((CellBlockShadowSpan)this.get(i)).getRefs();
            if (refs instanceof SortedCellBlockCRArray) {
                count += ((SortedCellBlockCRArray)refs).size();
                continue;
            }
            ++count;
        }
        sb.append(count);
        sb.append(", single:");
        sb.append(this._singles.size());
        sb.append(", block:");
        sb.append(this._blocks.size());
        sb.append("]");
        return sb.toString();
    }

    public SortedSingleCellBlockArray get_singles() {
        return this._singles;
    }

    public void set_singles(SortedSingleCellBlockArray _singles) {
        this._singles = _singles;
    }

    public SortedCellBlockCenterArray get_blocks() {
        return this._blocks;
    }

    public void set_blocks(SortedCellBlockCenterArray _blocks) {
        this._blocks = _blocks;
    }
}

