/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.plaf;

import com.kingdee.bos.ctrl.swing.plaf.PlafUtilies;
import com.kingdee.bos.ctrl.swing.plaf.ThemeProperty;
import com.kingdee.bos.ctrl.swing.plaf.ThemeXMLHandler;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThemeType {
    private HashMap hashmap = null;
    private String directory = null;
    private static final ThemeType singlon = new ThemeType();
    private static final String THEMEINFOFILE = "resources/themeinfo.xml";
    private static final String NODE_DIREVTORY = "directory";
    private static final String NODE_ID = "id";
    private static final String NODE_FILENAME = "filename";
    private static final String NODE_FILEPATH = "filepath";
    private static final String NODE_CANMODIFY = "canmodify";

    private ThemeType() {
        this.readThemeInfo();
    }

    public static ThemeType newInstance() {
        return singlon;
    }

    public void reLoad() {
        this.getHashMap().clear();
        this.readThemeInfo();
    }

    private void readThemeInfo() {
        try {
            ThemeXMLHandler xmlHandler = new ThemeXMLHandler();
            xmlHandler.loadThemeFile(THEMEINFOFILE);
            Element rootNode = xmlHandler.getThemeRootNode();
            String str = PlafUtilies.getNodeValue(rootNode, NODE_DIREVTORY);
            this.setThemeFileDirectory(str);
            NodeList nodeList = rootNode.getChildNodes();
            if (nodeList != null) {
                int len = nodeList.getLength();
                for (int i = 0; i < len; ++i) {
                    Node tempNode = nodeList.item(i);
                    String nodeName = tempNode.getNodeName();
                    if (!nodeName.equals("theme")) continue;
                    String id = PlafUtilies.getAttributeValue(tempNode, NODE_ID);
                    String name = PlafUtilies.getNodeValue(tempNode, NODE_FILENAME);
                    String path = PlafUtilies.getNodeValue(tempNode, NODE_FILEPATH);
                    String canModify = PlafUtilies.getNodeValue(tempNode, NODE_CANMODIFY);
                    ThemeProperty themeProperty = new ThemeProperty(name, path, Integer.parseInt(id), canModify);
                    this.getHashMap().put(Integer.valueOf(id), themeProperty);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeThemeInfo(String filename) {
        try {
            ThemeXMLHandler xmlHandler = new ThemeXMLHandler();
            xmlHandler.loadThemeFile(THEMEINFOFILE);
            Element rootNode = xmlHandler.getThemeRootNode();
            Element newNode = xmlHandler.dom.createElement("theme");
            NodeList nodeList = rootNode.getChildNodes();
            int maxID = 0;
            if (nodeList != null) {
                int len = nodeList.getLength();
                for (int i = 0; i < len; ++i) {
                    String id;
                    Node tempNode = nodeList.item(i);
                    String nodeName = tempNode.getNodeName();
                    if (!nodeName.equals("theme") || Integer.parseInt(id = PlafUtilies.getAttributeValue(tempNode, NODE_ID)) <= maxID) continue;
                    maxID = Integer.parseInt(id);
                }
            }
            rootNode.appendChild(newNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getThemeFilePath(String key) {
        return null;
    }

    public String getThemeFilePath(int id) {
        return null;
    }

    public void removeThemeFilePath(int id) {
        this.getHashMap().remove(new Integer(id));
    }

    public void addThemeFileInfo(String pKey, String pFilePath, int id) {
        this.getHashMap().put(new Integer(id), new ThemeProperty(pKey, pFilePath, id, "false"));
    }

    public void addThemeFileInfo(String pKey, String pFilePath, int id, boolean pCanModify) {
        this.getHashMap().put(new Integer(id), new ThemeProperty(pKey, pFilePath, id, pCanModify ? "true" : "false"));
    }

    private HashMap getHashMap() {
        if (this.hashmap == null) {
            this.hashmap = new HashMap();
        }
        return this.hashmap;
    }

    public void setThemeFileDirectory(String newValue) {
        this.directory = newValue;
    }

    public String getThemeFileDirectory() {
        return this.directory;
    }

    public Object[] getAllThemes() {
        return this.getHashMap().values().toArray();
    }

    public static void main(String[] args) {
        SwingLogUtil.info("hello,world");
        ThemeType themeType = ThemeType.newInstance();
        Object[] datas = themeType.getAllThemes();
        if (datas != null) {
            int j = datas.length;
            for (int i = 0; i < j; ++i) {
                ((ThemeProperty)datas[i]).toParam();
            }
        }
    }
}

