/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.bireport.property.config.factory;

import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.common.bireport.layout.ComponentProperty;
import com.kingdee.bos.bi.model.common.bireport.property.config.BIReportPropConst;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.verify.AbstractVerifier;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.verify.CommonVerifier;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.verify.LengthVerifier;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.verify.NotNullVerifier;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class BIReportPropertyConfigFactory {
    private static final String BIREPORT_CONFIGFILE = "bireport.xml";
    private static final String CHART_CONFIGFILE = "chartcomponent.xml";
    private static final String WORKSHEET_CONFIGFILE = "worksheetcomponent.xml";
    private static List biReportPropertyList = null;
    private static List chartComponentPropertyList = null;
    private static List worksheetComponentPropertyList = null;

    public static synchronized List getBIReportPropertyList(String componentType) throws IOException, JDOMException {
        if ("chart".equalsIgnoreCase(componentType)) {
            return BIReportPropertyConfigFactory.createChartComponentProperty();
        }
        if ("worksheet".equalsIgnoreCase(componentType)) {
            return BIReportPropertyConfigFactory.createWorksheetComponentProperty();
        }
        if ("bireport".equalsIgnoreCase(componentType)) {
            return BIReportPropertyConfigFactory.createBIReportProperty();
        }
        return null;
    }

    private static List createChartComponentProperty() throws IOException, JDOMException {
        return BIReportPropertyConfigFactory.doCreateProperty(chartComponentPropertyList, CHART_CONFIGFILE);
    }

    private static List createWorksheetComponentProperty() throws IOException, JDOMException {
        return BIReportPropertyConfigFactory.doCreateProperty(worksheetComponentPropertyList, WORKSHEET_CONFIGFILE);
    }

    private static List createBIReportProperty() throws IOException, JDOMException {
        return BIReportPropertyConfigFactory.doCreateProperty(biReportPropertyList, BIREPORT_CONFIGFILE);
    }

    private static List doCreateProperty(List propertyList, String configFile) throws IOException, JDOMException {
        if (BIReportPropertyConfigFactory.isEmpty(propertyList)) {
            Element rootE = BIReportPropertyConfigFactory.loadXml(configFile);
            propertyList = BIReportPropertyConfigFactory.readFromXml(rootE);
        }
        return propertyList;
    }

    private static boolean isEmpty(List l) {
        return l == null || l.size() == 0;
    }

    private static Element loadXml(String name) throws IOException, JDOMException {
        InputStream inputStream = BIReportPropConst.class.getResourceAsStream(name);
        return XmlUtil.loadXmlStream((InputStream)inputStream);
    }

    private static List readFromXml(Element rootE) {
        ArrayList<ComponentProperty> list = new ArrayList<ComponentProperty>();
        List categorieEs = rootE.getChildren("category");
        for (Element categoryE : categorieEs) {
            EnumObj category = new EnumObj(categoryE.getAttributeValue("name"), categoryE.getAttributeValue("caption"));
            List propertiesE = categoryE.getChildren("property");
            for (Element propertyE : propertiesE) {
                Element listenersE;
                int i;
                int n;
                ComponentProperty componentProperty = null;
                componentProperty = new ComponentProperty();
                list.add(componentProperty);
                componentProperty.setCategory(category);
                String editType = propertyE.getAttributeValue("type");
                componentProperty.setName(propertyE.getAttributeValue("name"));
                componentProperty.setCaption(propertyE.getAttributeValue("caption"));
                componentProperty.setEditType(editType);
                Element defaultValueE = propertyE.getChild("defaultValue");
                componentProperty.setDefaultValue(defaultValueE.getText());
                Element descriptionE = propertyE.getChild("description");
                componentProperty.setDescription(descriptionE.getText());
                Element verifiersE = propertyE.getChild("verifiers");
                if (verifiersE != null) {
                    List verifiersEs = verifiersE.getChildren("verifier");
                    String notNull = verifiersE.getAttributeValue("notNull");
                    String length = verifiersE.getAttributeValue("length");
                    ArrayList<AbstractVerifier> verifiers = new ArrayList<AbstractVerifier>();
                    if (StringUtil.toBoolean(notNull)) {
                        verifiers.add(new NotNullVerifier(null));
                    }
                    if (!StringUtil.isEmpty(length)) {
                        verifiers.add(new LengthVerifier(null, 0, Integer.parseInt(length)));
                    }
                    if (verifiersEs != null) {
                        n = verifiersEs.size();
                        for (i = 0; i < n; ++i) {
                            Element verifierE = (Element)verifiersEs.get(i);
                            String message = verifierE.getChildText("message");
                            String regularExpression = verifierE.getChildText("expression");
                            verifiers.add(new CommonVerifier(message, regularExpression));
                        }
                    }
                    componentProperty.setVerifiers(verifiers.toArray(new AbstractVerifier[verifiers.size()]));
                }
                if ((listenersE = propertyE.getChild("listeners")) != null) {
                    List listenerEs = listenersE.getChildren("listener");
                    ComponentProperty.Listener[] ls = null;
                    ls = new ComponentProperty.Listener[listenerEs.size()];
                    componentProperty.setListeners(ls);
                    int n2 = listenerEs.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Element listenerE = (Element)listenerEs.get(i2);
                        String source = listenerE.getAttributeValue("source");
                        String action = listenerE.getAttributeValue("action");
                        ComponentProperty componentProperty2 = componentProperty;
                        componentProperty2.getClass();
                        ls[i2] = componentProperty2.new ComponentProperty.Listener(source, action);
                    }
                }
                if (!"comboBox".equalsIgnoreCase(editType)) continue;
                Element iteamsE = propertyE.getChild("iteams");
                List iteams = iteamsE.getChildren("iteam");
                EnumObj[] enums = new EnumObj[iteams.size()];
                n = iteams.size();
                for (i = 0; i < n; ++i) {
                    Element iteamE = (Element)iteams.get(i);
                    enums[i] = new EnumObj(iteamE.getAttributeValue("name"), iteamE.getAttributeValue("caption"));
                }
                componentProperty.setEnums(enums);
            }
        }
        return list;
    }
}

