/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.common.mm.time.builder;

import com.kingdee.bos.bi.model.common.mm.time.TimeDimensionNode;
import com.kingdee.bos.bi.model.common.mm.time.TimeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeTreeModel;
import com.kingdee.bos.bi.model.common.mm.time.TimeUtil;
import com.kingdee.bos.bi.model.common.mm.time.builder.AbstractTimeLevel;
import java.util.Map;

public class HalfYearLevel
extends AbstractTimeLevel {
    public HalfYearLevel(TimeModel timeModel) {
        super(timeModel);
        this.levelCode = 2;
        this.levelName = "halfyear";
        this.levelBriefNumber = "H";
    }

    public HalfYearLevel(TimeModel timeModel, Map params) {
        super(timeModel, params);
        this.levelCode = 2;
        this.levelName = "halfyear";
        this.levelBriefNumber = "H";
    }

    @Override
    protected void doBuilderFromYear(TimeDimensionNode parentNode) {
        boolean cursor = true;
        int theEnd = 2;
        this.createHalfYearTreeNodes(parentNode, 1, 2);
    }

    @Override
    protected void doBuilderFromHalfYear(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromQuarter(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromMonth(TimeDimensionNode parentNode) {
    }

    @Override
    protected void doBuilderFromDate(TimeDimensionNode parentNode) {
    }

    private void createHalfYearTreeNodes(TimeDimensionNode parentNode, int cursor, int theEnd) {
        int startHalfYear = TimeUtil.getHalfYear(this.startTime);
        int endHalfYear = TimeUtil.getHalfYear(this.endTime);
        int year = this.getYear();
        while (cursor <= theEnd) {
            if (!(this.prevLevel.isStart && cursor < startHalfYear || this.prevLevel.isEnd && cursor > endHalfYear)) {
                int month = (cursor - 1) * 6 + 1;
                TimeUtil.resetCalendarAll(this.calendar, year, month, 1);
                TimeDimensionNode halfYearNode = new TimeDimensionNode();
                TimeTreeModel halfYearModel = new TimeTreeModel();
                halfYearModel.setDimensionType(parentNode.getTimeModel().getDimensionType());
                halfYearNode.setTimeModel(halfYearModel);
                halfYearModel.setName(cursor == 1 ? "\u4e0a\u534a\u5e74" : "\u4e0b\u534a\u5e74");
                halfYearModel.setNumber(TimeUtil.getStringTime(this.calendar));
                halfYearModel.setLevelName(this.levelName);
                halfYearModel.setShortNumber(Integer.toString(cursor));
                this.addParamsForDashBoard(halfYearModel);
                parentNode.addChild(halfYearNode);
                if (this.nextLevel != null) {
                    this.value = cursor;
                    this.isStart = this.prevLevel.isStart && cursor == startHalfYear;
                    this.isEnd = this.prevLevel.isEnd && cursor == endHalfYear;
                    this.nextLevel.builder(halfYearNode);
                }
            }
            ++cursor;
        }
    }
}

