/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.commonui.propsheet.panel;

import com.kingdee.bos.bi.model.common.EnumObj;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.ExtendedPropertyDescriptor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.BooleanPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.DatePropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.editor.StringPropertyEditor;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.DateValue;
import com.kingdee.bos.bi.model.commonui.propsheet.beans.value.StringValue;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IProperty;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.IPropertyEditorFactory;
import com.kingdee.bos.bi.model.commonui.propsheet.panel.PropertyDescriptorAdapter;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;

public class PropertyEditorFactory
implements IPropertyEditorFactory {
    private Map typeToEditor = new Hashtable();
    private Map propertyToEditor = new Hashtable();

    public PropertyEditorFactory() {
        this.registerDefaults();
    }

    @Override
    public PropertyEditor createPropertyEditor(IProperty property) {
        return this.doCreatePropertyEditor(property);
    }

    private synchronized PropertyEditor doCreatePropertyEditor(IProperty property) {
        Class clz;
        Object descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = (ExtendedPropertyDescriptor)((Object)((PropertyDescriptorAdapter)property).getDescriptor())) != null && (editor = ((ExtendedPropertyDescriptor)((Object)descriptor)).getEditor()) == null) {
            clz = descriptor.getPropertyEditorClass();
            EnumObj[] enums = ((ExtendedPropertyDescriptor)((Object)descriptor)).getEnums();
            if (clz != null) {
                editor = this.loadPropertyEditor(clz, enums);
            }
            ((ExtendedPropertyDescriptor)((Object)descriptor)).setEditor(editor);
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value, null) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clz = ((PropertyDescriptor)descriptor).getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz, EnumObj[] enums) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            if (enums != null) {
                try {
                    Class[] kTypes = new Class[]{EnumObj[].class};
                    Constructor kConstor = clz.getConstructor(kTypes);
                    Object[] kParams = new Object[]{enums};
                    editor = (PropertyEditor)kConstor.newInstance(kParams);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editor;
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(StringValue.class, StringPropertyEditor.class);
        this.registerEditor(DateValue.class, DatePropertyEditor.class);
        this.registerEditor(Boolean.TYPE, BooleanPropertyEditor.class);
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(IProperty property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(IProperty property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(IProperty property) {
        this.propertyToEditor.remove(property);
    }
}

