/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.rt.appmodel.AppModelView;
import com.kingdee.bos.bi.model.rt.appmodel.DimensionViewRef;
import com.kingdee.bos.bi.model.rt.dim.DimensionMeta;
import com.kingdee.bos.bi.model.rt.dim.DimensionType;
import com.kingdee.bos.bi.model.rt.dim.DimensionView;
import com.kingdee.bos.bi.model.rt.dim.Property;
import com.kingdee.bos.bi.model.ui.exception.BIModelRemoteException;
import com.kingdee.bos.bi.model.util.ModelIOHelper;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.bi.model.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.appmodel.AbstractTreeNode;
import com.kingdee.bos.ctrl.analysis.web.appmodel.IAppModelDataSource;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class AppModelDataSource
implements IAppModelDataSource {
    public String getAppModelDimensionReferences(Context ctx) throws SQLException, IOException {
        ArrayList<AppModelView> appModelViewList = new ArrayList<AppModelView>();
        List appModelIdList = AppModelDataSource.loadAllAppModel(ctx);
        String appModelId2 = null;
        for (String appModelId2 : appModelIdList) {
            appModelViewList.add(AppModelView.fromDB(appModelId2, ctx));
        }
        return AppModelDataSource.toXML(appModelViewList);
    }

    public String getDimensionProperties(Context ctx, String appModelId) throws IOException, SQLException {
        AppModelView appModelView = AppModelView.fromDB(appModelId, ctx);
        return AppModelDataSource.toXML(appModelView, null);
    }

    public String getDimensionProperty(Context ctx, String appModelId, String dimNumber) throws SQLException, IOException {
        AppModelView appModelView = AppModelView.fromDB(appModelId, ctx);
        return AppModelDataSource.toXML(appModelView, dimNumber);
    }

    public AbstractTreeNode getDimensionTreeRoot(Context ctx, String appModelId, String dimNumber, Map params) throws SQLException, BIReportException, BIModelRemoteException {
        AbstractTreeNode root = null;
        HashMap map = new HashMap();
        ModelIOHelper helper = new ModelIOHelper(ctx);
        AppModelView appModelView = AppModelView.fromDB(appModelId, ctx);
        DimensionViewRef dimViewRef = appModelView.getDimRef();
        List dimViews = dimViewRef.getDimensionViews();
        for (DimensionView dv : dimViews) {
            DimensionMeta dm = dv.getDimensionDef();
            DimensionType dt = dm.getDimensionType();
            List properties = dm.getProperties();
            for (Property property : properties) {
                String name = property.getName();
                String field = property.getField();
                if (!dimNumber.equalsIgnoreCase(dt.getName())) continue;
                for (Map.Entry entry : params.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!name.equals(value)) continue;
                    map.put(key, field);
                }
            }
        }
        root = "org".equalsIgnoreCase(dimNumber) ? helper.getRTOrgTree(appModelId, map) : ("year".equalsIgnoreCase(dimNumber) ? helper.getRTYearTree(appModelId, map) : ("period".equalsIgnoreCase(dimNumber) ? helper.getRTPeriodTree(appModelId, map) : ("metric".equalsIgnoreCase(dimNumber) ? helper.getRTMetricTree(appModelId, map) : ("measure".equalsIgnoreCase(dimNumber) ? helper.getRTMeasureTree(appModelId, map) : helper.getRTCustomDefineTree(appModelId, dimNumber, map)))));
        return root;
    }

    private static String toXML(List appModelViewList) throws IOException {
        Element rootElement = new Element("root");
        Element appModelElement = null;
        Element dimRefElement = null;
        AppModelView appModelView2 = null;
        for (AppModelView appModelView2 : appModelViewList) {
            appModelElement = new Element("node");
            appModelElement.setAttribute("value", appModelView2.getId());
            appModelElement.setAttribute("alias", appModelView2.getName());
            DimensionViewRef dimViewRef = appModelView2.getDimRef();
            List dimViews = dimViewRef.getDimensionViews();
            for (DimensionView dv : dimViews) {
                DimensionType dt = dv.getDimensionDef().getDimensionType();
                dimRefElement = new Element("node");
                dimRefElement.setAttribute("value", dt.getName());
                dimRefElement.setAttribute("alias", dt.getAlias());
                appModelElement.addContent((Content)dimRefElement);
            }
            rootElement.addContent((Content)appModelElement);
        }
        return XmlUtil.toString(rootElement);
    }

    private static String toXML(AppModelView appModelView, String dimNumber) throws IOException {
        Element rootElement = new Element("root");
        Element dimRefElement = null;
        Element dimpropertyElement = null;
        DimensionViewRef dimViewRef = appModelView.getDimRef();
        List dimViews = dimViewRef.getDimensionViews();
        for (DimensionView dv : dimViews) {
            DimensionMeta dm = dv.getDimensionDef();
            DimensionType dt = dm.getDimensionType();
            if (!StringUtil.isEmpty(dimNumber) && !dimNumber.equalsIgnoreCase(dt.getName())) continue;
            dimRefElement = new Element("node");
            dimRefElement.setAttribute("value", dt.getName());
            dimRefElement.setAttribute("alias", dt.getAlias());
            List properties = dm.getProperties();
            Property property2 = null;
            for (Property property2 : properties) {
                dimpropertyElement = new Element("node");
                dimpropertyElement.setAttribute("value", property2.getName());
                dimpropertyElement.setAttribute("alias", property2.getAlias());
                dimpropertyElement.setAttribute("type", AppModelDataSource.changeDataType(property2.getDataType()));
                dimRefElement.addContent((Content)dimpropertyElement);
            }
            rootElement.addContent((Content)dimRefElement);
        }
        return XmlUtil.toString(rootElement);
    }

    private static String changeDataType(String dataType) {
        if (dataType.equalsIgnoreCase("nvarchar")) {
            return "String";
        }
        if (dataType.equalsIgnoreCase("datetime")) {
            return "Date";
        }
        if (dataType.equalsIgnoreCase("int") || dataType.equalsIgnoreCase("decimal")) {
            return "Number";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List loadAllAppModel(Context ctx) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        Connection cn = BISystem.getJdbcConnection((Context)ctx);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select FID from T_BI_APPMODEL where FPublishFlag=1 order by Ftype desc,FLastUpdateTime desc";
        try {
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("FID"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)stmt, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return list;
    }
}

