/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.appmodel;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.eas.formula.IEASFormulaCalculate;
import com.kingdee.bos.bi.model.rt.appmodel.AppModel;
import com.kingdee.bos.bi.model.rt.appmodel.DataRule;
import com.kingdee.bos.bi.model.rt.appmodel.EASFormulaUtil;
import com.kingdee.bos.bi.model.rt.appmodel.FIPeriod;
import com.kingdee.bos.bi.model.rt.appmodel.Formula;
import com.kingdee.bos.bi.model.rt.fact.Fact;
import com.kingdee.bos.bi.model.ui.exception.BIModelBizException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASDataRule
extends DataRule {
    private Formula formula;
    private static final Logger log = CommonLogger.getLogger(EASDataRule.class);
    private static final String PERMISSION = "\u6743\u9650";
    private static final String EAS_FORMULA_NO_PERMISSION_ERROR = "EAS\u53d6\u6570\u516c\u5f0f\u65e0\u6743\u9650,\u516c\u5f0f:";

    public EASDataRule(AppModel appmodel, String schemaId, int itemorder, Map mapParameter, Formula formula) {
        super(appmodel, schemaId, itemorder, mapParameter);
        this.formula = formula;
        this.type = "eas";
    }

    @Override
    public void calc(Date date, Connection cn, Context ctx, Map scheduleConfig, Map mapDataFlag, StringBuffer sbError) throws BIModelBizException {
        long lStart = System.currentTimeMillis();
        Date calDate = this.adjustDate(date, scheduleConfig);
        FIPeriod nowPeriod = this.checkDate(calDate, false);
        if (nowPeriod == null) {
            return;
        }
        ArrayList lstFormular = new ArrayList();
        ArrayList lstParameter = new ArrayList();
        this.getFormulas(lstFormular, lstParameter, nowPeriod);
        HashMap<String, Object> mapCalc = new HashMap<String, Object>();
        mapCalc.put("bizDate", calDate);
        mapCalc.put("formulaCompany", ContextUtil.getCurrentOrgUnit((Context)ctx));
        mapCalc.put("formulaIsUnpassedVoucherIncluded", Boolean.toString(this.formula.isUnpassedVoucherIncluded));
        mapCalc.put("formulaIsDetailItemBalanceInclude", Boolean.toString(this.formula.isDetailItemBalanceIncluded));
        mapCalc.put("formulaIsSubItemBalanceInclude", Boolean.toString(this.formula.isSubItemBalanceIncluded));
        IEASFormulaCalculate calculator = this.getCalculator();
        Variant[] v = null;
        try {
            v = calculator.calculateFormulas(lstFormular, calDate, mapCalc, ctx);
        }
        catch (Exception e) {
            throw new BIModelBizException("\u8fd0\u7b97EAS\u53d6\u6570\u516c\u5f0f\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
        v = this.handeleReturnValue(v, lstFormular, sbError);
        log.info((Object)("calc eas formula cost time " + (System.currentTimeMillis() - lStart)));
        this.UpdateToDB(v, lstParameter, cn, mapDataFlag, sbError);
        log.info((Object)("calc formula(include update to db) cost time " + (System.currentTimeMillis() - lStart)));
    }

    private IEASFormulaCalculate getCalculator() throws BIModelBizException {
        IEASFormulaCalculate formulaAppManager = null;
        try {
            formulaAppManager = (IEASFormulaCalculate)Class.forName("com.kingdee.eas.bi.application.model.formula.app.BiFormulaAppManager").newInstance();
        }
        catch (Exception e) {
            String err = "\u65e0\u6cd5\u627e\u5230EAS\u53d6\u6570\u516c\u5f0f\u7684\u8fd0\u7b97\u5f15\u64ce\u3002\u539f\u56e0\uff1a\u60a8\u53ef\u80fd\u4e0d\u5728EAS\u73af\u5883\u6216\u8005\u672a\u6253\u4e0aEAS\u7684\u6700\u65b0\u8865\u4e01\uff1aPT031718";
            log.error((Object)err, (Throwable)e);
            throw new BIModelBizException(err, e);
        }
        return formulaAppManager;
    }

    private void UpdateToDB(Variant[] values, List parameters, Connection cn, Map mapDataFlag, StringBuffer sbError) {
        Iterator itPar = parameters.iterator();
        int i = 0;
        HashMap mapStatement = new HashMap();
        while (itPar.hasNext()) {
            String error;
            Variant value;
            Map mapParameter = (Map)itPar.next();
            if ((value = values[i++]) == null) continue;
            Fact m = new Fact(this.appmodel.getAppModelView().getDimRef());
            Map mapKey = null;
            try {
                mapKey = this.appmodel.findInnerKey(mapParameter, cn);
            }
            catch (SQLException e1) {
                error = "\u67e5\u627e\u4e3b\u952e\u65f6\u5931\u8d25\uff01";
                log.error((Object)error, (Throwable)e1);
                sbError.append(error);
                sbError.append("\n\r");
                continue;
            }
            try {
                BigDecimal v = value.toBigDecimal();
                m.updateFactData(this.appmodel.getPubnumber(), v, mapKey, 0, cn, mapDataFlag, mapStatement, true);
            }
            catch (SQLException e) {
                error = "\u5199\u5165\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b9a\u4e49\u7684\u5ea6\u91cf\u7684\u6570\u636e\u548c\u6709\u6548\u4f4d\u662f\u5426\u6709\u8db3\u591f\u7684\u957f\u5ea6\uff01" + e.getMessage();
                log.error((Object)error, (Throwable)e);
                sbError.append(error);
                sbError.append("\n\r");
            }
            catch (SyntaxErrorException e) {
                log.error((Object)("\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01" + value), (Throwable)e);
            }
        }
        DBUtil.executeBatchStatement(mapStatement, sbError, true);
    }

    private void getFormulas(List formulas, List parameters, FIPeriod period) {
        Map map = this.getParameters();
        List lstOrg = (List)map.get("org");
        List lstMetric = (List)map.get("metric");
        String measure = (String)((List)map.get("measure")).get(0);
        for (String metric : lstMetric) {
            for (String org : lstOrg) {
                HashMap<String, Object> mapParameter = new HashMap<String, Object>();
                mapParameter.put("org", org);
                mapParameter.put("metric", metric);
                mapParameter.put("measure", measure);
                mapParameter.put("year", new Integer(period.getYear()));
                mapParameter.put("period", new Integer(period.getPeriod()));
                String f = EASFormulaUtil.adjustFormular(this.formula.formula, mapParameter);
                parameters.add(mapParameter);
                formulas.add(f);
            }
        }
    }

    private Variant[] handeleReturnValue(Variant[] reVariant, List formulas, StringBuffer sbError) {
        ArrayList<Variant> standardValueList = new ArrayList<Variant>();
        if (reVariant instanceof Variant[]) {
            Variant[] var = reVariant;
            for (int p = 0; p < var.length; ++p) {
                if (null != var[p].getValue()) {
                    if (!(var[p].getValue() instanceof BigDecimal) && !(var[p].getValue() instanceof Integer)) {
                        String error;
                        Object value = var[p].getValue();
                        if (value.toString().indexOf(PERMISSION) > -1) {
                            error = EAS_FORMULA_NO_PERMISSION_ERROR + formulas.get(p);
                            sbError.append(error);
                            sbError.append("\n\r");
                            standardValueList.add(null);
                            continue;
                        }
                        error = value.toString() + " " + formulas.get(p);
                        sbError.append(error);
                        sbError.append("\n\r");
                        standardValueList.add(null);
                        continue;
                    }
                    standardValueList.add(var[p]);
                    continue;
                }
                standardValueList.add(null);
            }
        }
        if (sbError.length() > 0) {
            sbError.deleteCharAt(sbError.length() - 1);
            sbError.deleteCharAt(sbError.length() - 1);
        }
        return standardValueList.toArray(new Variant[0]);
    }
}

