/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.rt.migration;

import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.DB.DBUtil;
import com.kingdee.bos.bi.model.rt.migration.JDBCType2KSQLTypeUtil;
import com.kingdee.bos.bi.model.rt.migration.SqlColumn;
import com.kingdee.bos.bi.model.rt.migration.TableInfo;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.schema.Sql2kUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.jdbc.OracleResultSetMetaData;
import org.apache.log4j.Logger;

public class TableMigration {
    private static final Logger log = CommonLogger.getLogger(TableMigration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cloneTable(Context ctx, TableInfo srcTableInfo, TableInfo destTableInfo) throws SQLException, DBCenterException, SqlTranslateException {
        Connection srcCon = null;
        Connection destCon = null;
        String srcTableName = srcTableInfo.getTableName();
        List srcColumns = TableMigration.getTableColumns(ctx, srcTableInfo);
        String createTableSQL = TableMigration.getCreateTableSQL(ctx, destTableInfo, srcColumns);
        try {
            destCon = DBCenterManager.getConnection((Context)ctx, (String)destTableInfo.getDBCenterId());
            DBUtil.executeUpdate(createTableSQL, destCon);
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeConnection(destCon);
            throw throwable;
        }
        DBCenterUtil.closeConnection((Connection)destCon);
        StringBuffer temp = new StringBuffer();
        temp.append("SELECT ");
        for (SqlColumn col : srcColumns) {
            temp.append(col.getName()).append(",");
        }
        temp.deleteCharAt(temp.length() - 1);
        String srcSQL = null;
        if (srcTableName.trim().indexOf(" ") > 0) {
            temp.append(" FROM ( ").append(srcTableName).append(" ) Z ");
            srcSQL = StringUtil.deleteOrderGroup(StringUtil.replaceBlank(temp.toString()));
        } else {
            temp.append(" FROM ").append(srcTableName);
            srcSQL = temp.toString();
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            srcCon = DBCenterManager.getConnection((Context)ctx, (String)srcTableInfo.getDBCenterId());
            stmt = srcCon.prepareStatement(srcSQL);
            Object[] params = srcTableInfo.getParams();
            if (params != null) {
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            rs = stmt.executeQuery();
            TableMigration.transferResultsetToTable(ctx, destTableInfo, rs, srcColumns, true);
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeAll((Connection)srcCon, stmt, rs);
            throw throwable;
        }
        DBCenterUtil.closeAll((Connection)srcCon, (Statement)stmt, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableColumns(Context ctx, TableInfo srcTable) throws SQLException, DBCenterException {
        ArrayList<SqlColumn> columnList = new ArrayList<SqlColumn>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = DBCenterManager.getConnection((Context)ctx, (String)srcTable.getDBCenterId());
            String sql = StringUtil.getViewSQL(srcTable.getTableName(), true);
            stmt = con.prepareStatement(sql);
            Object[] params = srcTable.getParams();
            if (params != null) {
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    stmt.setObject(i + 1, params[i]);
                }
            }
            rs = stmt.executeQuery();
            ResultSetMetaData metaData = rs.getMetaData();
            int n = metaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                SqlColumn col = new SqlColumn(metaData.getColumnName(i + 1));
                col.setScale(metaData.getScale(i + 1));
                col.setNull(metaData.isNullable(i + 1) == 1);
                col.setLength(metaData.getColumnDisplaySize(i + 1));
                col.setPrecision(metaData.getPrecision(i + 1));
                col.setDataType(metaData.getColumnTypeName(i + 1));
                if (DBUtil.isOracle(con)) {
                    if ("VARCHAR2".equalsIgnoreCase(col.getType()) && TableMigration.isNCHAR(metaData, i + 1)) {
                        col.setDataType("NVARCHAR2");
                    }
                    if ("NUMBER".equalsIgnoreCase(col.getType()) && col.getPrecision() <= 0 && col.getScale() <= 0) {
                        col.setPrecision(28);
                        col.setScale(10);
                    }
                }
                col.setDataType(JDBCType2KSQLTypeUtil.jdbcType2ksqlType(col.getType()));
                if (col.getType().endsWith("BLOB")) {
                    col.setLength(524288000);
                } else if (col.getType().endsWith("CLOB")) {
                    col.setLength(0xA00000);
                }
                columnList.add(col);
            }
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeAll((Connection)con, stmt, rs);
            throw throwable;
        }
        DBCenterUtil.closeAll((Connection)con, (Statement)stmt, (ResultSet)rs);
        return columnList;
    }

    public static boolean isNCHAR(ResultSetMetaData metaData, int columnNum) throws SQLException {
        return metaData instanceof OracleResultSetMetaData && ((OracleResultSetMetaData)metaData).isNCHAR(columnNum);
    }

    public static String getCreateTableSQL(Context ctx, TableInfo destTable, List columns) throws SQLException, DBCenterException, SqlTranslateException {
        SqlCreateTableStmt stmt = new SqlCreateTableStmt(destTable.getTableName());
        for (SqlColumn column : columns) {
            SqlColumnDef colDef = new SqlColumnDef();
            colDef.name = column.getName();
            colDef.dataType = column.getType().toUpperCase();
            colDef.length = column.getLength();
            colDef.precision = column.getPrecision();
            colDef.scale = column.getScale();
            colDef.allowNull = column.isNull();
            stmt.columnList.add(colDef);
        }
        Sql2kUtil.validateTable((SqlCreateTableStmt)stmt);
        String dbType = TableMigration.getDBStringType(ctx, destTable.getDBCenterId());
        SQLFormater formater = FormaterFactory.getFormater((int)TableMigration.getDBIntType(dbType));
        formater.setOptions(new FormatOptions());
        formater.formatStmt((SqlStmt)stmt);
        return "/*dialect*/" + formater.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDBStringType(Context ctx, String dbCenterId) throws DBCenterException, SQLException {
        Connection con = null;
        try {
            con = DBCenterManager.getConnection((Context)ctx, (String)dbCenterId);
            String string = DBUtil.getDBType(con);
            return string;
        }
        finally {
            DBCenterUtil.closeConnection((Connection)con);
        }
    }

    private static int getDBIntType(String dbType) throws SQLException {
        if ("oracle".equals(dbType)) {
            return 7;
        }
        if ("sqlServer".equals(dbType)) {
            return 3;
        }
        if ("db2".equals(dbType)) {
            return 1;
        }
        throw new SQLException("Unsupported dbtype[" + dbType + "]!", dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferResultsetToTable(Context ctx, TableInfo destTable, ResultSet srcResultset, List columns, boolean isDeleteOldData) throws SQLException, DBCenterException {
        Connection con;
        block9: {
            String destTableName = destTable.getTableName();
            StringBuffer sql = new StringBuffer();
            boolean hasContainsLOB = false;
            for (SqlColumn tmpCol : columns) {
                if (tmpCol.getType().indexOf("LOB") >= 0) {
                    hasContainsLOB = true;
                }
                sql.append(tmpCol.getName()).append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            con = null;
            try {
                con = DBCenterManager.getConnection((Context)ctx, (String)destTable.getDBCenterId());
                if (isDeleteOldData) {
                    String delete = "delete from " + destTableName;
                    DBUtil.executeUpdate(delete, con);
                }
                if (hasContainsLOB) {
                    if (DBUtil.isMSSQL(con)) {
                        TableMigration.doResultsetInsert(srcResultset, columns, destTableName, con, sql, hasContainsLOB);
                    } else {
                        TableMigration.doObjectInsert(srcResultset, columns, destTableName, con, sql, hasContainsLOB);
                    }
                    break block9;
                }
                if (DBUtil.isDB2(con)) {
                    TableMigration.doObjectInsert(srcResultset, columns, destTableName, con, sql, hasContainsLOB);
                    break block9;
                }
                TableMigration.doResultsetInsert(srcResultset, columns, destTableName, con, sql, hasContainsLOB);
            }
            catch (Throwable throwable) {
                DBCenterUtil.closeConnection(con);
                throw throwable;
            }
        }
        DBCenterUtil.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doResultsetInsert(ResultSet srcResultset, List columns, String destTable, Connection destConnection, StringBuffer sql, boolean hasContainsLOB) throws SQLException {
        sql.insert(0, "SELECT ").append(" FROM ").append(destTable);
        String destSQL = sql.toString();
        Statement stmt = null;
        ResultSet destResultset = null;
        try {
            stmt = DBUtil.isMSSQL(destConnection) ? destConnection.createStatement(1003, 1008) : destConnection.createStatement(1004, 1008);
            destResultset = stmt.executeQuery(destSQL);
            int curRowIndex = 0;
            while (srcResultset.next()) {
                ++curRowIndex;
                destResultset.moveToInsertRow();
                int colIndex = 0;
                Iterator it = columns.iterator();
                while (it.hasNext()) {
                    Object value;
                    ++colIndex;
                    SqlColumn destCol = (SqlColumn)it.next();
                    if (destCol.getType().equals("INT")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            destResultset.updateObject(colIndex, value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.getType().equals("DECIMAL")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            destResultset.updateObject(colIndex, value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.getType().indexOf("CHAR") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            destResultset.updateString(colIndex, (String)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.getType().indexOf("CLOB") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            destResultset.updateString(colIndex, (String)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.getType().indexOf("BLOB") >= 0) {
                        value = srcResultset.getBytes(colIndex);
                        if (value != null) {
                            destResultset.updateBytes(colIndex, (byte[])value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    if (destCol.getType().indexOf("TIME") >= 0) {
                        value = srcResultset.getTimestamp(colIndex);
                        if (value != null) {
                            destResultset.updateTimestamp(colIndex, (Timestamp)value);
                            continue;
                        }
                        destResultset.updateNull(colIndex);
                        continue;
                    }
                    value = srcResultset.getObject(colIndex);
                    if (value != null) {
                        destResultset.updateObject(colIndex, value);
                        continue;
                    }
                    log.error((Object)("unSupported null value insert into table\u3010" + destTable + "\u3011, column\u3010" + destCol.getName() + "\u3011, row\u3010" + curRowIndex + "\u3011\uff01"));
                }
                try {
                    destResultset.insertRow();
                }
                catch (SQLException e) {
                    log.error((Object)("an error occurred while do result insert\uff01 sqlcode\u3010" + e.getErrorCode() + "\u3011, sqlstat\u3010" + e.getSQLState() + "\u3011,sqlmessage\u3010" + e.getMessage() + "\u3011\uff1a" + e));
                }
            }
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeResultSet(destResultset);
            DBCenterUtil.closeStatement(stmt);
            throw throwable;
        }
        DBCenterUtil.closeResultSet((ResultSet)destResultset);
        DBCenterUtil.closeStatement((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doObjectInsert(ResultSet srcResultset, List columns, String destTable, Connection destConnection, StringBuffer sql, boolean hasContainsLOB) throws SQLException {
        sql.insert(0, "INSERT INTO " + destTable + " (").append(") VALUES (");
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        PreparedStatement stmt = null;
        try {
            String destSQL = sql.toString();
            stmt = destConnection.prepareStatement(destSQL);
            int curRowIndex = 0;
            int batchRowSize = 0;
            while (srcResultset.next()) {
                ++curRowIndex;
                int colIndex = 0;
                Iterator it = columns.iterator();
                while (it.hasNext()) {
                    Object value;
                    ++colIndex;
                    SqlColumn destCol = (SqlColumn)it.next();
                    if (destCol.getType().equals("INT")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            stmt.setObject(colIndex, value);
                            continue;
                        }
                        stmt.setNull(colIndex, 4);
                        continue;
                    }
                    if (destCol.getType().equals("DECIMAL")) {
                        value = srcResultset.getObject(colIndex);
                        if (value != null) {
                            stmt.setObject(colIndex, value);
                            continue;
                        }
                        stmt.setNull(colIndex, 3);
                        continue;
                    }
                    if (destCol.getType().indexOf("CHAR") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            stmt.setString(colIndex, (String)value);
                            continue;
                        }
                        stmt.setNull(colIndex, 12);
                        continue;
                    }
                    if (destCol.getType().indexOf("CLOB") >= 0) {
                        value = srcResultset.getString(colIndex);
                        if (value != null) {
                            stmt.setString(colIndex, (String)value);
                            continue;
                        }
                        stmt.setString(colIndex, "");
                        continue;
                    }
                    if (destCol.getType().indexOf("BLOB") >= 0) {
                        value = srcResultset.getBytes(colIndex);
                        if (value != null) {
                            stmt.setBytes(colIndex, (byte[])value);
                            continue;
                        }
                        if (DBUtil.isMSSQL(destConnection)) {
                            stmt.setBytes(colIndex, null);
                            continue;
                        }
                        stmt.setNull(colIndex, 2004);
                        continue;
                    }
                    if (destCol.getType().indexOf("TIME") >= 0) {
                        value = srcResultset.getTimestamp(colIndex);
                        if (value != null) {
                            stmt.setTimestamp(colIndex, (Timestamp)value);
                            continue;
                        }
                        stmt.setNull(colIndex, 93);
                        continue;
                    }
                    value = srcResultset.getObject(colIndex);
                    if (value != null) {
                        stmt.setObject(colIndex, value);
                        continue;
                    }
                    log.error((Object)("unSupported null value insert into table\u3010" + destTable + "\u3011, column\u3010" + destCol.getName() + "\u3011, row\u3010" + curRowIndex + "\u3011\uff01"));
                }
                if (hasContainsLOB) {
                    try {
                        stmt.executeUpdate();
                    }
                    catch (SQLException e) {
                        log.error((Object)("an error occurred while do result insert\uff01 sqlcode\u3010" + e.getErrorCode() + "\u3011, sqlstat\u3010" + e.getSQLState() + "\u3011,sqlmessage\u3010" + e.getMessage() + "\u3011\uff1a" + e));
                    }
                    continue;
                }
                try {
                    stmt.addBatch();
                    if (++batchRowSize != 100) continue;
                    stmt.executeBatch();
                    batchRowSize = 0;
                }
                catch (SQLException e) {
                    log.error((Object)("an error occurred while do result insert\uff01 sqlcode\u3010" + e.getErrorCode() + "\u3011, sqlstat\u3010" + e.getSQLState() + "\u3011,sqlmessage\u3010" + e.getMessage() + "\u3011\uff1a" + e));
                }
            }
            try {
                if (batchRowSize > 0) {
                    stmt.executeBatch();
                    batchRowSize = 0;
                }
            }
            catch (SQLException e) {
                log.error((Object)("an error occurred while do result insert\uff01 sqlcode\u3010" + e.getErrorCode() + "\u3011, sqlstat\u3010" + e.getSQLState() + "\u3011,sqlmessage\u3010" + e.getMessage() + "\u3011\uff1a" + e));
            }
        }
        catch (Throwable throwable) {
            DBCenterUtil.closeStatement(stmt);
            throw throwable;
        }
        DBCenterUtil.closeStatement((Statement)stmt);
    }
}

