/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bi.model.ui.dialog.general.importscheme;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bi.model.common.mm.general.db.Column;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeModel;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SchemeUtil;
import com.kingdee.bos.bi.model.common.mm.general.importscheme.SubSystemUtil;
import com.kingdee.bos.bi.model.common.mm.progressbar.ILoader;
import com.kingdee.bos.bi.model.common.mm.progressbar.ProgressBarThread;
import com.kingdee.bos.bi.model.service.IManagementFacade;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.AbstractImportWizardStep;
import com.kingdee.bos.bi.model.ui.dialog.general.importscheme.Step3_Mapping;
import com.kingdee.bos.bi.model.util.StringUtil;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Step2_1_MetaDataTree
extends AbstractImportWizardStep
implements ILoader {
    protected KDPanel panMain;
    protected KDTree treeMain;
    protected KDTreeView treeView;
    protected AbstractImportWizardStep step3 = null;
    private boolean readOnly = false;
    private static final String PROMPT_TEXT = "\u9009\u62e9\u6570\u636e\u6765\u6e90\u7684\u5143\u6570\u636e\u3002\u5fc5\u987b\u9009\u62e9\u7684\u662f\u6811\u7684\u53f6\u5b50\u8282\u70b9\uff0c\u76ee\u5f55\u8282\u70b9\u4e0d\u542b\u5143\u6570\u636e\u4fe1\u606f\u3002";

    public Step2_1_MetaDataTree(IManagementFacade facade, Component owner) {
        super(facade, owner);
    }

    @Override
    protected String getPromptText() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        String name = model.getMetaDataFullName();
        return PROMPT_TEXT + (StringUtil.isEmpty(name) ? "" : " \u5f53\u524d\u9009\u4e2d\u5143\u6570\u636e\u8def\u5f84\uff1a   " + name.replaceFirst("com.kingdee.", ""));
    }

    @Override
    public Component getPanMain() {
        if (this.panMain == null) {
            this.panMain = new KDPanel();
            this.setPanMainLayout();
            this.addPanMainComponent();
        }
        return this.panMain;
    }

    protected Component getProgressBar() {
        KDLabel label = new KDLabel("          BOS\u5143\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026");
        KDProgressBar progressBar = new KDProgressBar();
        progressBar.setIndeterminate(true);
        TableLayout tly = TableLayout.splitRow((int)4);
        tly.rowStyle(0).setPriY(1);
        tly.rowStyle(1).setHeight(30);
        tly.rowStyle(2).setHeight(20);
        tly.rowStyle(3).setPriY(1);
        KDPanel container = new KDPanel((LayoutManager)tly);
        container.add((Component)label, (Object)tly.cell(1));
        container.add((Component)progressBar, (Object)tly.cell(2));
        ProgressBarThread tempThread = new ProgressBarThread((Container)container, progressBar, label, this);
        tempThread.start();
        return container;
    }

    private void setPanMainLayout() {
        TableLayout2 tly = new TableLayout2(1, 1);
        tly.setRatableHeight(TableLayout2.ALL, 100);
        tly.setRatableWidth(TableLayout2.ALL, 100);
        this.panMain.setLayout((LayoutManager)tly);
    }

    private void addPanMainComponent() {
        this.panMain.add(this.getProgressBar(), (Object)TableLayout2.param((int)0, (int)0));
    }

    protected KDTreeView getTreeView() {
        if (this.treeView == null) {
            this.treeView = new KDTreeView(this.getTreeMain());
            this.treeView.setEnabled(!this.readOnly);
        }
        return this.treeView;
    }

    private KDTree getTreeMain() {
        if (this.treeMain == null) {
            this.treeMain = new KDTree();
            this.treeMain.setEditable(!this.readOnly);
            this.doLoad();
        }
        return this.treeMain;
    }

    @Override
    protected void loadModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
    }

    @Override
    protected boolean injectModel() {
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        Context ctx = this.facade.getContext();
        MetaDataPK pk = null;
        String pkFullName = null;
        TreePath pathSelected = this.treeMain.getSelectionPath();
        if (pathSelected != null) {
            DefaultKingdeeTreeNode nodeSelected = (DefaultKingdeeTreeNode)pathSelected.getLastPathComponent();
            MetaDataBriefInfo object = (MetaDataBriefInfo)nodeSelected.getUserObject();
            pk = object.getMetaDataPK();
            pkFullName = pk.getFullName();
        } else {
            pkFullName = model.getMetaDataFullName();
            pk = new MetaDataPK(pkFullName);
        }
        List srcColumnList = new Vector();
        if ("entity".equalsIgnoreCase(model.getType())) {
            EntityObjectInfo entityObjectInfo = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)pk);
            DataTableInfo dataTableInfo = entityObjectInfo.getTable();
            PropertyCollection propertyCollection = SchemeUtil.getEntityPropertyCollection(entityObjectInfo);
            try {
                srcColumnList = SchemeUtil.getSrcColumnListFromEntity(this.facade, pkFullName);
            }
            catch (BOSException e) {
                WindowUtil.msgboxInfo((Object)e.getMessage(), (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
                log.error((Object)e);
                return false;
            }
            catch (SQLException e) {
                WindowUtil.msgboxInfo((Object)e.getMessage(), (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
                log.error((Object)e);
                return false;
            }
        } else if ("query".equalsIgnoreCase(model.getType())) {
            QueryInfo queryInfo = MetaDataLoader.getQuery((Context)ctx, (IMetaDataPK)pk);
            PropertyUnitCollection collection = queryInfo.getUnits();
            try {
                srcColumnList = SchemeUtil.getSrcColumnListFromQuery(this.facade, pkFullName);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else if ("table".equalsIgnoreCase(model.getType())) {
            DataTableInfo dataTableInfo = MetaDataLoader.getDataTable((Context)ctx, (IMetaDataPK)pk);
            this.handelDataTable(dataTableInfo, srcColumnList);
        }
        model.setSrcColumnList(srcColumnList);
        model.setMetaDataFulName(pkFullName);
        return true;
    }

    void handelDataTable(DataTableInfo dataTableInfo, List srcColumnList) {
        ColumnCollection collection = dataTableInfo.getColumns();
        ColumnInfo columnInfo = null;
        Column srcColumn = null;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            srcColumn = new Column();
            columnInfo = (ColumnInfo)it.next();
            srcColumn.setName(columnInfo.getName());
            srcColumn.setCaption(columnInfo.getAlias());
            srcColumn.setType(columnInfo.getTypeName().getName());
            srcColumn.setLength(columnInfo.getLength());
            srcColumnList.add(srcColumn);
        }
    }

    @Override
    protected boolean checkBeforeInject() {
        TreePath pathSelected = this.treeMain.getSelectionPath();
        if (pathSelected == null) {
            SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
            if (StringUtil.isEmpty(model.getMetaDataFullName())) {
                WindowUtil.msgboxInfo((Object)"\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u5143\u6570\u636e\u3002\r\n", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
                return false;
            }
        } else {
            DefaultKingdeeTreeNode nodeSelected = (DefaultKingdeeTreeNode)pathSelected.getLastPathComponent();
            if (nodeSelected == null || nodeSelected.getChildCount() > 0) {
                WindowUtil.msgboxInfo((Object)"\u5f53\u524d\u9009\u62e9\u7684\u662f\u76ee\u5f55\uff0c\u5fc5\u987b\u9009\u62e9\u4e00\u4e2a\u5143\u6570\u636e\u3002\r\n", (String)"\u63d0\u793a\u4fe1\u606f", (Component)this.getOwner());
                return false;
            }
        }
        return true;
    }

    @Override
    protected AbstractImportWizardStep getNextStep() {
        if (this.step3 == null) {
            this.step3 = new Step3_Mapping(this.facade, this.getOwner());
        }
        return this.step3;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (readOnly) {
            // empty if block
        }
    }

    @Override
    public Component load() {
        return this.getTreeView();
    }

    protected void doLoad() {
        DefaultKingdeeTreeNode selectedNode;
        SchemeModel model = (SchemeModel)this.stepsManager.getUserObject();
        DefaultKingdeeTreeNode root = SubSystemUtil.getMetaDataTreeRootNode(model.getType());
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        this.treeMain.setModel((TreeModel)treeModel);
        String selectMetaDataName = model.getMetaDataFullName();
        if (!StringUtil.isEmpty(selectMetaDataName) && (selectedNode = this.findSelectedNode(root, selectMetaDataName)) != null) {
            TreePath path = new TreePath(((DefaultKingdeeTreeNode)selectedNode.getParent()).getPath());
            this.treeMain.expandPath(path);
            this.treeMain.setSelectionNode(selectedNode);
        }
    }

    private DefaultKingdeeTreeNode findSelectedNode(DefaultKingdeeTreeNode parent, String metaDataFullName) {
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parent.getChildAt(i);
            MetaDataBriefInfo object = (MetaDataBriefInfo)childNode.getUserObject();
            String tempName = object.getMetaDataPK().getFullName();
            if (StringUtil.equalsIgnoreCase(metaDataFullName, tempName)) {
                return childNode;
            }
            DefaultKingdeeTreeNode selected = this.findSelectedNode(childNode, metaDataFullName);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }
}

