/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app.workflow;

import com.kingdee.bos.Context;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.wfdesigner.service.IDCService;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCRegister;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DCService
extends ORMObject
implements IDCService {
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.framework.app.workflow.DCService");

    public DCService() {
        super.registerInterface(IDCService.class, (Object)this);
    }

    public DCService(Context ctx) {
        super.registerInterface(IDCService.class, (Object)this);
    }

    public List getDataCenters() throws WfException {
        DCRegister dCRegister = new DCRegister();
        ArrayList listRet = null;
        try {
            listRet = dCRegister.getDCList();
        }
        catch (Exception e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new WfException((Throwable)e);
        }
        return listRet;
    }

    public String getDataCenterNameByAlias(String alias, String localStr) throws WfException {
        String account = "";
        List list = this.getDataCenters();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DCInfo value = (DCInfo)list.get(i);
            String bm2 = value.getName(localStr);
            if (!alias.equals(bm2)) continue;
            account = value.getNumber();
            break;
        }
        return account;
    }

    public String[] getDataCenterAliases(String localeStr) throws WfException {
        List list = this.getDataCenters();
        String[] aliases = null;
        aliases = list == null || list.size() == 0 ? new String[]{} : new String[list.size()];
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                DCInfo info = (DCInfo)list.get(i);
                aliases[i] = info.getName(localeStr);
            }
        }
        return aliases;
    }

    public String getSolutionNameByDataCenter(String dcName) throws WfException {
        List list = this.getDataCenters();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            DCInfo info = (DCInfo)list.get(i);
            if (!info.getNumber().equalsIgnoreCase(dcName)) continue;
            return info.getSolutionName();
        }
        return "";
    }

    public boolean isDCLegal(String dcNumber) throws WfException {
        boolean isLegal = false;
        List dcs = this.getDataCenters();
        int n = dcs.size();
        for (int i = 0; i < n; ++i) {
            DCInfo dcInfo = (DCInfo)dcs.get(i);
            if (!dcInfo.getNumber().equals(dcNumber)) continue;
            isLegal = true;
            break;
        }
        return isLegal;
    }
}

