/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.cache;

import com.kingdee.bos.cache.CacheLoader;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.framework.cache.CacheService;
import com.kingdee.eas.framework.cache.ICacheable;
import com.kingdee.eas.framework.cache.IDataPK;
import com.kingdee.eas.framework.cache.LoadArguments;
import com.kingdee.eas.framework.cache.OqlPK;

public abstract class BaseCacheObject
implements ICacheable {
    protected IMetaDataPK metaPK;
    protected IDataPK dataPK;
    protected ObjectAttributes oattr;

    public BaseCacheObject(IMetaDataPK metaPK, IDataPK dataPK) {
        this.metaPK = metaPK;
        this.dataPK = dataPK;
    }

    public BaseCacheObject(IMetaDataPK metaPK) {
        this(metaPK, new OqlPK());
    }

    @Override
    public IMetaDataPK getMetaDataPK() {
        return this.metaPK;
    }

    @Override
    public IDataPK getDataPK() {
        return this.dataPK;
    }

    @Override
    public String getName() {
        return this.metaPK.getName();
    }

    protected String getPackage() {
        return this.metaPK.getPackage();
    }

    @Override
    public Object getData() {
        return CacheService.getCacheObject(this.metaPK, this.dataPK);
    }

    @Override
    public ObjectAttributes getAttrbuites() {
        if (this.oattr != null) {
            return this.oattr;
        }
        this.oattr = CacheService.createObjectAttributes();
        this.oattr.setLoader(this.getLoader());
        this.oattr.setLoadArguments(this.getArgs());
        return this.oattr;
    }

    private Object getArgs() {
        return new LoadArguments(this.metaPK, this.dataPK);
    }

    protected abstract String getSuffix();

    protected abstract CacheLoader getLoader();
}

