/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.query.component;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.framework.query.component.AbstractListPopupItem;
import com.kingdee.eas.framework.query.component.IJSONStringSupport;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.query.component.IListPopupItemExecute;
import com.kingdee.eas.framework.query.component.ListPopupItem;
import com.kingdee.eas.framework.query.resource.QuickFilterResources;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CompositeListPopupItem
extends AbstractListPopupItem
implements Cloneable,
IJSONStringSupport {
    private static final Logger logger = Logger.getLogger(CompositeListPopupItem.class);
    private List<IListPopupItem> items = new ArrayList<IListPopupItem>(3);
    private LinkType linkType = LinkType.AND;

    public CompositeListPopupItem(IListPopupItemExecute executor) {
        super(executor);
    }

    public CompositeListPopupItem(IListPopupItemExecute executor, String displayCompareValue, LinkType linkType) {
        super(executor, displayCompareValue);
        this.linkType = linkType;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public List<IListPopupItem> getListPopupItems() {
        return this.items;
    }

    public void addListPopupItem(IListPopupItem item) {
        this.items.add(item);
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isTitle() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isOrLinkType()) {
            this.toStringWithOr(sb);
        } else {
            this.toStringWithAnd(sb);
        }
        return sb.toString();
    }

    private void toStringWithOr(StringBuilder sb) {
        sb.append("\u3010").append(this.getFieldAlias()).append("\u3011");
        sb.append(CompareSignEnum.LIKESIGN.getAlias());
        sb.append(" \"").append(this.getDisplayValue()).append("\"");
    }

    private void toStringWithAnd(StringBuilder sb) {
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            IListPopupItem item = this.items.get(i);
            if (item == null) continue;
            if (i > 0) {
                sb.append(" ").append(this.linkType.alias).append(" ");
            }
            sb.append(item.toString());
        }
    }

    @Override
    public String toJSONString() {
        JSONObject jo = new JSONObject();
        try {
            JSONArray ja = new JSONArray();
            for (IListPopupItem item : this.items) {
                ja.put((Object)new JSONObject(((IJSONStringSupport)((Object)item)).toJSONString()));
            }
            jo.put("items", (Object)ja);
            jo.put("linkType", (Object)this.linkType.name());
            if (!StringUtils.isEmpty((String)this.getDisplayValue())) {
                jo.put("displayCompareValue", (Object)this.getDisplayValue());
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String jaString = jo.toString();
        return jaString;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        CompositeListPopupItem citem = (CompositeListPopupItem)super.clone();
        citem.items = new ArrayList<IListPopupItem>(this.items.size());
        for (IListPopupItem item : this.items) {
            citem.items.add((IListPopupItem)((AbstractListPopupItem)item).clone());
        }
        return citem;
    }

    @Override
    public FilterInfo getFilterInfo() {
        if (this.filterInfo == null) {
            this.initFilterInfo();
        }
        return this.filterInfo;
    }

    private void initFilterInfo() {
        this.filterInfo = new FilterInfo();
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            IListPopupItem item;
            if (i > 0) {
                sb.append(" ").append(this.linkType.name()).append(" ");
            }
            if ((item = this.items.get(i)) instanceof ListPopupItem) {
                this.filterInfo.getFilterItems().add(((ListPopupItem)item).getFilterItemInfo());
                sb.append("#").append(idx++);
                continue;
            }
            CompositeListPopupItem citem = (CompositeListPopupItem)item;
            FilterInfo filter = citem.getFilterInfo();
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append("(");
            for (int j = 0; j < filter.getFilterItems().size(); ++j) {
                if (j > 0) {
                    sb.append(" ").append(citem.linkType.name()).append(" ");
                }
                this.filterInfo.getFilterItems().add(filter.getFilterItems().get(j));
                sb.append("#").append(idx++);
            }
            sb.append(") ");
        }
        if (sb.length() > 0) {
            this.filterInfo.setMaskString(sb.toString());
        }
    }

    private boolean isOrLinkType() {
        return this.linkType.equals((Object)LinkType.OR);
    }

    public static CompositeListPopupItem valueOf(String joString, IListPopupItemExecute executor, MetaDataPK queryPK) {
        if (StringUtils.isEmpty((String)joString)) {
            return null;
        }
        CompositeListPopupItem citem = null;
        String displayCompareValue = null;
        try {
            JSONObject json = new JSONObject(joString);
            String linkTypeName = json.getString("linkType");
            if (!json.has("displayCompareValue")) {
                citem = new CompositeListPopupItem(executor);
            } else {
                displayCompareValue = json.getString("displayCompareValue");
                LinkType linkType = LinkType.valueOf(linkTypeName);
                citem = new CompositeListPopupItem(executor, displayCompareValue, linkType);
            }
            JSONArray ja = json.getJSONArray("items");
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                AbstractListPopupItem item = jo.has("linkType") ? CompositeListPopupItem.valueOf(jo.toString(), executor, queryPK) : ListPopupItem.valueOf(jo.toString(), executor, queryPK);
                if (item == null) continue;
                if (!StringUtils.isEmpty((String)displayCompareValue)) {
                    item.setCompareValue(displayCompareValue);
                }
                citem.addListPopupItem(item);
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (citem.items.size() == 0) {
            return null;
        }
        return citem;
    }

    @Override
    public void setCompareValue(Object compareValue) {
        super.setCompareValue(compareValue);
        if (this.isOrLinkType()) {
            this.initFilterInfo();
            for (FilterItemInfo filterItemInfo : this.filterInfo.getFilterItems()) {
                this.setFilterItemCompareValue(filterItemInfo, compareValue);
            }
            for (IListPopupItem item : this.items) {
                ((AbstractListPopupItem)item).setCompareValue(compareValue);
            }
        }
    }

    @Override
    public String getFieldAlias() {
        return QuickFilterResources.getMessage("ALL_ALIAS");
    }

    static enum LinkType {
        AND(QuickFilterResources.getMessage("LinkType.AND")),
        OR(QuickFilterResources.getMessage("LinkType.OR"));

        String alias;

        private LinkType(String alias) {
            this.alias = alias;
        }
    }
}

