/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.builder;

import com.kingdee.cbos.process.vm.builder.AbstractBuilder;
import com.kingdee.cbos.process.vm.builder.FlowBuilder;
import com.kingdee.cbos.process.vm.builder.VariableBuilder;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.GroupImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Event;
import com.kingdee.cbos.process.vm.model.Group;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.plugin.Listener;
import com.kingdee.cbos.process.vm.runtime.Execution;

public class GroupBuilder
extends AbstractBuilder<Group> {
    private FlowBuilder flowBuilder;
    private GroupImpl scope;

    GroupBuilder(FlowBuilder flowBuilder, String id, String title) {
        this.flowBuilder = flowBuilder;
        FlowImpl flow = flowBuilder.getFlow();
        this.scope = new GroupImpl(flow, id, title);
    }

    @Override
    FlowBuilder getFlowBuilder() {
        return this.flowBuilder;
    }

    @Override
    GroupImpl getProcessElement() {
        return this.scope;
    }

    public VariableBuilder<Group, GroupBuilder> variable(String id, String name, String title, DataType type, Object initValue) {
        return this.variable(id, name, title, type, initValue, false);
    }

    public VariableBuilder<Group, GroupBuilder> variable(String id, String name, String title, DataType type, Object initValue, boolean singleton) {
        VariableImpl var = this.scope.addVariable(id, title, name, type, initValue, singleton);
        return new VariableBuilder<Group, GroupBuilder>(this, var);
    }

    public GroupBuilder listener(Event<Node> e, Listener<Execution<Group>> listener) {
        this.scope.addListener(e, listener);
        return this;
    }

    public FlowBuilder endScope() {
        this.scope = null;
        FlowBuilder builder = this.flowBuilder;
        this.flowBuilder = null;
        return builder;
    }

    public void setAttribute(String name, Object value) {
        this.scope.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.scope.getAttribute(name);
    }
}

