/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.i.node.BreakWhenSatisfied;
import com.kingdee.cbos.process.vm.internal.m.FlowImpl;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.plugin.Condition;

public class DisableNode
extends Feature {
    public static final String NAME = "stop-transit-when";
    private Condition when;
    private String[] targetIds;
    private NodeImpl[] targets;

    public DisableNode(Condition when, String[] targets) {
        this.when = when;
        this.targetIds = targets;
    }

    public NodeImpl[] getTargets() {
        return (NodeImpl[])this.targets.clone();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"begin"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    @Override
    public void postHandle(NodeImpl node) {
        FlowImpl flow = node.getFlow();
        this.targets = new NodeImpl[this.targetIds.length];
        for (int i = 0; i < this.targetIds.length; ++i) {
            NodeImpl target = flow.getNode(this.targetIds[i]);
            if (target == node || target == null || target.getParent() != node.getParent()) {
                throw new RuntimeException("\u8282\u70b9(" + this.targetIds[i] + ")\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f(" + node + ")\u7684\u5144\u5f1f\u8282\u70b9\uff01");
            }
            this.targets[i] = target;
        }
        this.when.compile(node);
        node.insert(new BreakWhenSatisfied(this.when, NIS.DISABLE_WHEN_SATISFIED.getLabel()));
    }
}

