/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.f.advanced;

import com.kingdee.cbos.process.vm.internal.Feature;
import com.kingdee.cbos.process.vm.internal.i.NIS;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.VariableImpl;
import com.kingdee.cbos.process.vm.internal.t.a.MessageSchema;
import com.kingdee.cbos.process.vm.model.DataType;
import com.kingdee.cbos.process.vm.model.Node;
import com.kingdee.cbos.process.vm.model.Variable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MsgSender
extends Feature {
    public static final String NAME = "message-sender";
    private Map<VariableImpl<?>, VariableImpl<?>[]> senders;
    private Map<String, String[]> def = new HashMap<String, String[]>();
    private Node.Stage stage;

    public MsgSender(Map<String, String[]> def, Node.Stage stage) {
        this.def = def;
        this.stage = stage;
    }

    public Map<VariableImpl<?>, VariableImpl<?>[]> getSenders() {
        return this.senders;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getCategories() {
        return new String[]{"sender"};
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public void preHandle(NodeImpl node) {
    }

    @Override
    public void postHandle(NodeImpl node) {
        this.senders = Collections.unmodifiableMap(MsgSender.check(node, this.def));
        switch (this.stage) {
            case BEFORE_READY: {
                node.insert(NIS.SEND_MSG_BEFORE_READY);
                break;
            }
            case BEFORE_CHILDREN_STARTED: {
                node.insert(NIS.SEND_MSG_BEFORE_CHILDREN_STARTE);
                break;
            }
            case BEFORE_CLOSED: {
                node.insert(NIS.SEND_MSG_BEFORE_COMPLETED);
                break;
            }
            case BEFORE_TRANSFERRING: {
                node.insert(NIS.SEND_MSG_BEFORE_TRANSFERRING);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static Map<VariableImpl<?>, VariableImpl<?>[]> check(NodeImpl node, Map<String, String[]> def) {
        HashMap map = new HashMap(def.size() << 1);
        for (Map.Entry<String, String[]> entry : def.entrySet()) {
            Variable msg = node.retrieveVariable(entry.getKey());
            DataType dataType = ((VariableImpl)msg).getType();
            if (dataType.acceptMultiValue()) {
                dataType = dataType.getElementType();
            }
            if (!(dataType instanceof MessageSchema)) {
                throw new RuntimeException("\u53d8\u91cf(" + msg + ")\u4e0d\u662f\u6d88\u606f\u7c7b\u578b\uff0e");
            }
            MessageSchema frame = (MessageSchema)dataType;
            String[] assigns = entry.getValue();
            if (assigns.length != frame.fieldCount()) {
                throw new RuntimeException("\u6d88\u606f(" + msg + ")\u5b57\u6bb5\u6570\u4e0e\u8d4b\u503c\u53d8\u91cf\u4e2a\u6570\u4e0d\u76f8\u7b26\uff01");
            }
            VariableImpl[] from = new VariableImpl[assigns.length];
            for (int i = 0; i < from.length; ++i) {
                from[i] = node.retrieveVariable(assigns[i]);
            }
            map.put((VariableImpl<?>)msg, from);
        }
        return map;
    }
}

