/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.internal.i.node;

import com.kingdee.cbos.process.vm.internal.i.node.AbstractInstruction;
import com.kingdee.cbos.process.vm.internal.i.node.Utils;
import com.kingdee.cbos.process.vm.internal.m.NodeImpl;
import com.kingdee.cbos.process.vm.internal.m.TransitionImpl;
import com.kingdee.cbos.process.vm.internal.r.ExecutionImpl;
import com.kingdee.cbos.process.vm.plugin.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class ExclusiveChoice
extends AbstractInstruction {
    public ExclusiveChoice(int index) {
        super(index);
    }

    @Override
    public int invoke(ExecutionImpl<NodeImpl> e) throws Exception {
        TransitionImpl selected = null;
        if (((NodeImpl)e.getDefine()).getNormalExits().size() == 1) {
            selected = ((NodeImpl)e.getDefine()).getNormalExits().get(0);
        } else {
            ArrayList<TransitionImpl> trans = new ArrayList<TransitionImpl>();
            trans.addAll(((NodeImpl)e.getDefine()).getNormalExits());
            Collections.sort(trans, this.getComparator());
            for (TransitionImpl t : trans) {
                Condition c = t.getCondition();
                if (c == null) {
                    selected = t;
                    continue;
                }
                if (!c.test(e)) continue;
                selected = t;
                break;
            }
        }
        if (selected == null) {
            throw new RuntimeException("{" + e + "}\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u8f6c\u79fb\uff01");
        }
        Utils.transit(e, selected);
        return 1;
    }

    private Comparator<TransitionImpl> getComparator() {
        return new Comparator<TransitionImpl>(){

            private int getSort(TransitionImpl t) {
                if (t.getCondition() == null) {
                    return 5;
                }
                if (t.getCondition() == Condition.TRUE) {
                    return 4;
                }
                if (t.getCondition().getClass().getName().contains("DefaultErrorTransitCondition")) {
                    return 2;
                }
                if (t.getCondition().getClass().getName().contains("ErrorTransitCondition")) {
                    return 1;
                }
                return 3;
            }

            @Override
            public int compare(TransitionImpl o1, TransitionImpl o2) {
                return this.getSort(o1) - this.getSort(o2);
            }
        };
    }

    public String toString() {
        return "exclusive-choice";
    }
}

