/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.cache;

import com.kingdee.cbos.process.vm.utils.cache.DoubleLinkedNode;
import java.io.Serializable;

public final class DoubleLinkedList<D extends DoubleLinkedNode<D>>
implements Serializable {
    private static final long serialVersionUID = -4488666902618419188L;
    private D m_header;
    private int m_size;

    public DoubleLinkedList(D header) {
        this.init(header);
    }

    private void init(D header) {
        this.m_header = header;
        this.m_size = 0;
        ((DoubleLinkedNode)this.m_header).prior = this.m_header;
        ((DoubleLinkedNode)this.m_header).next = ((DoubleLinkedNode)this.m_header).prior;
    }

    public void clear() {
        ((DoubleLinkedNode)((DoubleLinkedNode)this.m_header).prior).next = null;
        Object p = ((DoubleLinkedNode)this.m_header).next;
        while (p != null) {
            Object q = ((DoubleLinkedNode)p).next;
            ((DoubleLinkedNode)p).next = null;
            ((DoubleLinkedNode)p).prior = null;
            p = q;
        }
        this.init(this.m_header);
    }

    public void push(D node) {
        this.insertBefore(node, this.m_header);
    }

    public void insertAtFirst(D node) {
        this.insertBefore(node, ((DoubleLinkedNode)this.m_header).next);
    }

    public void insertBefore(D node, D before) {
        ((DoubleLinkedNode)node).next = before;
        ((DoubleLinkedNode)node).prior = ((DoubleLinkedNode)before).prior;
        ((DoubleLinkedNode)((DoubleLinkedNode)before).prior).next = node;
        ((DoubleLinkedNode)before).prior = node;
        ++this.m_size;
    }

    public D poll() {
        if (this.m_size == 0) {
            return null;
        }
        return this.poll(((DoubleLinkedNode)this.m_header).next);
    }

    public D first() {
        if (this.m_size == 0) {
            return null;
        }
        return ((DoubleLinkedNode)this.m_header).next;
    }

    public D last() {
        if (this.m_size == 0) {
            return null;
        }
        return ((DoubleLinkedNode)this.m_header).prior;
    }

    public D poll(D node) {
        ((DoubleLinkedNode)((DoubleLinkedNode)node).next).prior = ((DoubleLinkedNode)node).prior;
        ((DoubleLinkedNode)((DoubleLinkedNode)node).prior).next = ((DoubleLinkedNode)node).next;
        ((DoubleLinkedNode)node).prior = null;
        ((DoubleLinkedNode)node).next = null;
        --this.m_size;
        return node;
    }

    public int size() {
        return this.m_size;
    }

    public static <E> DoubleLinkedList<Wrapper<E>> newInstance() {
        return new DoubleLinkedList<Wrapper<E>>(new Wrapper<Object>(null));
    }

    public static final class Wrapper<E>
    extends DoubleLinkedNode<Wrapper<E>> {
        private static final long serialVersionUID = 7168183323685088223L;
        private E obj;

        public Wrapper(E obj) {
            this.obj = obj;
        }

        public E get() {
            return this.obj;
        }
    }
}

