/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cbos.process.vm.utils.graph;

import com.kingdee.cbos.process.vm.utils.JsonUtil;
import com.kingdee.cbos.process.vm.utils.graph.Activity;
import com.kingdee.cbos.process.vm.utils.graph.Block;
import com.kingdee.cbos.process.vm.utils.graph.Node;
import com.kingdee.cbos.process.vm.utils.graph.Type;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Diagram {
    private static final String ROOT_ID = "_ROOT_";
    private Map<String, Block> blocks;
    private Map<String, String> group2parent;
    private Block root;
    private int vInterval = 15;
    private int hInterval = 10;

    public Diagram(Activity[] activities) {
        this.blocks = new HashMap<String, Block>(activities.length * 2);
        this.group2parent = new HashMap<String, String>();
        this.createBlocks(activities);
        this.attachGroup2Parent();
        this.scan(this.root);
        this.root.getType().layout(this.root, this.hInterval);
        this.root.getType().locate(this.root, this.hInterval, this.vInterval);
        this.adjustPriors();
    }

    private void adjustPriors() {
        for (Block block : this.blocks.values()) {
            List<Block> priors;
            if (block.getType() == Type.Group || (priors = block.getPriors()) == null) continue;
            this.adjectPriors(block, priors);
        }
    }

    private void adjectPriors(Block block, List<?> priors) {
        for (Object o : priors.toArray()) {
            Block bak;
            LinkedList<Block> children;
            Block prior = (Block)o;
            if (block.getParent() == prior || (children = prior.getChildren()) == null) continue;
            prior.removeNext(block);
            block.removePrior(prior);
            while ((children = (bak = children.getLast()).getChildren()) != null) {
            }
            bak.addNext(block);
            block.addPrior(bak);
        }
    }

    void addBlock(Block join) {
        this.blocks.put(join.getId(), join);
    }

    private void scan(Block block) {
        if (!this.blocks.containsKey(block.getId())) {
            throw new IllegalArgumentException("\u6807\u8bc6\u4e3a{" + block.getId() + "}\u7684\u6d3b\u52a8\u6216\u7ec4\u5904\u5728\u4e00\u4e2a\u73af\u4e0a\u3002");
        }
        this.blocks.remove(block.getId());
        LinkedList<Block> children = block.getChildren();
        if (children != null) {
            for (Block child : children) {
                this.scan(child);
            }
        }
        this.blocks.put(block.getId(), block);
    }

    Block get(String id) {
        return this.blocks.get(id);
    }

    public Node getStart() {
        return this.root;
    }

    public String toJson() {
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(this.blocks.size());
        ArrayList<Map<String, String>> links = new ArrayList<Map<String, String>>(this.blocks.size() * 2);
        for (Block block : this.blocks.values()) {
            this.dumpNode(nodes, block);
            this.dumpLinks(links, block);
        }
        HashMap<String, Serializable> graph = new HashMap<String, Serializable>();
        graph.put("width", Integer.valueOf(this.root.getWidth() + this.hInterval * 2));
        graph.put("height", Integer.valueOf(this.root.getHeight() + this.vInterval));
        graph.put("nodes", nodes);
        graph.put("links", links);
        return JsonUtil.toString(graph);
    }

    private void dumpLinks(ArrayList<Map<String, String>> links, Block block) {
        List<Block> priors = block.getPriors();
        if (priors != null) {
            if (priors.size() == 1) {
                Block from = priors.get(0);
                this.addLink(links, block, from);
            } else {
                boolean h = this.isH(priors);
                if (h) {
                    this.addLinks(links, block, priors);
                } else {
                    this.addLinks2(links, block, priors);
                }
            }
        }
    }

    private void addLinks2(ArrayList<Map<String, String>> links, Block block, List<Block> priors) {
        int left = block.getX() - 10;
        int right = block.getX() + block.getType().getWidth(block) + 10;
        for (Block from : priors) {
            Map<String, String> link = this.addLink(links, block, from);
            this.calcPath(left, right, from, link);
        }
    }

    private void addLinks(ArrayList<Map<String, String>> links, Block block, List<Block> priors) {
        for (Block from : priors) {
            this.addLink(links, block, from);
        }
    }

    private boolean isH(List<Block> priors) {
        int top = priors.get(0).getY();
        Type type = priors.get(0).getType();
        boolean h = true;
        for (Block prior : priors) {
            if (prior.getY() == top && prior.getType() == type) continue;
            h = false;
            break;
        }
        return h;
    }

    private void calcPath(int left, int right, Block from, Map<String, String> link) {
        int center = from.getX() + from.getType().getWidth(from) / 2;
        if (center < left) {
            link.put("path", "bottom:0|left:0");
        } else if (center > right) {
            link.put("path", "bottom:0|right:0");
        }
    }

    private Map<String, String> addLink(ArrayList<Map<String, String>> links, Block block, Block from) {
        HashMap<String, String> link = new HashMap<String, String>();
        link.put("from", from.getId());
        link.put("to", block.getId());
        links.add(link);
        return link;
    }

    private void dumpNode(ArrayList<Map<String, Object>> nodes, Block block) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        Activity act = block.getActivity();
        if (act != null) {
            act.store(node);
        }
        node.put("id", block.getId());
        Type type = block.getType();
        node.put("type", type.name());
        node.put("title", type.getTitle(block));
        node.put("x", block.getX());
        node.put("y", block.getY());
        node.put("width", block.getType().getWidth(block));
        node.put("height", block.getType().getHeight(block));
        nodes.add(node);
    }

    public Node[] getNodes() {
        return this.blocks.values().toArray(new Node[0]);
    }

    private void attachGroup2Parent() {
        for (Map.Entry<String, String> entry : this.group2parent.entrySet()) {
            String groupId = entry.getKey();
            Block group = this.blocks.get(groupId);
            if (group == this.root) continue;
            String parentId = entry.getValue();
            Block parent = this.blocks.get(parentId);
            parent.addChild(group);
        }
    }

    private void createBlocks(Activity[] activities) {
        for (Activity activity : activities) {
            Block group = this.createGroup(activity);
            this.createActivity(activity, group);
        }
    }

    private void createActivity(Activity activity, Block group) {
        String id = activity.getId();
        if (this.blocks.containsKey(id)) {
            throw new IllegalArgumentException("\u6d3b\u52a8\u4e2d\u5b58\u5728\u91cd\u590d{" + id + "}\u3002");
        }
        Block act = new Block(this, activity);
        this.blocks.put(id, act);
        group.addChild(act);
    }

    private Block createGroup(Activity activity) {
        Block group;
        String parent;
        String groupId = activity.getGroup();
        if (groupId == null) {
            groupId = ROOT_ID;
        }
        if ((parent = activity.getParentId()) == null) {
            parent = ROOT_ID;
        }
        if ((group = this.blocks.get(groupId)) == null) {
            group = new Block(this, groupId);
            this.blocks.put(groupId, group);
            this.group2parent.put(groupId, parent);
            if (groupId.equals(ROOT_ID)) {
                this.root = group;
            }
        } else {
            if (group.getType() != Type.Group) {
                throw new IllegalArgumentException("\u6d3b\u52a8\u4e0e\u7ec4\u5b58\u5728\u91cd\u590d{" + groupId + "}\u3002");
            }
            if (!this.group2parent.get(groupId).equals(parent)) {
                throw new IllegalArgumentException("\u4e0d\u540c\u6d3b\u52a8\u5305\u542b\u6709\u76f8\u540c\u6807\u8bc6\u7684\u7ec4{" + groupId + "}\u3002");
            }
        }
        return group;
    }
}

