/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.longer;

import com.kingdee.bos.qing.core.charttype.longer.AbstractChartTypeCoupler;
import com.kingdee.bos.qing.core.flattening.longer.AbstractFlatBuilder;
import com.kingdee.bos.qing.core.flattening.longer.FlatBuilderForMultiLine;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.longer.AnalyticalModel;
import com.kingdee.bos.qing.core.model.analysis.longer.MarkFieldSet;
import com.kingdee.bos.qing.core.model.analysis.longer.ModelAssistantStructure;
import java.util.ArrayList;

class MultiLine
extends AbstractChartTypeCoupler {
    MultiLine() {
    }

    @Override
    public ModelAssistantStructure parseAssistantStructure(AnalyticalModel model) {
        ArrayList<AnalyticalField> measureFields = new ArrayList<AnalyticalField>();
        ArrayList<AnalyticalField> rowDimensionFields = new ArrayList<AnalyticalField>();
        this.parseFields(model.getRow(), rowDimensionFields, measureFields);
        ArrayList<AnalyticalField> columnDimensionFields = new ArrayList<AnalyticalField>();
        this.parseFields(model.getColumn(), columnDimensionFields, null);
        ArrayList<AnalyticalField> cellDimensionFields = new ArrayList<AnalyticalField>();
        MarkFieldSet markFieldSet = model.getMarkFieldSet();
        MultiLine.makeSureMarkTypeAppointed(markFieldSet, "color", "dimension");
        if (markFieldSet.getMarkTypes().contains("color")) {
            int firstColorMarkIndex = markFieldSet.getMarkTypes().indexOf("color");
            cellDimensionFields.add(markFieldSet.getFields().get(firstColorMarkIndex));
        }
        if (!cellDimensionFields.isEmpty()) {
            MultiLine.makeSureOnlyOneMeasure(measureFields);
        }
        if (columnDimensionFields.size() > 0) {
            AnalyticalField last = columnDimensionFields.remove(columnDimensionFields.size() - 1);
            cellDimensionFields.add(0, last);
            MultiLine.makeDateFieldContinuous(last);
        }
        ModelAssistantStructure mas = new ModelAssistantStructure();
        mas.setRowDimensionFields(rowDimensionFields);
        mas.setColumnDimensionFields(columnDimensionFields);
        mas.setCellDimensionFields(cellDimensionFields);
        mas.setMeasureFields(measureFields);
        mas.setMeasureFieldCountForCell(measureFields.size());
        mas.setMeasureFieldCountForXYAxis(0, measureFields.size());
        mas.setAxisMeasureAtRowAndColumn(true, false);
        return mas;
    }

    @Override
    public AbstractFlatBuilder createFlatBuilder() {
        return new FlatBuilderForMultiLine();
    }
}

