/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.square;

import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.analysis.square.AbstractChart;
import com.kingdee.bos.qing.core.model.analysis.square.FieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.FilterItem;
import com.kingdee.bos.qing.core.model.analysis.square.RollFieldSet;
import com.kingdee.bos.qing.core.model.analysis.square.SquareModel;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractChartPreprocessor {
    public Middle preprocess(SquareModel model, II18nContext i18nCtx) {
        ArrayList<String> lostMetaFields = new ArrayList<String>();
        ArrayList<String> invalidMetaFields = new ArrayList<String>();
        model.searchMissingMetaFields(lostMetaFields, invalidMetaFields);
        SquareModel modelTwin = model.copy();
        Middle middle = new Middle(modelTwin);
        middle.setMissingMetaFields(lostMetaFields, invalidMetaFields);
        AbstractChart chartModel = modelTwin.getChartModel();
        this.preprocessChart(chartModel);
        if (this.isRollInSupported(chartModel)) {
            List<FilterItem> filters = modelTwin.getFilters();
            RollFieldSet rollFieldSet = chartModel.getRoll();
            if (rollFieldSet != null && rollFieldSet.getStateItemCount() > 0) {
                this.preprocessDrillDown(chartModel, filters, middle, i18nCtx);
            } else {
                FieldSet beRolledFieldSet = this.getBeRolledFieldSet(chartModel);
                if (beRolledFieldSet != null && beRolledFieldSet.getFieldCount() > 0) {
                    AnalyticalField field = beRolledFieldSet.getField(0);
                    this.makePcdAsRoot(field, filters);
                }
            }
        }
        this.preprocessChart(chartModel, middle);
        return middle;
    }

    private void makePcdAsRoot(AnalyticalField currentDimensionField, List<FilterItem> filters) {
        if (currentDimensionField.isParentChildDimension()) {
            List<String> selecteds = Arrays.asList(new String[]{null});
            filters.add(this.makeTreeFilter(currentDimensionField, selecteds));
        }
    }

    private void preprocessDrillDown(AbstractChart chart, List<FilterItem> filters, Middle middle, II18nContext i18nCtx) {
        AnalyticalField insteadField = null;
        boolean insteadFieldNeedInit = true;
        ArrayList<AnalyticalField> drillDownPathFields = new ArrayList<AnalyticalField>();
        RollFieldSet rollFieldSet = chart.getRoll();
        int c = rollFieldSet.getStateItemCount();
        for (int i = 0; i < c; ++i) {
            RollFieldSet.RollInStateItem stateItem = rollFieldSet.getStateItem(i);
            AnalyticalField targetField = this.getDrillDownTargetField(i, chart);
            if (stateItem.isPcdNextLevel() && targetField.isParentChildDimension()) {
                insteadFieldNeedInit = false;
                List<String> ids = stateItem.getParsedValue(targetField, i18nCtx);
                filters.add(this.makeTreeFilter(targetField, ids));
                continue;
            }
            if (i >= rollFieldSet.getFieldCount()) continue;
            insteadField = rollFieldSet.getField(i);
            if (!insteadField.isDimension()) {
                insteadField = null;
                break;
            }
            if (targetField == null) continue;
            filters.add(this.makePlaneFilter(targetField, stateItem, i18nCtx));
            drillDownPathFields.add(0, targetField);
        }
        if (insteadField != null) {
            if (insteadFieldNeedInit) {
                this.makePcdAsRoot(insteadField, filters);
            }
            List<AnalyticalField> fields = this.createBeRolledFieldSetFields(insteadField, drillDownPathFields, chart);
            this.getBeRolledFieldSet(chart).updateFields(fields);
        }
    }

    protected List<AnalyticalField> createBeRolledFieldSetFields(AnalyticalField insteadField, List<AnalyticalField> drillDownPathFields, AbstractChart chart) {
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        fields.add(insteadField);
        return fields;
    }

    protected static boolean checkContainsCubeInterlineCalculation(FieldSet fieldSet) {
        for (int i = 0; i < fieldSet.getFieldCount(); ++i) {
            AnalyticalField field = fieldSet.getField(i);
            if (!field.getMetaField().isCubeInterlineCalculation()) continue;
            return true;
        }
        return false;
    }

    private AnalyticalField getDrillDownTargetField(int idx, AbstractChart chart) {
        FieldSet beRolledFieldSet;
        Object targetField = idx == 0 ? ((beRolledFieldSet = this.getBeRolledFieldSet(chart)).getFieldCount() == 0 ? null : beRolledFieldSet.getField(0)) : chart.getRoll().getField(idx - 1);
        return targetField;
    }

    private FilterItem makePlaneFilter(AnalyticalField targetField, RollFieldSet.RollInStateItem stateItem, II18nContext i18nCtx) {
        DiscreteFilter filter = new DiscreteFilter();
        filter.setSelecteds(stateItem.getParsedValue(targetField, i18nCtx));
        if (DataType.DATE != targetField.getDataType()) {
            targetField = targetField.copy();
            targetField.setNumberFormat("");
        }
        FilterItem filterItem = new FilterItem();
        filterItem.setField(targetField);
        filterItem.setFilter(filter);
        return filterItem;
    }

    private FilterItem makeTreeFilter(AnalyticalField pcdTargetField, List<String> ids) {
        MetaField mf = pcdTargetField.getParentChildDimensionParentIdField();
        AnalyticalField parentIdField = new AnalyticalField();
        parentIdField.bindMetaField(mf);
        parentIdField.setName(mf.getFullName());
        parentIdField.setRole("dimension");
        DiscreteFilter filter = new DiscreteFilter();
        filter.setSelecteds(ids);
        FilterItem filterItem = new FilterItem();
        filterItem.setField(parentIdField);
        filterItem.setFilter(filter);
        return filterItem;
    }

    protected abstract FieldSet getBeRolledFieldSet(AbstractChart var1);

    private boolean isRollInSupported(AbstractChart chart) {
        return this.getBeRolledFieldSet(chart) != null;
    }

    protected abstract void preprocessChart(AbstractChart var1);

    protected void preprocessChart(AbstractChart chart, Middle middle) {
    }

    protected static void washDimension(FieldSet fieldSet, int limitedCount) {
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        AbstractChart.AbstractFieldVisitor visitor = AbstractChart.createDimensionSearcher(fields, limitedCount);
        visitor.visit(fieldSet);
        fieldSet.updateFields(fields);
    }

    protected static void washMeasure(FieldSet fieldSet, int limitedCount) {
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        AbstractChart.AbstractFieldVisitor visitor = AbstractChart.createMeasureSearcher(fields, limitedCount);
        visitor.visit(fieldSet);
        fieldSet.updateFields(fields);
    }

    protected static void washDimensionAndMeasure(FieldSet fieldSet, int limitedCount) {
        ArrayList<AnalyticalField> fields = new ArrayList<AnalyticalField>();
        AbstractChart.AbstractFieldVisitor visitor = AbstractChart.createDimensionOrMeasureSearcher(fields, limitedCount);
        visitor.visit(fieldSet);
        fieldSet.updateFields(fields);
    }

    protected static void dimensionToProperty(FieldSet fieldSet) {
        for (int i = 0; i < fieldSet.getFieldCount(); ++i) {
            AnalyticalField field = fieldSet.getField(i);
            if (!field.isDimension()) continue;
            field.setRole("measure");
            field.setAggregation(Aggregation.PROPERTIES);
        }
    }

    protected static final void makeDateFieldContinuous(AnalyticalField field) {
        if (field.isDimension() && field.getDataType() == DataType.DATE && field.getPartValue() != null) {
            field.setContinuous(true);
            field.getMetaField().setFiscalYearStart(0);
            switch (field.getPartValue()) {
                case DATE_QUARTER: {
                    field.setPartValue(PartValue.DATE_YQ);
                    break;
                }
                case DATE_MONTH: {
                    field.setPartValue(PartValue.DATE_YM);
                    break;
                }
                case DATE_DAY: {
                    field.setPartValue(PartValue.DATE_YMD);
                    break;
                }
            }
        }
    }

    public static class Middle {
        private SquareModel _squareModel;
        private List<String> _lostMetaFields = new ArrayList<String>();
        private List<String> _invalidMetaFields = new ArrayList<String>();
        private boolean _isGrandTotalRequest;

        public Middle(SquareModel model) {
            this._squareModel = model;
        }

        public SquareModel getSquareModel() {
            return this._squareModel;
        }

        public void setMissingMetaFields(List<String> lostMetaFields, List<String> invalidMetaFields) {
            this._lostMetaFields = lostMetaFields;
            this._invalidMetaFields = invalidMetaFields;
        }

        public List<String> getLostMetaFields() {
            return this._lostMetaFields;
        }

        public List<String> getInvalidMetaFields() {
            return this._invalidMetaFields;
        }

        public void requestGrandTotal() {
            this._isGrandTotalRequest = true;
        }

        public boolean isGrandTotalRequest() {
            return this._isGrandTotalRequest;
        }
    }
}

