/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.charttype.square;

import com.kingdee.bos.qing.core.charttype.square.AbstractChartPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.AreaPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.BarPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.ColumnPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.CompositePreprocessor;
import com.kingdee.bos.qing.core.charttype.square.CustomListPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.DialPreprecessor;
import com.kingdee.bos.qing.core.charttype.square.FunnelPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.GridPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.KpiPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.LinePreprocessor;
import com.kingdee.bos.qing.core.charttype.square.MapGisPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.MapPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.PercentAreaPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.PercentStackedBarPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.PercentStackedColumnPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.PiePreprocessor;
import com.kingdee.bos.qing.core.charttype.square.ProgressPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.RadarPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.RectTreePreprecessor;
import com.kingdee.bos.qing.core.charttype.square.ScatterPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.StackedBarPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.StackedColumnPreprocessor;
import com.kingdee.bos.qing.core.charttype.square.SunburstPreprecessor;
import com.kingdee.bos.qing.core.charttype.square.WaterfallPrecessor;
import com.kingdee.bos.qing.core.model.analysis.square.SquareChartType;
import java.util.HashMap;
import java.util.Map;

public class PreprocessorFactory {
    private static final Map<SquareChartType, AbstractChartPreprocessor> _map = new HashMap<SquareChartType, AbstractChartPreprocessor>();

    public static AbstractChartPreprocessor create(SquareChartType sct) {
        AbstractChartPreprocessor inst = _map.get((Object)sct);
        if (inst == null) {
            throw new RuntimeException("Unknown SquareChartType.");
        }
        return inst;
    }

    private PreprocessorFactory() {
    }

    static {
        _map.put(SquareChartType.Column, new ColumnPreprocessor());
        _map.put(SquareChartType.Bar, new BarPreprocessor());
        _map.put(SquareChartType.StackedColumn, new StackedColumnPreprocessor());
        _map.put(SquareChartType.PercentStackedColumn, new PercentStackedColumnPreprocessor());
        _map.put(SquareChartType.StackedBar, new StackedBarPreprocessor());
        _map.put(SquareChartType.PercentStackedBar, new PercentStackedBarPreprocessor());
        _map.put(SquareChartType.Line, new LinePreprocessor());
        _map.put(SquareChartType.Area, new AreaPreprocessor());
        _map.put(SquareChartType.PercentArea, new PercentAreaPreprocessor());
        _map.put(SquareChartType.Pie, new PiePreprocessor());
        _map.put(SquareChartType.Ring, new PiePreprocessor());
        _map.put(SquareChartType.Rose, new PiePreprocessor());
        _map.put(SquareChartType.KPI, new KpiPreprocessor());
        _map.put(SquareChartType.Map, new MapPreprocessor());
        _map.put(SquareChartType.GIS, new MapGisPreprocessor());
        _map.put(SquareChartType.Radar, new RadarPreprocessor());
        _map.put(SquareChartType.ProgressBar, new ProgressPreprocessor());
        _map.put(SquareChartType.ProgressColumn, new ProgressPreprocessor());
        _map.put(SquareChartType.ProgressCircle, new ProgressPreprocessor());
        _map.put(SquareChartType.Composite, new CompositePreprocessor());
        _map.put(SquareChartType.Grid, new GridPreprocessor());
        _map.put(SquareChartType.CustomList, new CustomListPreprocessor());
        _map.put(SquareChartType.Waterfall, new WaterfallPrecessor());
        _map.put(SquareChartType.Funnel, new FunnelPreprocessor());
        _map.put(SquareChartType.Scatter, new ScatterPreprocessor());
        _map.put(SquareChartType.Dial, new DialPreprecessor());
        _map.put(SquareChartType.RectTree, new RectTreePreprecessor());
        _map.put(SquareChartType.Sunburst, new SunburstPreprecessor());
    }
}

