/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.func.AbstractAggregationFunction;
import com.kingdee.bos.qing.core.engine.func.AbstractInterlineFunction;
import com.kingdee.bos.qing.core.engine.func.RunningSum;
import com.kingdee.bos.qing.core.exception.FormulaException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class CalculatingFieldAggregationSupporter {
    private Map<String, MetaField> _metaFields;
    private List<AnalyticalField> _dimensionFields;
    private List<AnalyticalField> _measureFields;
    private int _flowingNumber = 0;
    private List<Integer> _targetMeasureFieldsIndex = new ArrayList<Integer>();
    private List<Integer> _targetMeasureFieldsIndexForSubtotal = new ArrayList<Integer>();
    private FormulaExecuteContext _executeContext;
    private int _runningSumMinDateMeasureIdx = -1;

    CalculatingFieldAggregationSupporter() {
    }

    public static boolean isMyTarget(MetaField mf) {
        return mf.isValidCalculation() && (mf.getFormulaAggStatus() == MetaField.FormulaAggStatus.Agg || mf.getFormulaAggStatus() == MetaField.FormulaAggStatus.Interline);
    }

    public void setContext(II18nContext i18nCtx, Meta meta, List<AnalyticalField> measureFields, List<AnalyticalField> dimensionFields) {
        this._metaFields = meta.createSearchingMap();
        this._measureFields = measureFields;
        this._dimensionFields = dimensionFields;
        this._executeContext = new FormulaExecuteContext(this._metaFields);
        this._executeContext.setI18nContext(i18nCtx);
    }

    public void replaceAggregation(AnalyticalField field, int measureIndex) {
        MetaField mf = field.getMetaField();
        if (!CalculatingFieldAggregationSupporter.isMyTarget(mf)) {
            throw new RuntimeException("Field must be checked before.");
        }
        this.replaceAggregation(mf.getExpr(), mf.getMetaTable());
        this._targetMeasureFieldsIndex.add(measureIndex);
        if (field.getTotalUsing() == null) {
            this._targetMeasureFieldsIndexForSubtotal.add(measureIndex);
        }
    }

    private void replaceAggregation(IExpr root, MetaTable metaTable) {
        LinkedList<IExpr> queue = new LinkedList<IExpr>();
        queue.add(root);
        while (!queue.isEmpty()) {
            IExpr[] subs;
            String dateFieldFullName;
            IExpr node = (IExpr)queue.remove();
            if (node instanceof AbstractInterlineFunction && (dateFieldFullName = ((AbstractInterlineFunction)node).pretreat(this._dimensionFields)) != null && this._runningSumMinDateMeasureIdx < 0) {
                AnalyticalField field = this.createDateMinField(dateFieldFullName);
                this._runningSumMinDateMeasureIdx = this._measureFields.size();
                this._measureFields.add(field);
            }
            if (node instanceof RefExpr) {
                String metaFieldName = ((RefExpr)node).getName();
                MetaField mf = this._metaFields.get(metaFieldName);
                if (!mf.isCalculation()) continue;
                this.replaceAggregation(mf.getExpr(), metaTable);
                continue;
            }
            if (node instanceof AbstractAggregationFunction) {
                AbstractAggregationFunction aggExpr = (AbstractAggregationFunction)node;
                IExpr sub = aggExpr.getSubExpr();
                int existIdx = this.searchExistMeasure(aggExpr.getAggregation(), sub);
                if (existIdx < 0) {
                    AnalyticalField field = this.createReplacement(aggExpr.getAggregation(), sub, metaTable);
                    existIdx = this._measureFields.size();
                    this._measureFields.add(field);
                }
                aggExpr.setRuntimeReplacedMeasureIndex(existIdx);
                continue;
            }
            if (!(node instanceof AbstractOpExpr)) continue;
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                queue.add(sub);
            }
        }
    }

    private AnalyticalField createDateMinField(String metaFieldFullName) {
        MetaField mf = this._metaFields.get(metaFieldFullName);
        AnalyticalField field = new AnalyticalField();
        field.bindMetaField(mf);
        field.setName(metaFieldFullName);
        field.setAggregation(Aggregation.MIN);
        field.setRole("measure");
        return field;
    }

    private int searchExistMeasure(Aggregation aggregation, IExpr expr) {
        for (int i = 0; i < this._measureFields.size(); ++i) {
            MetaField mf;
            AnalyticalField field = this._measureFields.get(i);
            if (field.getAggregation() != aggregation || !(mf = field.getMetaField()).isValidCalculation() || !mf.getExpr().equals(expr)) continue;
            return i;
        }
        return -1;
    }

    private AnalyticalField createReplacement(Aggregation aggregation, IExpr expr, MetaTable metaTable) {
        String fieldPureName = this.createId();
        MetaField mf = new MetaField();
        mf.setMetaTable(metaTable);
        mf.setPureName(fieldPureName);
        mf.setFormula(expr.encode());
        mf.setDataType(Meta.confirmMetaFieldDataType(expr));
        mf.setExpr(expr);
        ArrayList<String> refQueue = new ArrayList<String>();
        refQueue.add(mf.getFullName());
        HashSet<String> dependence = new HashSet<String>();
        try {
            MetaField.FormulaAggStatus aggStatus = Meta.checkingWrapper(expr, this._metaFields, dependence, refQueue);
            mf.setFormulaAggStatus(aggStatus);
        }
        catch (FormulaException ex) {
            mf.setInvalid(true);
        }
        mf.setAllDependence(dependence);
        AnalyticalField field = new AnalyticalField();
        field.bindMetaField(mf);
        field.setName(mf.getFullName());
        field.setAggregation(aggregation);
        field.setRole("measure");
        return field;
    }

    private String createId() {
        ++this._flowingNumber;
        return "qing_aggregation_inner_" + this._flowingNumber;
    }

    public void struggle(Cuboid mainCuboid) {
        if (this._runningSumMinDateMeasureIdx < 0) {
            return;
        }
        Aggregator.Min minAgg = new Aggregator.Min();
        Iterator<CompositeKey> it = mainCuboid.createDimensionKeyIterator();
        while (it.hasNext()) {
            Aggregator[] aggs = mainCuboid.getCellAggregators(it.next());
            Aggregator agg = aggs[this._runningSumMinDateMeasureIdx];
            ((Aggregator)minAgg).add(agg);
        }
        this._executeContext.setMinDate(minAgg.getCalendarValue());
    }

    public Integer[] getTargetMeasureFieldsIndex(boolean isForSubtotal) {
        List<Integer> ary = isForSubtotal ? this._targetMeasureFieldsIndexForSubtotal : this._targetMeasureFieldsIndex;
        return ary.toArray(new Integer[0]);
    }

    public Object calculateAfterAggregated(int measureIndex, CompositeKey dimKey, Cuboid cuboid) throws FormulaExecutingException {
        AnalyticalField field = this._measureFields.get(measureIndex);
        MetaField mf = field.getMetaField();
        if (!CalculatingFieldAggregationSupporter.isMyTarget(mf)) {
            throw new RuntimeException("The appointed measureIndex must be from getTargetMeasureFieldsIndex().");
        }
        VisitingCursor cursor = new VisitingCursor(cuboid, measureIndex);
        cursor.setCurrentDimension(dimKey);
        this._executeContext.setCoboidCursor(cursor);
        try {
            return mf.getExpr().execute((IExecuteContext)this._executeContext);
        }
        catch (ExecuteException ex) {
            throw new FormulaExecutingException(ex);
        }
    }

    private static class InterlineEnv
    implements AbstractInterlineFunction.IInterlineEnv {
        private II18nContext _i18nCtx;
        private Map<String, MetaField> _metaFields;
        private VisitingCursor _cuboidCursor;
        private Calendar _minDate;

        public InterlineEnv(II18nContext i18nCtx, Map<String, MetaField> metaFields, Calendar minDate) {
            this._i18nCtx = i18nCtx;
            this._metaFields = metaFields;
            this._minDate = minDate;
        }

        public void locate(Cuboid cuboid, int measureIndex, CompositeKey thisLineDimension) {
            this._cuboidCursor = new VisitingCursor(cuboid, measureIndex);
            this._cuboidCursor.setCurrentDimension(thisLineDimension);
        }

        @Override
        public Cuboid getCuboid() {
            return this._cuboidCursor.getCuboid();
        }

        @Override
        public int getCurrentMeasureIndex() {
            return this._cuboidCursor.getCurrentMeasureIndex();
        }

        @Override
        public CompositeKey getThisLineDimension() {
            return this._cuboidCursor.getCurrentDimention();
        }

        @Override
        public IExecuteContext createThisLineContext() {
            FormulaExecuteContext ctx = new FormulaExecuteContext(this._metaFields);
            ctx.setI18nContext(this._i18nCtx);
            ctx.setMinDate(this._minDate);
            ctx.setCoboidCursor(this._cuboidCursor);
            return ctx;
        }

        @Override
        public void previousLine(CompositeKey previousLineDimension) {
            this._cuboidCursor.setCurrentDimension(previousLineDimension);
        }
    }

    private static class FormulaExecuteContext
    extends AbstractExecuteContext {
        private Map<String, MetaField> _metaFields;
        private VisitingCursor _cuboidCursor;
        private Calendar _minDate;

        public FormulaExecuteContext(Map<String, MetaField> metaFields) {
            this._metaFields = metaFields;
        }

        public void setCoboidCursor(VisitingCursor cuboidCursor) {
            this._cuboidCursor = cuboidCursor;
        }

        public void setMinDate(Calendar minDate) {
            this._minDate = minDate;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            if (expr instanceof RefExpr) {
                String name = ((RefExpr)expr).getName();
                MetaField mf = this._metaFields.get(name);
                return mf.getExpr().execute((IExecuteContext)this);
            }
            if (expr instanceof AbstractAggregationFunction) {
                int measureIndex = ((AbstractAggregationFunction)expr).getRuntimeReplacedMeasureIndex();
                Aggregator aggr = this._cuboidCursor.getAggregator(measureIndex);
                return aggr.getValue();
            }
            if (expr instanceof AbstractInterlineFunction) {
                if (expr instanceof RunningSum) {
                    ((RunningSum)expr).setMinDate(this._minDate);
                }
                InterlineEnv env = new InterlineEnv(this.getI18nContext(), this._metaFields, this._minDate);
                env.locate(this._cuboidCursor.getCuboid(), this._cuboidCursor.getCurrentMeasureIndex(), this._cuboidCursor.getCurrentDimention());
                return ((AbstractInterlineFunction)expr).interlineExecute(env);
            }
            throw new RuntimeException("Unsupported");
        }
    }

    private static class VisitingCursor {
        private Cuboid _cuboid;
        private int _currentMeasureIndex;
        private CompositeKey _currentDimension;

        public VisitingCursor(Cuboid cuboid, int measureIndex) {
            this._cuboid = cuboid;
            this._currentMeasureIndex = measureIndex;
        }

        public void setCurrentDimension(CompositeKey dimKey) {
            this._currentDimension = dimKey;
        }

        public CompositeKey getCurrentDimention() {
            return this._currentDimension;
        }

        public Cuboid getCuboid() {
            return this._cuboid;
        }

        public int getCurrentMeasureIndex() {
            return this._currentMeasureIndex;
        }

        public Aggregator getAggregator(int measureIndex) {
            Aggregator[] aggrs = this._cuboid.getCellAggregators(this._currentDimension);
            return aggrs[measureIndex];
        }
    }
}

