/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.grammar.AbstractExecuteContext;
import com.kingdee.bos.qing.common.grammar.IExecuteContext;
import com.kingdee.bos.qing.common.grammar.exception.ExecuteException;
import com.kingdee.bos.qing.common.grammar.expr.AbstractOpExpr;
import com.kingdee.bos.qing.common.grammar.expr.IExpr;
import com.kingdee.bos.qing.common.grammar.expr.RefExpr;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.AbstractEngine;
import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.engine.Cuboid;
import com.kingdee.bos.qing.core.engine.SubCuboidKey;
import com.kingdee.bos.qing.core.engine.func.IInfluenceForTotal;
import com.kingdee.bos.qing.core.engine.func.Total;
import com.kingdee.bos.qing.core.exception.FormulaException;
import com.kingdee.bos.qing.core.exception.FormulaExecutingException;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.meta.Meta;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.core.model.meta.MetaTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class CalculatingFieldWithTotalSupporter {
    private Map<String, MetaField> _metaFields;
    private List<AnalyticalField> _measureFields;
    private int _flowingNumber = 0;
    private boolean[] _horizontalCalculatingRequest;
    private boolean[] _verticalCalculatingRequest;
    private List<Integer> _targetMeasureFieldsIndex = new ArrayList<Integer>();
    private FormulaExecuteContext _executeContext;

    CalculatingFieldWithTotalSupporter() {
    }

    public static boolean isMyTarget(MetaField mf) {
        return mf.isValidCalculation() && mf.getFormulaAggStatus() == MetaField.FormulaAggStatus.WithTotal;
    }

    public void setContext(II18nContext i18nCtx, Meta meta, List<AnalyticalField> measureFields, AbstractEngine.ISubtotalDependance subtotalDependance) {
        this._metaFields = meta.createSearchingMap();
        this._measureFields = measureFields;
        int rowDimCount = subtotalDependance.getRowDimensionFields().size();
        int colDimCount = subtotalDependance.getColumnDimensionFields().size();
        this._horizontalCalculatingRequest = new boolean[colDimCount + 1];
        this._verticalCalculatingRequest = new boolean[rowDimCount + 1];
        this._executeContext = new FormulaExecuteContext(this._metaFields, rowDimCount, colDimCount);
        this._executeContext.setI18nContext(i18nCtx);
    }

    public void deriveAssistants(AnalyticalField field, int measureIndex) {
        MetaField mf = field.getMetaField();
        if (!CalculatingFieldWithTotalSupporter.isMyTarget(mf)) {
            throw new RuntimeException("Field must be checked before.");
        }
        this.replace(mf.getExpr(), mf.getMetaTable(), field.getTotalUsing());
        this._targetMeasureFieldsIndex.add(measureIndex);
    }

    private void replace(IExpr node, MetaTable metaTable, Aggregation totalUsing) {
        if (node instanceof RefExpr) {
            String metaFieldName = ((RefExpr)node).getName();
            MetaField mf = this._metaFields.get(metaFieldName);
            if (mf.isCalculation()) {
                this.replace(mf.getExpr(), metaTable, totalUsing);
            }
        } else if (node instanceof IInfluenceForTotal) {
            AnalyticalField field = this.createReplacement(node, metaTable);
            field.setTotalUsing(totalUsing);
            int idx = this._measureFields.size();
            this._measureFields.add(field);
            ((IInfluenceForTotal)node).setRuntimeTotalInfluencedReplacedMeasureIndex(idx);
        } else if (node instanceof AbstractOpExpr) {
            IExpr[] subs;
            if (node instanceof Total) {
                Total total = (Total)node;
                this.markCalculatingRequest(total.getHGroupsOutward(), this._horizontalCalculatingRequest);
                this.markCalculatingRequest(total.getVGroupsOutward(), this._verticalCalculatingRequest);
                if (total.getTotalUsingAggregation() != null) {
                    totalUsing = total.getTotalUsingAggregation();
                }
            }
            for (IExpr sub : subs = ((AbstractOpExpr)node).getSubExprs()) {
                this.replace(sub, metaTable, totalUsing);
            }
        }
    }

    private void markCalculatingRequest(int groupsOutward, boolean[] request) {
        if (groupsOutward > 0 && request.length > 0) {
            int idx = groupsOutward;
            int maxIdx = request.length - 1;
            idx = idx > maxIdx ? maxIdx : idx;
            request[idx] = true;
        }
    }

    private AnalyticalField createReplacement(IExpr expr, MetaTable metaTable) {
        String fieldPureName = this.createId();
        MetaField mf = new MetaField();
        mf.setMetaTable(metaTable);
        mf.setPureName(fieldPureName);
        mf.setFormula(expr.encode());
        mf.setDataType(Meta.confirmMetaFieldDataType(expr));
        mf.setExpr(expr);
        ArrayList<String> refQueue = new ArrayList<String>();
        refQueue.add(mf.getFullName());
        HashSet<String> dependence = new HashSet<String>();
        try {
            MetaField.FormulaAggStatus aggStatus = Meta.checkingWrapper(expr, this._metaFields, dependence, refQueue);
            mf.setFormulaAggStatus(aggStatus);
        }
        catch (FormulaException ex) {
            mf.setInvalid(true);
        }
        mf.setAllDependence(dependence);
        AnalyticalField field = new AnalyticalField();
        field.bindMetaField(mf);
        field.setName(mf.getFullName());
        field.setAggregation(Aggregation.AGG);
        field.setRole("measure");
        return field;
    }

    private String createId() {
        return "qing_total_replacement_" + ++this._flowingNumber;
    }

    public boolean[] getHorizontalCalculatingRequest() {
        return this._horizontalCalculatingRequest;
    }

    public boolean[] getVerticalCalculatingRequest() {
        return this._verticalCalculatingRequest;
    }

    public Integer[] getTargetMeasureFieldsIndex() {
        return this._targetMeasureFieldsIndex.toArray(new Integer[0]);
    }

    public Object calculateAfterSubtotal(int measureIndex, CompositeKey dimKey, Cuboid currentCuboid, boolean[] currnetCuboidTag, Cuboid mainCuboid, Map<SubCuboidKey, Cuboid> subCuboids) throws FormulaExecutingException {
        AnalyticalField field = this._measureFields.get(measureIndex);
        MetaField mf = field.getMetaField();
        if (!CalculatingFieldWithTotalSupporter.isMyTarget(mf)) {
            throw new RuntimeException("The appointed measureIndex must be from getTargetMeasureFieldsIndex().");
        }
        VisitingCursor cursor = new VisitingCursor(currentCuboid, dimKey);
        TotalVisitingCursorCreator factory = new TotalVisitingCursorCreator(currnetCuboidTag, mainCuboid, subCuboids);
        this._executeContext.setCoboidCursor(cursor, factory);
        try {
            return mf.getExpr().execute((IExecuteContext)this._executeContext);
        }
        catch (ExecuteException ex) {
            throw new FormulaExecutingException(ex);
        }
    }

    private static class FormulaExecuteContext
    extends AbstractExecuteContext {
        private Map<String, MetaField> _metaFields;
        private int _rowDimCount;
        private int _colDimCount;
        private VisitingCursor _normalCursor;
        private TotalVisitingCursorCreator _totalCursorFactory;
        private VisitingCursor _currentCursor;

        public FormulaExecuteContext(Map<String, MetaField> metaFields, int rowDimCount, int colDimCount) {
            this._metaFields = metaFields;
            this._rowDimCount = rowDimCount;
            this._colDimCount = colDimCount;
        }

        public void setCoboidCursor(VisitingCursor cursor, TotalVisitingCursorCreator factory) {
            this._normalCursor = cursor;
            this._totalCursorFactory = factory;
            this._currentCursor = this._normalCursor;
        }

        public Object getValue(IExpr expr) throws ExecuteException {
            if (expr instanceof RefExpr) {
                String name = ((RefExpr)expr).getName();
                MetaField mf = this._metaFields.get(name);
                return mf.getExpr().execute((IExecuteContext)this);
            }
            if (expr instanceof IInfluenceForTotal) {
                int measureIndex = ((IInfluenceForTotal)expr).getRuntimeTotalInfluencedReplacedMeasureIndex();
                return this._currentCursor.getAggregatedValue(measureIndex);
            }
            if (expr instanceof Total) {
                this.beforeTotal((Total)expr);
                Object value = ((Total)expr).getParamAggregatingTarget().execute((IExecuteContext)this);
                this.afterTotal();
                return value;
            }
            throw new RuntimeException("Unsupported");
        }

        private void afterTotal() {
            this._currentCursor = this._normalCursor;
        }

        private void beforeTotal(Total expr) {
            boolean[] rowTag = this.makeTag(this._rowDimCount, expr.getVGroupsOutward());
            boolean[] colTag = this.makeTag(this._colDimCount, expr.getHGroupsOutward());
            boolean[] dimTag = new boolean[this._rowDimCount + this._colDimCount];
            System.arraycopy(rowTag, 0, dimTag, 0, this._rowDimCount);
            System.arraycopy(colTag, 0, dimTag, this._rowDimCount, this._colDimCount);
            this._currentCursor = this._totalCursorFactory.create(this._normalCursor.getCurrentCombinedMembers(), dimTag);
        }

        private boolean[] makeTag(int dimensionFields, int groupsOutward) {
            boolean[] tag = new boolean[dimensionFields];
            for (int i = 0; i < tag.length; ++i) {
                int idx = tag.length - i - 1;
                tag[idx] = i >= groupsOutward;
            }
            return tag;
        }
    }

    private static class TotalVisitingCursorCreator {
        private boolean[] _currnetCuboidTag;
        private Cuboid _mainCuboid;
        private Map<SubCuboidKey, Cuboid> _subCuboids;

        public TotalVisitingCursorCreator(boolean[] currnetCuboidTag, Cuboid mainCuboid, Map<SubCuboidKey, Cuboid> subCuboids) {
            this._currnetCuboidTag = currnetCuboidTag;
            this._mainCuboid = mainCuboid;
            this._subCuboids = subCuboids;
        }

        public VisitingCursor create(CompositeKey sourceDimKey, boolean[] dimTag) {
            int i;
            boolean allDetail = true;
            boolean[] mergedDimTag = new boolean[dimTag.length];
            CompositeKey dimKey = new CompositeKey();
            for (i = 0; i < dimTag.length; ++i) {
                boolean requestDetail = dimTag[i];
                boolean hasDetail = this._currnetCuboidTag == null || this._currnetCuboidTag[i];
                boolean merged = requestDetail && hasDetail;
                dimKey.addMember(merged ? sourceDimKey.getMember(i) : "com.kingdee.bos.qing.All");
                mergedDimTag[i] = merged;
                allDetail = allDetail && merged;
            }
            int c = sourceDimKey.getMemberCount();
            for (i = dimTag.length; i < c; ++i) {
                dimKey.addMember(sourceDimKey.getMember(i));
            }
            Cuboid cuboid = allDetail ? this._mainCuboid : this._subCuboids.get(SubCuboidKey.createSearchingKey(mergedDimTag));
            return new VisitingCursor(cuboid, dimKey);
        }
    }

    private static class VisitingCursor {
        private Cuboid _cuboid;
        private CompositeKey _combinedMembers;

        public VisitingCursor(Cuboid currentCuboid, CompositeKey dimKey) {
            this._cuboid = currentCuboid;
            this._combinedMembers = dimKey;
        }

        public CompositeKey getCurrentCombinedMembers() {
            return this._combinedMembers;
        }

        public Object getAggregatedValue(int measureIndex) {
            Aggregator[] aggrs = this._cuboid.getCellAggregators(this._combinedMembers);
            Object value = aggrs[measureIndex].getValue();
            return value;
        }
    }
}

