/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import java.util.ArrayList;
import java.util.List;

public class CompositeKey {
    public static final int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.INT + OccupyByte.BOOLEAN);
    private List<Object> _dims = new ArrayList<Object>();
    private int _hashCode;
    private boolean _isDirty = true;

    public void addMember(Object member) {
        this._dims.add(member);
        this._isDirty = true;
    }

    public void pushMember(Object member) {
        this._dims.add(0, member);
        this._isDirty = true;
    }

    public Object getMember(int index) {
        return this._dims.get(index);
    }

    public int getMemberCount() {
        return this._dims.size();
    }

    public CompositeKey[] split(int firstN) {
        CompositeKey first = this;
        CompositeKey second = null;
        if (firstN >= 0 && firstN < this.getMemberCount()) {
            first = new CompositeKey();
            second = new CompositeKey();
            for (int i = 0; i < this._dims.size(); ++i) {
                Object member = this._dims.get(i);
                if (i < firstN) {
                    first.addMember(member);
                    continue;
                }
                second.addMember(member);
            }
        }
        return new CompositeKey[]{first, second};
    }

    public CompositeKey copy() {
        CompositeKey inst = new CompositeKey();
        for (int i = 0; i < this._dims.size(); ++i) {
            Object member = this._dims.get(i);
            inst.addMember(member);
        }
        return inst;
    }

    public int hashCode() {
        if (this._isDirty) {
            this._isDirty = false;
            this._hashCode = 0;
            for (int i = 0; i < this._dims.size(); ++i) {
                Object member = this._dims.get(i);
                this._hashCode = this._hashCode * 31 + (member == null ? "" : member).hashCode();
            }
        }
        return this._hashCode;
    }

    public boolean equals(Object another) {
        if (!(another instanceof CompositeKey) || this._dims.size() != ((CompositeKey)another)._dims.size()) {
            return false;
        }
        for (int i = 0; i < this._dims.size(); ++i) {
            Object member = this._dims.get(i);
            Object anotherMember = ((CompositeKey)another)._dims.get(i);
            if (!(member == null ? anotherMember != null : !member.equals(anotherMember))) continue;
            return false;
        }
        return true;
    }
}

