/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.Aggregator;
import com.kingdee.bos.qing.core.engine.CompositeKey;
import com.kingdee.bos.qing.core.model.analysis.common.Aggregation;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Cuboid {
    public static final int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 3) + OccupyByte.ARRAYLIST * 2 + OccupyByte.HASHMAP;
    private static final int HEAPSIZE_OVERHEAD_PER_CELL = CompositeKey.HEAPSIZE_OVERHEAD + OccupyByte.MAP_ENTRY + OccupyByte.ARRAY;
    private List<AnalyticalField> _dimensionFields;
    private List<AnalyticalField> _measureFields;
    protected Map<CompositeKey, Aggregator[]> _cells = new HashMap<CompositeKey, Aggregator[]>();
    private List<Aggregation> _appointedAggregations;

    public void setDimensionFields(List<AnalyticalField> fields) {
        this._dimensionFields = fields;
    }

    public List<AnalyticalField> getDimensionFields() {
        return this._dimensionFields;
    }

    public AnalyticalField getDimensionField(int indexAtDimension) {
        return this._dimensionFields.get(indexAtDimension);
    }

    public void setMeasureFields(List<AnalyticalField> fields) {
        this._measureFields = fields;
    }

    public List<AnalyticalField> getMeasureFields() {
        return this._measureFields;
    }

    public AnalyticalField getMeasureField(int indexAtMeasure) {
        return this._measureFields.get(indexAtMeasure);
    }

    public void setAppointedAggregations(List<Aggregation> aggregations) {
        this._appointedAggregations = aggregations;
    }

    public List<Aggregation> getAppointedAggregations() {
        return this._appointedAggregations;
    }

    public Aggregator[] getNullableCellAggregators(CompositeKey dimKey) {
        Aggregator[] aggregators = this._cells.get(dimKey);
        return aggregators;
    }

    public Aggregator[] getCellAggregators(CompositeKey dimKey) {
        Aggregator[] aggregators = this._cells.get(dimKey);
        if (aggregators == null) {
            aggregators = this.createAggregators();
            this._cells.put(dimKey, aggregators);
        }
        return aggregators;
    }

    private Aggregator[] createAggregators() {
        int measureCount = this._measureFields.size();
        Aggregator[] aggregators = new Aggregator[measureCount];
        for (int k = 0; k < measureCount; ++k) {
            Aggregation aggregation;
            if (this._appointedAggregations == null) {
                AnalyticalField measureField = this._measureFields.get(k);
                aggregation = measureField.getAggregation();
            } else {
                aggregation = this._appointedAggregations.get(k);
            }
            aggregators[k] = Aggregator.create(aggregation);
        }
        return aggregators;
    }

    public Iterator<CompositeKey> createDimensionKeyIterator() {
        return this._cells.keySet().iterator();
    }

    public int getCellCount() {
        return this._cells.size();
    }

    public int getHeapSizePerCell() {
        Aggregator[] aggregators;
        int heapSize = HEAPSIZE_OVERHEAD_PER_CELL;
        for (Aggregator aggregator : aggregators = this.createAggregators()) {
            heapSize += aggregator.getHeapSize();
        }
        return heapSize;
    }
}

