/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.core.engine.AbstractRuntimeFilter;
import com.kingdee.bos.qing.core.engine.DetailCombinationRuntimePushdownFilter;
import com.kingdee.bos.qing.core.engine.MetaRecognizer;
import com.kingdee.bos.qing.core.engine.RuntimePushdownFilter;
import com.kingdee.bos.qing.core.exception.AnalysisException;
import com.kingdee.bos.qing.core.exception.ConfigCeilingException;
import com.kingdee.bos.qing.core.exception.DataEmptyException;
import com.kingdee.bos.qing.core.exception.DataTraversalException;
import com.kingdee.bos.qing.core.exception.DataTraversalTimeoutException;
import com.kingdee.bos.qing.core.exception.DataUnanalysableException;
import com.kingdee.bos.qing.core.exception.UserStoppedException;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.analysis.common.filter.AbstractAnalyticalFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousDateFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.ContinuousFilter;
import com.kingdee.bos.qing.core.model.analysis.common.filter.DiscreteFilter;
import com.kingdee.bos.qing.core.model.meta.MetaField;
import com.kingdee.bos.qing.datasource.meta.DSFieldKey;
import com.kingdee.bos.qing.datasource.model.filter.AbstractUnderDSFilter;
import com.kingdee.bos.qing.datasource.model.filter.DetailCombinationFilter;
import com.kingdee.bos.qing.datasource.model.filter.IPushdownFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSContinuousFilter;
import com.kingdee.bos.qing.datasource.model.filter.UnderDSDiscreteFilter;
import com.kingdee.bos.qing.datasource.spec.IDataIterator;
import com.kingdee.bos.qing.datasource.spec.IDataSourceVisitor;
import com.kingdee.bos.qing.datasource.spec.IMetaVisitor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSourceTraversal {
    private SubDataSourceCacheInfo _cacheInfo;
    private IDataSourceVisitor _dataSourceVisitor;
    private MetaRecognizer _metaRecognizer;
    private Set<IPushdownFilter> _filters = new HashSet<IPushdownFilter>();
    private IDataCounter _dataCounter;

    public DataSourceTraversal(IDataSourceVisitor dataSourceVisitor) {
        this._dataSourceVisitor = dataSourceVisitor;
    }

    public MetaRecognizer getMetaRecognizer() {
        if (this._metaRecognizer == null) {
            this._metaRecognizer = new MetaRecognizer((IMetaVisitor)this._dataSourceVisitor);
        }
        return this._metaRecognizer;
    }

    public void setDataCounter(IDataCounter dataCounter) {
        this._dataCounter = dataCounter;
    }

    public void setSubDataSourceCacheInfo(SubDataSourceCacheInfo cacheInfo) {
        this._cacheInfo = cacheInfo;
    }

    public void addPushdownFilters(List<AbstractRuntimeFilter.IRuntimePushdownFilter> rtPushdownFilters) {
        if (rtPushdownFilters == null || rtPushdownFilters.isEmpty()) {
            return;
        }
        for (AbstractRuntimeFilter.IRuntimePushdownFilter rtPushdownFilter : rtPushdownFilters) {
            if (rtPushdownFilter instanceof RuntimePushdownFilter) {
                this._filters.add((IPushdownFilter)this.createUnderDsFilter((RuntimePushdownFilter)rtPushdownFilter));
                continue;
            }
            if (!(rtPushdownFilter instanceof DetailCombinationRuntimePushdownFilter)) continue;
            this._filters.add((IPushdownFilter)this.createDetailCombinationFilter((DetailCombinationRuntimePushdownFilter)rtPushdownFilter));
        }
    }

    private DetailCombinationFilter createDetailCombinationFilter(DetailCombinationRuntimePushdownFilter rtFilter) {
        ArrayList<DSFieldKey> fields = new ArrayList<DSFieldKey>();
        List<MetaField> metaFields = rtFilter.getFields();
        for (MetaField mf : metaFields) {
            DSFieldKey field = new DSFieldKey(mf.getMetaTable().getName(), mf.getPureName());
            fields.add(field);
        }
        Set<List<String>> items = rtFilter.getItems();
        DetailCombinationFilter pushdownFilter = new DetailCombinationFilter(fields, items);
        return pushdownFilter;
    }

    private AbstractUnderDSFilter createUnderDsFilter(RuntimePushdownFilter rtFilter) {
        AnalyticalField field = rtFilter.getField();
        AbstractAnalyticalFilter analyticalFilter = rtFilter.getFilter();
        MetaField mf = field.getMetaField();
        DSFieldKey dsField = new DSFieldKey(mf.getMetaTable().getName(), mf.getPureName());
        if (analyticalFilter instanceof DiscreteFilter) {
            DiscreteFilter discreteFilter = (DiscreteFilter)analyticalFilter;
            if (field.isParentChildDimension()) {
                dsField = new DSFieldKey(mf.getMetaTable().getName(), field.getParentChildDimensionIdField().getPureName());
            }
            PartValue partValue = field.getPartValue();
            UnderDSDiscreteFilter.PartValue newPartValue = null;
            if (partValue != null) {
                switch (partValue) {
                    case DATE_YEAR: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_YEAR;
                        break;
                    }
                    case DATE_QUARTER: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_QUARTER;
                        break;
                    }
                    case DATE_MONTH: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_MONTH;
                        break;
                    }
                    case DATE_DAY: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_DAY;
                        break;
                    }
                    case DATE_YQ: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_YQ;
                        break;
                    }
                    case DATE_YM: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_YM;
                        break;
                    }
                    case DATE_YMD: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_YMD;
                        break;
                    }
                    case DATE_EXACT: {
                        newPartValue = UnderDSDiscreteFilter.PartValue.DATE_EXACT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Something must be wrong.");
                    }
                }
            }
            UnderDSDiscreteFilter underDSDiscreteFilter = new UnderDSDiscreteFilter(dsField);
            underDSDiscreteFilter.setPartValue(newPartValue);
            underDSDiscreteFilter.setFullValue(discreteFilter.isFullValue());
            underDSDiscreteFilter.setFiscalYearStart(field.getFiscalYearStart());
            underDSDiscreteFilter.setExclude(discreteFilter.isExclude());
            underDSDiscreteFilter.setSelected(discreteFilter.getSelecteds());
            return underDSDiscreteFilter;
        }
        if (analyticalFilter instanceof ContinuousFilter) {
            ContinuousFilter continuousFilter = (ContinuousFilter)analyticalFilter;
            UnderDSContinuousFilter underDSDiscreteFilter = new UnderDSContinuousFilter(dsField);
            underDSDiscreteFilter.setFullValue(continuousFilter.isFullValue());
            underDSDiscreteFilter.setContainNull(continuousFilter.isContainNull());
            underDSDiscreteFilter.setCeiling((Object)continuousFilter.getCeiling());
            underDSDiscreteFilter.setFloor((Object)continuousFilter.getFloor());
            return underDSDiscreteFilter;
        }
        if (analyticalFilter instanceof ContinuousDateFilter) {
            ContinuousDateFilter continuousFilter = (ContinuousDateFilter)analyticalFilter;
            UnderDSContinuousFilter underDSDiscreteFilter = new UnderDSContinuousFilter(dsField);
            underDSDiscreteFilter.setFullValue(continuousFilter.isFullValue());
            underDSDiscreteFilter.setContainNull(continuousFilter.isContainNull());
            Calendar dateTo = Calendar.getInstance();
            dateTo.setTimeInMillis(continuousFilter.getDateTo());
            underDSDiscreteFilter.setCeiling((Object)dateTo);
            Calendar dateFrom = Calendar.getInstance();
            dateFrom.setTimeInMillis(continuousFilter.getDateFrom());
            underDSDiscreteFilter.setFloor((Object)dateFrom);
            return underDSDiscreteFilter;
        }
        throw new RuntimeException("Modify here.");
    }

    public void traversal() throws UserStoppedException, DataEmptyException, DataUnanalysableException, DataTraversalTimeoutException, ConfigCeilingException, DataTraversalException, AnalysisException {
        String subDataSourceCacheKey = null == this._cacheInfo ? null : this._cacheInfo.getSubDataSourceCacheKey();
        long rowCount = 0L;
        try (IDataIterator iterator = null;){
            iterator = this._dataSourceVisitor.iterator();
            iterator.init(this.getMetaRecognizer().getTraversalFields(), this._filters, subDataSourceCacheKey);
            while (iterator.hasNextRow()) {
                Map row = iterator.nextRow();
                this._dataCounter.countOneRow(row);
                if (null == this._cacheInfo) continue;
                ++rowCount;
            }
        }
        if (null != this._cacheInfo) {
            this._cacheInfo.setRowCount(rowCount);
        }
    }

    public static class SubDataSourceCacheInfo {
        private long _totalRowNums;
        private String _subDataSourceCacheKey;

        public long getRowCount() {
            return this._totalRowNums;
        }

        public void setRowCount(long totalRowNums) {
            this._totalRowNums = totalRowNums;
        }

        public String getSubDataSourceCacheKey() {
            return this._subDataSourceCacheKey;
        }

        public void setSubDataSourceCacheKey(String subDataSourceCacheKey) {
            this._subDataSourceCacheKey = subDataSourceCacheKey;
        }
    }

    public static interface IDataCounter {
        public void countOneRow(Map<String, ?> var1) throws AnalysisException;
    }
}

