/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.qing.core.engine;

import com.kingdee.bos.qing.common.format.Formater;
import com.kingdee.bos.qing.common.i18n.II18nContext;
import com.kingdee.bos.qing.core.engine.DateProcesser;
import com.kingdee.bos.qing.core.engine.FilterPreparedValueGainer;
import com.kingdee.bos.qing.core.engine.ParentChildDimensionMember;
import com.kingdee.bos.qing.core.engine.SortableCompositeMember;
import com.kingdee.bos.qing.core.engine.sort.CommonComparator;
import com.kingdee.bos.qing.core.i18n.Messages;
import com.kingdee.bos.qing.core.model.analysis.common.AnalyticalField;
import com.kingdee.bos.qing.core.model.analysis.common.PartValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.AbstractPreparedValue;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.DiscreteSelectableValues;
import com.kingdee.bos.qing.core.model.exhibition.common.filter.TreeSelectableValues;
import com.kingdee.bos.qing.core.model.meta.DataType;
import com.kingdee.bos.qing.monitor.heapsize.OccupyByte;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class DiscretePreparedValueGainer
extends FilterPreparedValueGainer.AbstractPreparedValueGainer {
    private int HEAPSIZE_OVERHEAD = OccupyByte.align(OccupyByte.OBJECT + OccupyByte.REFERENCE * 4 + OccupyByte.BOOLEAN) + OccupyByte.OBJECT + OccupyByte.REFERENCE + OccupyByte.HASHMAP;
    private II18nContext _i18nCtx;
    private boolean _isToSort = false;
    private boolean _isAsc = true;
    private boolean _isEmptyAhead = true;
    private Set<Object> _nonDuplicatedValue = new HashSet<Object>();

    public DiscretePreparedValueGainer(AnalyticalField field, II18nContext i18nCtx) {
        super(field);
        this._i18nCtx = i18nCtx;
    }

    public void setToSort(boolean toSort) {
        this._isToSort = toSort;
    }

    public void setEmptyAheadAlways(boolean isEmptyAhead) {
        this._isEmptyAhead = isEmptyAhead;
    }

    public void setAsc(boolean isAsc) {
        this._isAsc = isAsc;
    }

    @Override
    protected void doGain(Object value) {
        this._nonDuplicatedValue.add(value);
    }

    @Override
    public FilterPreparedValueGainer.IPreparedValueFruit getFruit() {
        if (this.isTreeStructure()) {
            TreeFruit fruit = new TreeFruit(this._nonDuplicatedValue);
            if (this._isToSort) {
                fruit.setSorter(new TreeNodeSorter(this._i18nCtx.getLanManager().getLocale()));
            }
            return fruit;
        }
        Formater formater = this.initFormater();
        FilterPreparedValueGainer.IDateReprocessing reprocessing = this.initReprocessing();
        Comparable[] valueArray = this._nonDuplicatedValue.toArray(new Comparable[0]);
        if (this._isToSort) {
            CommonComparator sorter = this.createComparator(this._i18nCtx.getLanManager().getLocale());
            sorter.setEmptyAheadAlways(this._isEmptyAhead);
            Comparator<Comparable<?>> cpt = this._isAsc ? sorter : new ReversedComparator(sorter);
            Arrays.sort(valueArray, cpt);
        }
        return this.createListFruit(formater, reprocessing, valueArray);
    }

    protected CommonComparator createComparator(Locale locale) {
        return new CommonComparator(locale);
    }

    protected FilterPreparedValueGainer.IPreparedValueFruit createListFruit(Formater formater, FilterPreparedValueGainer.IDateReprocessing reprocessing, Comparable<?>[] valueArray) {
        return new ListFruit(valueArray, this._i18nCtx, formater, reprocessing, this.getUsableDisplayField());
    }

    protected AnalyticalField getValueField() {
        return super.getField();
    }

    protected AnalyticalField getUsableDisplayField() {
        return super.getField();
    }

    protected boolean isTreeStructure() {
        return this.getValueField().isParentChildDimension();
    }

    public int getItemsCount() {
        return this._nonDuplicatedValue.size();
    }

    private Formater initFormater() {
        String formatString;
        if (DataType.STRING != this.getUsableDisplayField().getDataType() && (formatString = this.getUsableDisplayField().getUsableFormat(this._i18nCtx)) != null && formatString.length() > 0) {
            Formater formater = new Formater(formatString);
            formater.setI18nContext(this._i18nCtx);
            return formater;
        }
        return null;
    }

    private FilterPreparedValueGainer.IDateReprocessing initReprocessing() {
        if (DataType.DATE == this.getValueField().getDataType() && this.getValueField().getPartValue() != null) {
            return new DateProcesser(this.getValueField());
        }
        return null;
    }

    @Override
    public long estimateHeapSize(int reserved) {
        return (long)this.HEAPSIZE_OVERHEAD + (long)(OccupyByte.MAP_ENTRY + (this.isTreeStructure() ? TreeSelectableValues.Node.HEAPSIZE_OVERHEAD : DiscreteSelectableValues.Item.HEAPSIZE_OVERHEAD)) * (long)(this._nonDuplicatedValue.size() + reserved);
    }

    private static class TreeNode
    implements Comparable<TreeNode> {
        private ParentChildDimensionMember _member;
        private boolean _isSelected;
        private List<TreeNode> _children;

        public TreeNode(ParentChildDimensionMember member, boolean isSelected) {
            this._member = member;
            this._isSelected = isSelected;
        }

        public ParentChildDimensionMember getMember() {
            return this._member;
        }

        public void addChild(TreeNode child) {
            if (this._children == null) {
                this._children = new ArrayList<TreeNode>();
            }
            this._children.add(child);
        }

        public void addChildren(Set<TreeNode> children) {
            for (TreeNode child : children) {
                this.addChild(child);
            }
        }

        public void transform(List<TreeSelectableValues.Node> list, int level, TreeNodeSorter sorter) {
            TreeSelectableValues.Node node = new TreeSelectableValues.Node();
            node.setValue(this._member.getIdValue() == null ? null : this._member.getIdValue().toString());
            node.setText(this._member.getDisplayValue() == null ? "" : this._member.getDisplayValue().toString());
            node.setLevel(level);
            node.setSelected(this._isSelected);
            list.add(node);
            if (this._children != null) {
                TreeNode[] childrenArray = this._children.toArray(new TreeNode[0]);
                if (sorter != null) {
                    Arrays.sort(childrenArray, sorter);
                }
                for (TreeNode child : childrenArray) {
                    child.transform(list, level + 1, sorter);
                }
            }
        }

        @Override
        public int compareTo(TreeNode o) {
            return 0;
        }
    }

    private static class TreeFruit
    implements FilterPreparedValueGainer.IPreparedValueFruit {
        private ParentChildDimensionMember[] _members;
        private TreeNodeSorter _sorter;

        public TreeFruit(Set<Object> nonDuplicatedValue) {
            this._members = nonDuplicatedValue.toArray(new ParentChildDimensionMember[0]);
        }

        public void setSorter(TreeNodeSorter sorter) {
            this._sorter = sorter;
        }

        @Override
        public boolean isGainerInvalid() {
            return false;
        }

        @Override
        public AbstractPreparedValue getPreparedValue() {
            HashMap<Object, TreeNode> mapNodes = new HashMap<Object, TreeNode>();
            HashMap<Object, Set<TreeNode>> mapTempParent = new HashMap<Object, Set<TreeNode>>();
            for (int i = 0; i < this._members.length; ++i) {
                ParentChildDimensionMember member = this._members[i];
                this.makeTreeNode(mapNodes, mapTempParent, member, true);
            }
            AbstractPreparedValue pv = this.makePreparedValue(mapTempParent);
            return pv;
        }

        private void makeTreeNode(Map<Object, TreeNode> mapNodes, Map<Object, Set<TreeNode>> mapTempParent, ParentChildDimensionMember member, boolean isSelected) {
            Object idValue = member.getIdValue();
            Object parentIdValue = member.getParentIdValue();
            TreeNode treeNode = new TreeNode(member, isSelected);
            TreeNode parentTreeNode = mapNodes.get(parentIdValue);
            if (parentTreeNode == null) {
                Set<TreeNode> tempParent = mapTempParent.get(parentIdValue);
                if (tempParent == null) {
                    tempParent = new TreeSet<TreeNode>(this._sorter);
                    mapTempParent.put(parentIdValue, tempParent);
                }
                tempParent.add(treeNode);
            } else {
                parentTreeNode.addChild(treeNode);
            }
            Set<TreeNode> parentInsteadBefore = mapTempParent.remove(idValue);
            if (parentInsteadBefore != null) {
                treeNode.addChildren(parentInsteadBefore);
            }
            mapNodes.put(idValue, treeNode);
        }

        private AbstractPreparedValue makePreparedValue(Map<Object, Set<TreeNode>> mapTempParent) {
            Set<TreeNode> rootSet = mapTempParent.remove(null);
            if (rootSet == null) {
                rootSet = mapTempParent.remove("");
            }
            ArrayList<TreeNode> rootList = new ArrayList<TreeNode>();
            if (rootSet != null) {
                TreeNode[] roots = rootSet.toArray(new TreeNode[0]);
                if (this._sorter != null) {
                    Arrays.sort(roots, this._sorter);
                }
                rootList.addAll(Arrays.asList(roots));
            }
            ArrayList<TreeNode> temp = new ArrayList<TreeNode>();
            Iterator<Object> keys = mapTempParent.keySet().iterator();
            while (keys.hasNext()) {
                Set<TreeNode> orphanSet = mapTempParent.get(keys.next());
                temp.addAll(orphanSet);
            }
            TreeNode[] orphans = temp.toArray(new TreeNode[0]);
            if (this._sorter != null) {
                Arrays.sort(orphans, this._sorter);
            }
            rootList.addAll(Arrays.asList(orphans));
            ArrayList<TreeSelectableValues.Node> pareparedValueNodes = new ArrayList<TreeSelectableValues.Node>();
            for (TreeNode tn : rootList) {
                tn.transform(pareparedValueNodes, 0, this._sorter);
            }
            TreeSelectableValues tsv = new TreeSelectableValues();
            tsv.setValues(pareparedValueNodes);
            return tsv;
        }
    }

    private static class ListFruit
    implements FilterPreparedValueGainer.IPreparedValueFruit {
        private Object[] _members;
        private II18nContext _i18nCtx;
        private Formater _formater;
        private FilterPreparedValueGainer.IDateReprocessing _reprocessing;
        private AnalyticalField _field;

        public ListFruit(Object[] valueArray, II18nContext i18nCtx, Formater formater, FilterPreparedValueGainer.IDateReprocessing reprocessing, AnalyticalField field) {
            this._members = valueArray;
            this._i18nCtx = i18nCtx;
            this._formater = formater;
            this._reprocessing = reprocessing;
            this._field = field;
        }

        @Override
        public boolean isGainerInvalid() {
            return false;
        }

        @Override
        public AbstractPreparedValue getPreparedValue() {
            ArrayList<DiscreteSelectableValues.Item> items = new ArrayList<DiscreteSelectableValues.Item>(this._members.length);
            for (int i = 0; i < this._members.length; ++i) {
                Object value = this.getValueFromMember(this._members[i]);
                DiscreteSelectableValues.Item item = new DiscreteSelectableValues.Item();
                if (value == null || "".equals(value)) {
                    item.setText(this._i18nCtx == null ? null : Messages.getLangMessage(this._i18nCtx, "dataNull", "\uff08\u7a7a\uff09"));
                } else if (this._formater == null) {
                    item.setText(null);
                } else {
                    String formated;
                    if (value instanceof Calendar && this._reprocessing != null) {
                        int formatingPart = PartValue.constraintFormating(this._field.getPartValue());
                        formated = this._formater.format((Calendar)value, formatingPart);
                    } else {
                        formated = this._formater.format(value);
                    }
                    item.setText(formated);
                }
                if (value == null) {
                    item.setValue(null);
                } else {
                    item.setValue(this._reprocessing == null ? value.toString() : this._reprocessing.toPromissoryValue(value));
                }
                item.setSelected(true);
                items.add(item);
            }
            DiscreteSelectableValues dsv = new DiscreteSelectableValues();
            dsv.setValues(items);
            return dsv;
        }

        private Object getValueFromMember(Object member) {
            if (member instanceof SortableCompositeMember) {
                return ((SortableCompositeMember)member).getValue();
            }
            return member;
        }
    }

    private static class TreeNodeSorter
    implements Comparator<TreeNode> {
        private CommonComparator _comparer;

        public TreeNodeSorter(Locale locale) {
            this._comparer = new CommonComparator(locale);
            this._comparer.setEmptyAheadAlways(true);
        }

        @Override
        public int compare(TreeNode node1, TreeNode node2) {
            Comparable v1 = (Comparable)node1.getMember().getSortAccordingValue();
            Comparable v2 = (Comparable)node2.getMember().getSortAccordingValue();
            return this._comparer.compare(v1, v2);
        }
    }

    private static class ReversedComparator
    implements Comparator<Comparable<?>> {
        private CommonComparator _real;

        public ReversedComparator(CommonComparator real) {
            this._real = real;
        }

        @Override
        public int compare(Comparable<?> o1, Comparable<?> o2) {
            int result = this._real.compare(o1, o2);
            if (this._real.isReversedEnabled()) {
                result = -result;
            }
            return result;
        }
    }
}

